<?php
get_header();
include get_template_directory() . '/inc/menus/menu.php';
?>


<main role="main">
<?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>

<section class="hero-section" style="background-image: url('<?php echo esc_url($backgroundImg[0]); ?>');">
    <!-- Bigger floating spiritual elements -->
    <div class="spiritual-element cross" style="top:15%; left:5%; animation-delay:0s;">✝</div>
    <div class="spiritual-element dove" style="top:25%; right:10%; animation-delay:1s;">🕊</div>
    <div class="spiritual-element halo" style="bottom:30%; left:65%; animation-delay:2s;">☀</div>
    <div class="spiritual-element cross" style="bottom:20%; right:5%; animation-delay:1.5s;">✟</div>
    <div class="spiritual-element dove" style="top:60%; left:20%; animation-delay:2.5s;">🕊</div>
    
    <div class="hero-overlay">
        <div class="hero-content">
            <h1 class="hero-title"><?php the_title(); ?></h1>
            <div class="hero-breadcrumb">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>


</section>



<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <?php the_content(); ?>
        <!-- Add this inside your <body> -->
<div class="floating-circles">
  <span></span>
  <span></span>
  <span></span>
  <span></span>
  <span></span>
</div>
    </article>
<?php endwhile; endif; ?>

</main>

<?php get_footer(); ?>