<?php
function allPartners_shortcode($atts) {
    ob_start(); // Start output buffering
    
    
    $atts = shortcode_atts(
        array(
            'category' => '', // Default to empty string if not specified
            'number' => 20, // Default number of posts per page
            'order' => 'RAND', //Default Descending order
        ),
        $atts,
        'partner'
    );

    // Custom query to retrieve Partners
    $partners_args = array(
        'post_type' => 'partner',
        'posts_per_page' => $atts['number'], // Number of posts per page
        'orderby' => 'date', // Order by date
        'order' => $atts['order'], // order
    );

    // Check if category attribute is provided and not empty
    if (!empty($atts['category'])) {
        $partners_args['tax_query'] = array(
            array(
                'taxonomy' => 'partner_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

	?>																
	<?php $partners_query = new WP_Query($partners_args);?>
		<?php if ($partners_query->have_posts()) : ?>
		<div class="row">
			<?php while ($partners_query->have_posts()) :
				$partners_query->the_post();
				$categories = get_the_category();
				$post_id        = get_the_ID();
                $link        = get_post_meta(get_the_ID(), '_website', true);
			?>
			<div class="col-xl-3 col-lg-4 col-sm-6 kpy-news">
				<article>
					
						<div class="card shadow-sm mb-3 border-0" data-aos="fade-up">
							<div class="post-thumbnail">
								<?php // Display the post thumbnail
									if (has_post_thumbnail()) {
										the_post_thumbnail('medium'); 
									}else{
										echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="KWE2" class="img-fluid"/>';
									}
								?>
								
							</div>
							<div class="card-body">
								<h3><?php the_title(); ?></h3>
								<a href="<?= $link; ?>" class="text-dark" style="font-size:12px" target="_blank">Visit Website</a>
							</div><!-- card body !-->
						</div><!-- card !-->
						
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No Partners  found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('all_funders', 'allPartners_shortcode');

?>