<?php /* Template Name: Contact Page Template */ get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
    
    // Handle form submission
    if (isset($_POST['contact_submitted'])) {
        $name = sanitize_text_field($_POST['contact_name']);
        $email = sanitize_email($_POST['contact_email']);
        $phone = sanitize_text_field($_POST['contact_phone']);
        $subject = sanitize_text_field($_POST['contact_subject']);
        $message = sanitize_textarea_field($_POST['contact_message']);
        
        $post_content = "Name: $name\n";
        $post_content .= "Email: $email\n";
        $post_content .= "Phone: $phone\n";
        $post_content .= "Subject: $subject\n\n";
        $post_content .= "Message:\n$message";
        
        $contact_post = array(
            'post_title' => 'New Contact: ' . $name . ' - ' . $subject,
            'post_content' => $post_content,
            'post_status' => 'private',
            'post_type' => 'contact_submission',
        );
        
        $post_id = wp_insert_post($contact_post);
        
        if ($post_id) {
            $submission_success = true;
        }
    }
?>

<main role="main">
    
<?php 
$backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); 
?>
   

<section class="hero-section" style="background-image: url('<?php echo esc_url($backgroundImg[0]); ?>'); background-size: cover; background-position: center; position: relative;">
    
    <div class="hero-overlay-uegcl"></div>
    <div class="hero-content-uegcl">
        <div class="container-xxl">
            <h1 class="page-hero-title-uegcl"><?php the_title(); ?></h1>
            <p class="page-hero-subtitle-uegcl">20 years of Generating for GENERATIONS</p>
            <div class="page-hero-breadcrumb-uegcl">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>
</section>


<div class="alt-contact-container">
    <?php if (have_posts()): while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php the_content(); ?>
            
            <?php if (isset($submission_success) && $submission_success): ?>
            <div class="alt-contact-success-popup">
                <div class="alt-success-content">
                    <div class="alt-checkmark">
                        <svg viewBox="0 0 52 52">
                            <circle cx="26" cy="26" r="25" fill="var(--kpy-primary)"/>
                            <path fill="none" stroke="#fff" stroke-width="4" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
                        </svg>
                    </div>
                    <h3>Message Sent!</h3>
                    <p>We've received your message and will respond soon. Thank you for contacting UEGCL.</p>
                    <button class="alt-close-popup">Close</button>
                </div>
            </div>
            <?php endif; ?>
        </article>
    <?php endwhile; endif; ?>
    
    <!-- Contact Section with Parallax Background -->
    <section class="alt-contact-main-section">
        <div class="alt-contact-parallax-bg"></div>
        <div class="alt-contact-overlay"></div>
        <div class="alt-contact-content-wrapper">
            <!-- Two Column Layout -->
            <div class="alt-contact-two-column">
                <!-- Left Column - Contact Info -->
                <div class="alt-contact-info-col">
                    <div class="alt-contact-info-card">
                        <h3 class="alt-contact-info-title">Our Information</h3>
                        <p class="alt-contact-intro">Have any questions, comments or suggestions? At UEGCL, we pledge to provide all our stakeholders with the necessary assistance. Contact our Help desk today with any requests or questions.</p>
                        
                        <div class="alt-contact-info-item">
                            <div class="alt-contact-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--kpy-primary)">
                                    <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                                </svg>
                            </div>
                            <div class="alt-contact-text">
                                <h4>Location</h4>
                                <p>Block C Plot 6-9 Okot Close Bukoto<br>Victoria Office, Kampala<br>P.O.Box 75831, Kampala</p>
                            </div>
                        </div>
                        
                        <div class="alt-contact-info-item">
                            <div class="alt-contact-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--kpy-primary)">
                                    <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                                </svg>
                            </div>
                            <div class="alt-contact-text">
                                <h4>Email Us</h4>
                                <p>Info@uegcl.go.ug</p>
                            </div>
                        </div>
                        
                        <div class="alt-contact-info-item">
                            <div class="alt-contact-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--kpy-primary)">
                                    <path d="M20.01 15.38c-1.23 0-2.42-.2-3.53-.56-.35-.12-.74-.03-1.01.24l-1.57 1.97c-2.83-1.35-5.48-3.9-6.89-6.83l1.95-1.66c.27-.28.35-.67.24-1.02-.37-1.11-.56-2.3-.56-3.53 0-.54-.45-.99-.99-.99H4.19C3.65 3 3 3.24 3 3.99 3 13.28 10.73 21 20.01 21c.71 0 .99-.63.99-1.18v-3.45c0-.54-.45-.99-.99-.99z"/>
                                </svg>
                            </div>
                            <div class="alt-contact-text">
                                <h4>Call Us</h4>
                                <p>+256 (0) 312 372165</p>
                            </div>
                        </div>
                        
                        <div class="alt-contact-description">
                            <p>You can also reach out to a member of our team with your issues and have our experts work closely with you to address or fix it.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Right Column - Contact Form -->
                <div class="alt-contact-form-col">
                    <div class="alt-contact-form-card">
                        <h3 class="alt-form-title">Send Us a Message</h3>
                        <p class="alt-form-subtitle">Fill out the form below and we'll respond as soon as possible.</p>
                        
                        <form id="alt-contact-form" method="post" class="alt-contact-form">
                            <div class="alt-form-group">
                                <label for="alt_contact_name">Your Name <span>*</span></label>
                                <input type="text" id="alt_contact_name" name="contact_name" required>
                            </div>
                            
                            <div class="alt-form-row">
                                <div class="alt-form-group alt-form-half">
                                    <label for="alt_contact_email">Email Address <span>*</span></label>
                                    <input type="email" id="alt_contact_email" name="contact_email" required>
                                </div>
                                <div class="alt-form-group alt-form-half">
                                    <label for="alt_contact_phone">Phone Number</label>
                                    <input type="tel" id="alt_contact_phone" name="contact_phone">
                                </div>
                            </div>
                            
                            <div class="alt-form-group">
                                <label for="alt_contact_subject">Subject <span>*</span></label>
                                <input type="text" id="alt_contact_subject" name="contact_subject" required>
                            </div>
                            
                            <div class="alt-form-group">
                                <label for="alt_contact_message">Your Message <span>*</span></label>
                                <textarea id="alt_contact_message" name="contact_message" rows="6" required></textarea>
                            </div>
                            
                            <div class="alt-form-submit">
                                <button type="submit" name="contact_submitted" class="alt-submit-btn">
                                    Send Message
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Full Width Map Section -->
    <section class="alt-contact-map-section">
        <div class="alt-contact-map-card">
            <h3 class="alt-map-title">Find Our Office</h3>
            <div class="alt-map-container">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3988.808156227057!2d36.82114631475395!3d-1.292385635979157!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x182f10d664f5b3c9%3A0x4e3e1a3d5f8b3b1d!2sFaith%20Avenue!5e0!3m2!1sen!2ske!4v1620000000000!5m2!1sen!2ske" 
                        width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            </div>
            <div class="alt-map-directions">
                <a href="https://maps.google.com?daddr=Block+C+Plot+6-9+Okot+Close+Bukoto+Kampala" target="_blank" class="alt-directions-btn">
                    Get Directions to Our Office
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </a>
            </div>
        </div>
    </section>
</div>

</main>

<script>
jQuery(document).ready(function($) {
    <?php if (isset($submission_success) && $submission_success): ?>
        $('.alt-contact-success-popup').addClass('active');
    <?php endif; ?>
    
    $('.alt-close-popup').on('click', function() {
        $('.alt-contact-success-popup').removeClass('active');
    });
});
</script>

<?php get_footer(); ?>