<?php 
    get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
?>
<main role="main">
<?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
    
<!-- Hero Section -->
<div class="sing-hero-section">
    <div class="sing-hero-animated-bg"></div>
    <div class="sing-hero-overlay"></div>
    <div class="sing-hero-content">
        <div class="sing-container-xxl">
            <div class="sing-row sing-justify-content-center">
                <div class="sing-col-lg-10 sing-text-center sing-entry-title" data-aos="fade-up">
                    <h1 class="sing-page-hero-title"><?php the_title(); ?></h1>
                    <div class="sing-hero-meta">
                        <div class="sing-meta-group">
                            <span class="sing-meta-item">
                                <i class="bi bi-calendar3"></i>
                                <?php the_time('F j, Y'); ?>
                            </span>
                            <span class="sing-meta-divider">•</span>
                            <span class="sing-meta-item">
                                <i class="bi bi-clock"></i>
                                <?php echo do_shortcode('[reading_time]'); ?> min read
                            </span>
                            <span class="sing-meta-divider">•</span>
                            <span class="sing-meta-item">
                                <i class="bi bi-person"></i>
                                <?php the_author(); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="sing-hero-wave-bottom"></div>
</div>

<!-- Main Content Layout -->
<div class="psu-main-layout">
    <div class="psu-container">
        <div class="psu-content-grid">
            <!-- Main Article Content -->
            <article class="psu-article-main" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <?php if (have_posts()): while (have_posts()) : the_post(); ?>
                
                <!-- Featured Image -->
                <?php if (has_post_thumbnail()) : ?>
                <div class="psu-featured-image" data-aos="fade-up">
                    <?php the_post_thumbnail('large', array('class' => 'psu-featured-img')); ?>
                    <div class="psu-image-overlay"></div>
                </div>
                <?php endif; ?>

                <!-- Article Content -->
                <div class="psu-article-content" data-aos="fade-up">
                    <div class="psu-content-wrapper">
                        <?php the_content(); ?>
                    </div>

                    <!-- Article Tags -->
                    <?php if(has_tag()) : ?>
                    <div class="psu-tags-section" data-aos="fade-up">
                        <h4 class="psu-tags-title">Article Tags</h4>
                        <div class="psu-tags-container">
                            <?php the_tags('', '', ''); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Social Share Horizontal -->
                    <div class="psu-social-share-horizontal" data-aos="fade-up">
                        <span class="psu-share-label">Share this article:</span>
                        <div class="psu-share-buttons">
                            <a class="psu-share-btn psu-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                <i class="bi bi-facebook"></i>
                                <span>Facebook</span>
                            </a>
                            <a class="psu-share-btn psu-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                <i class="bi bi-twitter-x"></i>
                                <span>Twitter</span>
                            </a>
                            <a class="psu-share-btn psu-linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="LinkedIn">
                                <i class="bi bi-linkedin"></i>
                                <span>LinkedIn</span>
                            </a>
                            <a class="psu-share-btn psu-whatsapp" href="whatsapp://send?text=Check out this article: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                <i class="bi bi-whatsapp"></i>
                                <span>WhatsApp</span>
                            </a>
                        </div>
                    </div>
                </div>

                <?php endwhile; ?>
                <?php else: ?>
                
                <!-- No Content -->
                <div class="psu-no-content">
                    <h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>
                </div>
                
                <?php endif; ?>

                <?php edit_post_link(); ?>
            </article>

            <!-- Sidebar -->
            <aside class="psu-article-sidebar">
                <!-- Available Jobs -->
                <div class="psu-jobs-widget" data-aos="fade-left">
                    <div class="psu-sidebar-header">
                        <h3 class="psu-sidebar-title">Available Jobs</h3>
                    </div>
                    <div class="psu-jobs-list">
                        <?php
                        // You can replace this with actual job posts or custom post type query
                        $job_posts = get_posts(array(
                            'numberposts' => 3,
                            'post_type' => 'job', // Change to your job post type
                            'post_status' => 'publish',
                            'meta_query' => array(
                                array(
                                    'key' => 'job_status',
                                    'value' => 'open',
                                    'compare' => '='
                                )
                            )
                        ));
                        
                        if ($job_posts) :
                            foreach ($job_posts as $post) :
                            setup_postdata($post);
                            $job_location = get_post_meta($post->ID, 'job_location', true);
                            $job_type = get_post_meta($post->ID, 'job_type', true);
                        ?>
                        <article class="psu-job-item">
                            <div class="psu-job-icon">
                                <i class="bi bi-briefcase"></i>
                            </div>
                            <div class="psu-job-content">
                                <h4 class="psu-job-title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h4>
                                <div class="psu-job-meta">
                                    <?php if($job_location): ?>
                                    <span class="psu-job-location">
                                        <i class="bi bi-geo-alt"></i>
                                        <?php echo $job_location; ?>
                                    </span>
                                    <?php endif; ?>
                                    <?php if($job_type): ?>
                                    <span class="psu-job-type"><?php echo $job_type; ?></span>
                                    <?php endif; ?>
                                </div>
                                <a href="<?php the_permalink(); ?>" class="psu-job-apply">Apply Now</a>
                            </div>
                        </article>
                        <?php
                            endforeach;
                            wp_reset_postdata();
                        else :
                        ?>
                        <div class="psu-no-jobs">
                            <i class="bi bi-briefcase"></i>
                            <p>No current job openings</p>
                            <small>Check back later for new opportunities</small>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="psu-jobs-footer">
                        <a href="<?php echo home_url('/careers/'); ?>" class="psu-view-all-jobs">
                            View All Opportunities
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>

                <!-- Categories Widget -->
                <div class="psu-categories-widget" data-aos="fade-left" data-aos-delay="100">
                    <div class="psu-sidebar-header">
                        <h3 class="psu-sidebar-title">News Categories</h3>
                    </div>
                    <div class="psu-categories-list">
                        <?php
                        $specific_categories = array('news', 'genews', 'uegcl-in-press', 'press-releases');
                        
                        foreach ($specific_categories as $category_slug) :
                            $category = get_category_by_slug($category_slug);
                            if ($category) :
                        ?>
                        <a href="<?php echo get_category_link($category->term_id); ?>" class="psu-category-item">
                            <span class="psu-category-name">
                                <?php 
                                $display_names = array(
                                    'news' => 'News',
                                    'genews' => 'GENews',
                                    'uegcl-in-press' => 'UEGCL in Press',
                                    'press-releases' => 'Press Releases'
                                );
                                echo $display_names[$category_slug] ?? $category->name; 
                                ?>
                            </span>
                            <span class="psu-category-count">(<?php echo $category->count; ?>)</span>
                        </a>
                        <?php
                            endif;
                        endforeach;
                        ?>
                    </div>
                </div>

                <!-- Newsletter Signup -->
                <div class="psu-newsletter-card" data-aos="fade-left" data-aos-delay="200">
                    <div class="psu-newsletter-icon">
                        <i class="bi bi-envelope-check"></i>
                    </div>
                    <h3 class="psu-newsletter-title">Stay Updated</h3>
                    <p class="psu-newsletter-desc">Get the latest articles and insights delivered to your inbox.</p>
                    <form class="psu-newsletter-form" id="psu-newsletter-form">
                        <div class="psu-form-group">
                            <input type="email" name="email" placeholder="Enter your email" class="psu-newsletter-input" required>
                            <div class="psu-form-message"></div>
                        </div>
                        <button type="submit" class="psu-newsletter-btn">
                            <span class="psu-btn-text">Subscribe</span>
                            <span class="psu-btn-loading" style="display: none;">
                                <i class="bi bi-arrow-repeat"></i> Processing...
                            </span>
                        </button>
                    </form>
                </div>
            </aside>
        </div>
    </div>
</div>

<!-- Related Articles -->
<section class="psu-related-section">
    <div class="psu-container">
        <div class="psu-section-header" data-aos="fade-up">
            <h2 class="psu-section-title">Related Articles</h2>
            <p class="psu-section-subtitle">Continue reading with these related posts</p>
        </div>
        
        <div class="psu-related-grid">
            <?php
            $latest_posts = get_posts(array(
                'numberposts' => 3, 
                'post_status' => 'publish', 
                'exclude' => array(get_the_ID())
            ));
            
            if ($latest_posts) :
                $delay = 0;
                foreach ($latest_posts as $post) :
                setup_postdata($post);
                $thumbnail_url = get_the_post_thumbnail_url($post->ID, 'medium');
            ?>
            <article class="psu-related-card" data-aos="fade-up" data-aos-delay="<?php echo $delay; ?>">
                <div class="psu-related-image">
                    <img src="<?php echo $thumbnail_url ?: 'https://via.placeholder.com/400x250'; ?>" alt="<?php the_title(); ?>">
                    <div class="psu-related-overlay">
                        <a href="<?php the_permalink(); ?>" class="psu-related-link">
                            <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <div class="psu-related-content">
                    <div class="psu-related-meta">
                        <span class="psu-related-date"><?php the_time('M j, Y'); ?></span>
                    </div>
                    <h3 class="psu-related-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                    <p class="psu-related-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 12); ?></p>
                    <a href="<?php the_permalink(); ?>" class="psu-read-more">
                        Read More
                        <i class="bi bi-arrow-right-short"></i>
                    </a>
                </div>
            </article>
            <?php
                $delay += 100;
                endforeach;
                wp_reset_postdata();
            else :
            ?>
            <div class="psu-no-related" data-aos="fade-up">
                <i class="bi bi-newspaper"></i>
                <p>No related articles available at the moment.</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
</main>

<style>


/* Hero Section */
.sing-hero-section{position:relative;overflow:hidden;min-height:450px;display:flex;align-items:center;justify-content:center}
.sing-hero-animated-bg{position:absolute;top:0;left:0;right:0;bottom:0;background-color:var(--kpy-primary);animation:sing-zoomMotion 10s ease-in-out infinite;z-index:1}
.sing-hero-section::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:#00000059;z-index:2}
.sing-hero-overlay{position:absolute;top:0;left:0;right:0;bottom:0;z-index:2}
.sing-hero-content{position:relative;z-index:3;padding:100px 0;text-align:center;width:100%}
.sing-page-hero-title{font-size:2.2rem;font-weight:500;margin-bottom:1.5rem;color:#ffffff;line-height:1.5; width:85%; margin:0 auto;}
.sing-hero-meta{margin-top:2rem}
.sing-meta-group{display:flex;align-items:center;justify-content:center;gap:1rem;flex-wrap:wrap}
.sing-meta-item{display:flex;align-items:center;gap:0.5rem;color:rgba(255,255,255,0.9);font-size:0.95rem}
.sing-meta-item i{color:var(--kpy-secondary);font-size:1.1rem}
.sing-meta-divider{color:var(--kpy-secondary);font-weight:bold}
.sing-hero-wave-bottom{position:absolute;bottom:0;left:0;width:100%;height:100px;background:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 100"><path fill="%23ffffff" d="M0,0 C200,100 600,0 1000,100 1440,0 1440,100 1440,100 L1440,100 L0,100 Z"></path></svg>') no-repeat bottom center;background-size:cover;z-index:4}
@keyframes sing-zoomMotion{0%,100%{transform:scale(1)}50%{transform:scale(1.05)}}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const newsletterForm = document.getElementById('psu-newsletter-form');
    const submitBtn = newsletterForm.querySelector('.psu-newsletter-btn');
    const btnText = submitBtn.querySelector('.psu-btn-text');
    const btnLoading = submitBtn.querySelector('.psu-btn-loading');
    const messageDiv = newsletterForm.querySelector('.psu-form-message');

    newsletterForm.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const email = this.querySelector('input[name="email"]').value;
        
        // Validate email
        if (!isValidEmail(email)) {
            showMessage('Please enter a valid email address.', 'error');
            return;
        }

        // Show loading state
        btnText.style.display = 'none';
        btnLoading.style.display = 'flex';
        submitBtn.disabled = true;

        try {
            const response = await fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    'action': 'psu_subscribe_newsletter',
                    'email': email,
                    'nonce': '<?php echo wp_create_nonce("psu_newsletter_nonce"); ?>'
                })
            });

            const data = await response.json();

            if (data.success) {
                showMessage(data.data.message, 'success');
                newsletterForm.reset();
            } else {
                showMessage(data.data, 'error');
            }
        } catch (error) {
            showMessage('An error occurred. Please try again.', 'error');
        } finally {
            // Hide loading state
            btnText.style.display = 'flex';
            btnLoading.style.display = 'none';
            submitBtn.disabled = false;
        }
    });

    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }

    function showMessage(message, type) {
        messageDiv.textContent = message;
        messageDiv.className = 'psu-form-message ' + type;
        messageDiv.style.display = 'block';

        setTimeout(() => {
            messageDiv.style.display = 'none';
        }, 5000);
    }
});
</script>

<?php get_footer(); ?>