<section class="main-slider" id="hero-slider">
    <?php
    $slider_query = new WP_Query([
        'post_type'      => 'slides',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
        'post_status'    => 'publish'
    ]);
    ?>
    
    <div class="swiper-container thm-swiper__slider" id="main-slider-swiper">
        <div class="swiper-wrapper">
            <?php if ($slider_query->have_posts()): ?>
                <?php while ($slider_query->have_posts()): $slider_query->the_post();
                    $title = get_the_title();
                    $url = get_permalink();
                    $backgroundImg = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?>
                    <div class="swiper-slide">
                        <?php if ($backgroundImg): ?>
                            <div class="image-layer kenburns-animation" style="background-image: url('<?php echo esc_url($backgroundImg); ?>');"></div>
                        <?php else: ?>
                            <div class="image-layer kenburns-animation" style="background-color: #333;"></div>
                        <?php endif; ?>
                        <div class="slider-overlay"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-content">
                                        <div class="main-slider-content__inner">
                                            <h2 class="slide-title"><?php echo esc_html($title); ?></h2>
                                            <div class="hero-buttons">
                                                <a href="<?php echo esc_url($url); ?>" class="buttons buttons-primary">Learn More</a>
                                                <a href="<?php echo esc_url($url); ?>" class="buttons buttons-secondary">UEGCL Services</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="swiper-slide">
                    <div class="image-layer kenburns-animation" style="background-color: #333;"></div>
                    <div class="slider-overlay"></div>
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="main-slider-content">
                                    <div class="main-slider-content__inner">
                                        <h2 class="slide-title">No Slides Found</h2>
                                        <div class="hero-buttons">
                                            <a href="<?php echo admin_url('edit.php?post_type=slides'); ?>" class="buttons buttons-primary">Add Slides</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Pagination Dots -->
        <div class="swiper-pagination" id="main-slider-pagination"></div>
        
        <!-- Scroll Button - Goes to next slide -->
        <!--<div class="scroll-button" id="scroll-to-next-slide">-->
        <!--    <div class="scroll-circle">-->
        <!--        <span class="scroll-text">SCROLL</span>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <?php wp_reset_postdata(); ?>
</section>

<style>
.main-slider{position:relative;overflow:hidden}
.swiper-container{width:100%;height:100vh;position:relative}
.swiper-slide{position:relative;overflow:hidden}
.image-layer{position:absolute;top:0;left:0;width:100%;height:100%;background-size:cover;background-position:center;background-repeat:no-repeat}
.kenburns-animation{animation:kenburns 20s ease-out infinite alternate;transform-origin:center}@keyframes kenburns{0%{transform:scale(1) translate(0,0)}100%{transform:scale(1.2) translate(-5%,-5%)}}
.swiper-slide:nth-child(odd) .kenburns-animation{animation:kenburns-alt 20s ease-out infinite alternate}@keyframes kenburns-alt{0%{transform:scale(1.2) translate(5%,5%)}100%{transform:scale(1) translate(0,0)}}
.slider-overlay{position:absolute;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.4);z-index:1}.main-slider-content{position:relative;z-index:2;height:100vh;display:flex;align-items:center;justify-content:center}
.main-slider-content__inner{text-align:center;color:var(--kpy-white)}
.slide-title{font-size:3.5rem;font-weight:bold;margin-bottom:2rem;color:var(--kpy-white);text-shadow:2px 2px 4px rgba(0,0,0,0.5)}
.hero-buttons{display:flex;gap:1rem;justify-content:center;flex-wrap:wrap}
.buttons{padding:12px 30px;text-decoration:none;border-radius:5px;font-weight:600;transition:all 0.3s ease;display:inline-block}
.buttons-primary{background:var(--kpy-primary,#D32F2F);color:var(--kpy-white);border:2px solid var(--kpy-primary,#D32F2F)}
.buttons-primary:hover{background:var(--kpy-primary-dark,#B71C1C);border-color:var(--kpy-primary-dark,#B71C1C);transform:translateY(-2px);box-shadow:0 4px 8px rgba(0,0,0,0.3)}
.buttons-secondary{background:transparent;color:var(--kpy-white);border:2px solid var(--kpy-white)}.buttons-secondary:hover{background:var(--kpy-white);color:#333;transform:translateY(-2px);box-shadow:0 4px 8px rgba(0,0,0,0.3)}
.swiper-pagination{position:absolute;bottom:40px;left:50%;transform:translateX(-50%);z-index:10;display:flex;gap:10px}
.swiper-pagination-bullet{width:14px;height:14px;background:rgba(255,255,255,0.5);opacity:1;border-radius:50%;cursor:pointer;transition:all 0.3s ease;border:2px solid transparent}
.swiper-pagination-bullet:hover{background:rgba(255,255,255,0.8);transform:scale(1.2)}
.swiper-pagination-bullet-active{background:var(--kpy-primary,#D32F2F);border-color:var(--kpy-white);transform:scale(1.3)}
.scroll-button{position:absolute;bottom:100px;left:50%;transform:translateX(-50%);z-index:10;cursor:pointer}
.scroll-circle{width:80px;height:80px;border:2px dotted var(--kpy-white);border-radius:50%;display:flex;align-items:center;justify-content:center;animation:pulse 2s infinite;background:rgba(0,0,0,0.3);transition:all 0.3s ease}
.scroll-button:hover .scroll-circle{background:rgba(255,255,255,0.2);transform:scale(1.1)}
.scroll-text{color:var(--kpy-white);font-size:12px;font-weight:bold;letter-spacing:1px;transition:color 0.3s ease}@keyframes pulse{0%,100%{box-shadow:0 0 0 0 rgba(255,255,255,0.7)}50%{box-shadow:0 0 0 15px rgba(255,255,255,0)}}@media(max-width:768px){.slide-title{font-size:2rem}
.hero-buttons{flex-direction:column;align-items:center}
.buttons{min-width:200px;text-align:center}
.scroll-button{bottom:80px}.scroll-circle{width:60px;height:60px}
.scroll-text{font-size:10px}
.swiper-pagination{bottom:20px}}@media(max-width:480px){.slide-title{font-size:1.5rem;margin-bottom:1.5rem}
.buttons{padding:10px 20px;font-size:14px}}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Swiper
    var mainSlider = new Swiper('#main-slider-swiper', {
        slidesPerView: 1,
        loop: true,
        speed: 1000,
        spaceBetween: 0,
        effect: 'slide',
        grabCursor: true,
        watchSlidesProgress: true,
        pagination: {
            el: '#main-slider-pagination',
            type: 'bullets',
            clickable: true
        },
        autoplay: {
            delay: 5000,
            disableOnInteraction: false
        }
    });
    
    // Scroll button goes to next slide
    var scrollButton = document.getElementById('scroll-to-next-slide');
    if (scrollButton) {
        scrollButton.addEventListener('click', function() {
            mainSlider.slideNext();
        });
    }
});
</script>