<?php
// Custom Post Type: BOARD MEMBERS
function custom_post_type_board_members(){
    $labels = array(
        'name' => __('Board Members', 'kipya'),
        'add_new_item' => __('Add New Board Member', 'kipya'),
        'add_new' => __('Add New Member', 'kipya'),
        'edit_item' => __('Edit Member', 'kipya'),
        'update_item' => __('Update Member', 'kipya'),
        'all_items' => __('All Board Members', 'kipya'),
        'search_items' => __('Search Members', 'kipya'),
        'singular_name' => __('Board Member'),
    );
    $supports = array('title', 'editor', 'thumbnail');
    $args = array(
        'labels' => $labels,
        'description' => 'Board Members Directory',
        'supports' => $supports,
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 10,
        'menu_icon' => 'dashicons-groups',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'capability_type' => 'post',
    );
    register_post_type('board_members', $args);

    add_action('add_meta_boxes_board_members', 'add_custom_meta_boxes_board_position');
    add_action('add_meta_boxes_board_members', 'add_custom_meta_boxes_board_socials');

    $taxonomy_labels = array(
        'name' => _x('Board Categories', 'taxonomy general name'),
        'singular_name' => _x('Board Category', 'taxonomy singular name'),
        'search_items' => __('Search Categories'),
        'all_items' => __('All Categories'),
        'edit_item' => __('Edit Category'),
        'update_item' => __('Update Category'),
        'add_new_item' => __('Add New Category'),
        'new_item_name' => __('New Category Name'),
        'menu_name' => __('Board Categories'),
    );
    $taxonomy_args = array(
        'hierarchical' => true,
        'labels' => $taxonomy_labels,
        'show_ui' => true,
        'show_in_rest' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'board-category'),
    );
    register_taxonomy('board_category', 'board_members', $taxonomy_args);
}
add_action('init', 'custom_post_type_board_members');

// Custom Post Type: MANAGEMENT TEAM
function custom_post_type_management_team(){
    $labels = array(
        'name' => __('Management Team', 'kipya'),
        'add_new_item' => __('Add New Management Member', 'kipya'),
        'add_new' => __('Add New Member', 'kipya'),
        'edit_item' => __('Edit Member', 'kipya'),
        'update_item' => __('Update Member', 'kipya'),
        'all_items' => __('All Management Team', 'kipya'),
        'search_items' => __('Search Members', 'kipya'),
        'singular_name' => __('Management Member'),
    );
    $supports = array('title', 'editor', 'thumbnail');
    $args = array(
        'labels' => $labels,
        'description' => 'Management Team Directory',
        'supports' => $supports,
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 11,
        'menu_icon' => 'dashicons-businessperson',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'capability_type' => 'post',
    );
    register_post_type('management_team', $args);

    add_action('add_meta_boxes_management_team', 'add_custom_meta_boxes_management_position');
    add_action('add_meta_boxes_management_team', 'add_custom_meta_boxes_management_socials');

    $taxonomy_labels = array(
        'name' => _x('Management Categories', 'taxonomy general name'),
        'singular_name' => _x('Management Category', 'taxonomy singular name'),
        'search_items' => __('Search Categories'),
        'all_items' => __('All Categories'),
        'edit_item' => __('Edit Category'),
        'update_item' => __('Update Category'),
        'add_new_item' => __('Add New Category'),
        'new_item_name' => __('New Category Name'),
        'menu_name' => __('Management Categories'),
    );
    $taxonomy_args = array(
        'hierarchical' => true,
        'labels' => $taxonomy_labels,
        'show_ui' => true,
        'show_in_rest' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'management-category'),
    );
    register_taxonomy('management_category', 'management_team', $taxonomy_args);
}
add_action('init', 'custom_post_type_management_team');

// Custom Post Type: UNIT HEADS
function custom_post_type_unit_heads(){
    $labels = array(
        'name' => __('Unit Heads', 'kipya'),
        'add_new_item' => __('Add New Unit Head', 'kipya'),
        'add_new' => __('Add New Head', 'kipya'),
        'edit_item' => __('Edit Head', 'kipya'),
        'update_item' => __('Update Head', 'kipya'),
        'all_items' => __('All Unit Heads', 'kipya'),
        'search_items' => __('Search Heads', 'kipya'),
        'singular_name' => __('Unit Head'),
    );
    $supports = array('title', 'editor', 'thumbnail');
    $args = array(
        'labels' => $labels,
        'description' => 'Unit Heads Directory',
        'supports' => $supports,
        'hierarchical' => false,
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'show_in_admin_bar' => true,
        'menu_position' => 12,
        'menu_icon' => 'dashicons-admin-users',
        'can_export' => true,
        'has_archive' => true,
        'exclude_from_search' => false,
        'capability_type' => 'post',
    );
    register_post_type('unit_heads', $args);

    add_action('add_meta_boxes_unit_heads', 'add_custom_meta_boxes_unit_position');
    add_action('add_meta_boxes_unit_heads', 'add_custom_meta_boxes_unit_socials');

    $taxonomy_labels = array(
        'name' => _x('Unit Categories', 'taxonomy general name'),
        'singular_name' => _x('Unit Category', 'taxonomy singular name'),
        'search_items' => __('Search Categories'),
        'all_items' => __('All Categories'),
        'edit_item' => __('Edit Category'),
        'update_item' => __('Update Category'),
        'add_new_item' => __('Add New Category'),
        'new_item_name' => __('New Category Name'),
        'menu_name' => __('Unit Categories'),
    );
    $taxonomy_args = array(
        'hierarchical' => true,
        'labels' => $taxonomy_labels,
        'show_ui' => true,
        'show_in_rest' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'unit-category'),
    );
    register_taxonomy('unit_category', 'unit_heads', $taxonomy_args);
}
add_action('init', 'custom_post_type_unit_heads');

// Order custom post types by date (first published appears first)
function order_custom_post_types_by_date($query) {
    if (!is_admin() && $query->is_main_query()) {
        if (is_post_type_archive('board_members') || $query->get('post_type') == 'board_members') {
            $query->set('orderby', 'date');
            $query->set('order', 'ASC');
        }
        if (is_post_type_archive('management_team') || $query->get('post_type') == 'management_team') {
            $query->set('orderby', 'date');
            $query->set('order', 'ASC');
        }
        if (is_post_type_archive('unit_heads') || $query->get('post_type') == 'unit_heads') {
            $query->set('orderby', 'date');
            $query->set('order', 'ASC');
        }
    }
}
add_action('pre_get_posts', 'order_custom_post_types_by_date');

// Meta Box Functions for Board Members
function add_custom_meta_boxes_board_position() { add_meta_box('position_details', 'Position Details', 'render_custom_meta_box_board_position', 'board_members', 'normal', 'high'); }
function render_custom_meta_box_board_position($post) { $position = get_post_meta($post->ID, '_position', true); ?>
<div style="margin-bottom:15px;"><label for="position"><b>Position / Title</b></label><br/><input type="text" id="position" name="position" style="width: 100%;" value="<?= esc_attr($position); ?>" placeholder="e.g., Chairman"></div>
<?php }
function save_custom_meta_box_board_position($post_id) { if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return; if (!current_user_can('edit_post', $post_id)) return; if (isset($_POST['position'])) { update_post_meta($post_id, '_position', sanitize_text_field($_POST['position'])); } }
add_action('save_post_board_members', 'save_custom_meta_box_board_position');

function add_custom_meta_boxes_board_socials() { add_meta_box('social_details', 'Social Media Links', 'render_custom_meta_box_board_socials', 'board_members', 'normal', 'high'); }
function render_custom_meta_box_board_socials($post) { $facebook = get_post_meta($post->ID, '_facebook', true); $linkedin = get_post_meta($post->ID, '_linkedin', true); $instagram = get_post_meta($post->ID, '_instagram', true); $x = get_post_meta($post->ID, '_x', true); ?>
<div class="row"><div style="width: 50%; margin-bottom:10px;float:left;"><label for="facebook"><b>Facebook</b></label><input type="text" id="facebook" name="facebook" style="width: 90%;" value="<?= esc_attr($facebook); ?>" placeholder="https://facebook.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="twitter"><b>X / Twitter</b></label><input type="text" id="twitter" name="x" style="width: 90%;" value="<?= esc_attr($x); ?>" placeholder="https://twitter.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="insta"><b>Instagram</b></label><input type="text" id="insta" name="instagram" style="width: 90%;" value="<?= esc_attr($instagram); ?>" placeholder="https://instagram.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="linkedin"><b>LinkedIn</b></label><input type="text" id="linkedin" name="linkedin" style="width: 90%;" value="<?= esc_attr($linkedin); ?>" placeholder="https://linkedin.com/..."></div></div>
<?php }
function save_custom_meta_box_board_socials($post_id) { if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return; if (!current_user_can('edit_post', $post_id)) return; $fields = array('facebook', 'linkedin', 'instagram', 'x'); foreach ($fields as $field) { if (isset($_POST[$field])) { update_post_meta($post_id, '_' . $field, esc_url_raw($_POST[$field])); } else { update_post_meta($post_id, '_' . $field, ''); } } }
add_action('save_post_board_members', 'save_custom_meta_box_board_socials');

// Meta Box Functions for Management Team
function add_custom_meta_boxes_management_position() { add_meta_box('position_details', 'Position Details', 'render_custom_meta_box_management_position', 'management_team', 'normal', 'high'); }
function render_custom_meta_box_management_position($post) { $position = get_post_meta($post->ID, '_management_position', true); ?>
<div style="margin-bottom:15px;"><label for="management_position"><b>Position / Title</b></label><br/><input type="text" id="management_position" name="management_position" style="width: 100%;" value="<?= esc_attr($position); ?>" placeholder="e.g., CEO"></div>
<?php }
function save_custom_meta_box_management_position($post_id) { if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return; if (!current_user_can('edit_post', $post_id)) return; if (isset($_POST['management_position'])) { update_post_meta($post_id, '_management_position', sanitize_text_field($_POST['management_position'])); } }
add_action('save_post_management_team', 'save_custom_meta_box_management_position');

function add_custom_meta_boxes_management_socials() { add_meta_box('social_details', 'Social Media Links', 'render_custom_meta_box_management_socials', 'management_team', 'normal', 'high'); }
function render_custom_meta_box_management_socials($post) { $facebook = get_post_meta($post->ID, '_management_facebook', true); $linkedin = get_post_meta($post->ID, '_management_linkedin', true); $instagram = get_post_meta($post->ID, '_management_instagram', true); $x = get_post_meta($post->ID, '_management_x', true); ?>
<div class="row"><div style="width: 50%; margin-bottom:10px;float:left;"><label for="management_facebook"><b>Facebook</b></label><input type="text" id="management_facebook" name="management_facebook" style="width: 90%;" value="<?= esc_attr($facebook); ?>" placeholder="https://facebook.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="management_twitter"><b>X / Twitter</b></label><input type="text" id="management_twitter" name="management_x" style="width: 90%;" value="<?= esc_attr($x); ?>" placeholder="https://twitter.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="management_insta"><b>Instagram</b></label><input type="text" id="management_insta" name="management_instagram" style="width: 90%;" value="<?= esc_attr($instagram); ?>" placeholder="https://instagram.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="management_linkedin"><b>LinkedIn</b></label><input type="text" id="management_linkedin" name="management_linkedin" style="width: 90%;" value="<?= esc_attr($linkedin); ?>" placeholder="https://linkedin.com/..."></div></div>
<?php }
function save_custom_meta_box_management_socials($post_id) { if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return; if (!current_user_can('edit_post', $post_id)) return; $fields = array('management_facebook', 'management_linkedin', 'management_instagram', 'management_x'); foreach ($fields as $field) { if (isset($_POST[$field])) { update_post_meta($post_id, '_' . $field, esc_url_raw($_POST[$field])); } else { update_post_meta($post_id, '_' . $field, ''); } } }
add_action('save_post_management_team', 'save_custom_meta_box_management_socials');

// Meta Box Functions for Unit Heads
function add_custom_meta_boxes_unit_position() { add_meta_box('position_details', 'Position Details', 'render_custom_meta_box_unit_position', 'unit_heads', 'normal', 'high'); }
function render_custom_meta_box_unit_position($post) { $position = get_post_meta($post->ID, '_unit_position', true); ?>
<div style="margin-bottom:15px;"><label for="unit_position"><b>Position / Title</b></label><br/><input type="text" id="unit_position" name="unit_position" style="width: 100%;" value="<?= esc_attr($position); ?>" placeholder="e.g., Head of Marketing"></div>
<?php }
function save_custom_meta_box_unit_position($post_id) { if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return; if (!current_user_can('edit_post', $post_id)) return; if (isset($_POST['unit_position'])) { update_post_meta($post_id, '_unit_position', sanitize_text_field($_POST['unit_position'])); } }
add_action('save_post_unit_heads', 'save_custom_meta_box_unit_position');

function add_custom_meta_boxes_unit_socials() { add_meta_box('social_details', 'Social Media Links', 'render_custom_meta_box_unit_socials', 'unit_heads', 'normal', 'high'); }
function render_custom_meta_box_unit_socials($post) { $facebook = get_post_meta($post->ID, '_unit_facebook', true); $linkedin = get_post_meta($post->ID, '_unit_linkedin', true); $instagram = get_post_meta($post->ID, '_unit_instagram', true); $x = get_post_meta($post->ID, '_unit_x', true); ?>
<div class="row"><div style="width: 50%; margin-bottom:10px;float:left;"><label for="unit_facebook"><b>Facebook</b></label><input type="text" id="unit_facebook" name="unit_facebook" style="width: 90%;" value="<?= esc_attr($facebook); ?>" placeholder="https://facebook.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="unit_twitter"><b>X / Twitter</b></label><input type="text" id="unit_twitter" name="unit_x" style="width: 90%;" value="<?= esc_attr($x); ?>" placeholder="https://twitter.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="unit_insta"><b>Instagram</b></label><input type="text" id="unit_insta" name="unit_instagram" style="width: 90%;" value="<?= esc_attr($instagram); ?>" placeholder="https://instagram.com/..."></div>
<div style="width: 50%; margin-bottom:10px;float:left;"><label for="unit_linkedin"><b>LinkedIn</b></label><input type="text" id="unit_linkedin" name="unit_linkedin" style="width: 90%;" value="<?= esc_attr($linkedin); ?>" placeholder="https://linkedin.com/..."></div></div>
<?php }
function save_custom_meta_box_unit_socials($post_id) { if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return; if (!current_user_can('edit_post', $post_id)) return; $fields = array('unit_facebook', 'unit_linkedin', 'unit_instagram', 'unit_x'); foreach ($fields as $field) { if (isset($_POST[$field])) { update_post_meta($post_id, '_' . $field, esc_url_raw($_POST[$field])); } else { update_post_meta($post_id, '_' . $field, ''); } } }
add_action('save_post_unit_heads', 'save_custom_meta_box_unit_socials');

// Shortcodes for each CPT
function board_members_shortcode($atts) { return generate_directory_shortcode('board_members', '_position', $atts); }
add_shortcode('board_members', 'board_members_shortcode');

function management_team_shortcode($atts) { return generate_directory_shortcode('management_team', '_management_position', $atts); }
add_shortcode('management_team', 'management_team_shortcode');

function unit_heads_shortcode($atts) { return generate_directory_shortcode('unit_heads', '_unit_position', $atts); }
add_shortcode('unit_heads', 'unit_heads_shortcode');

// Generic directory shortcode function
function generate_directory_shortcode($post_type, $position_meta, $atts) {
    $atts = shortcode_atts(array('category' => '', 'number' => 500, 'order' => 'ASC'), $atts, $post_type);
    $directory_args = array('post_type' => $post_type, 'posts_per_page' => $atts['number'], 'orderby' => 'date', 'order' => $atts['order']);
    if (!empty($atts['category'])) { $directory_args['tax_query'] = array(array('taxonomy' => $post_type . '_category', 'field' => 'slug', 'terms' => $atts['category'])); }
    $directory_query = new WP_Query($directory_args);
    ob_start(); ?>
    <div class="team-directory"><div class="container"><div class="team-grid"><?php while ($directory_query->have_posts()) : $directory_query->the_post(); $post_id = get_the_ID(); 
    $position = get_post_meta($post_id, $position_meta, true); 
    $facebook = get_post_meta($post_id, '_' . str_replace('_position', '', $position_meta) . 'facebook', true);
    $linkedin = get_post_meta($post_id, '_' . str_replace('_position', '', $position_meta) . 'linkedin', true);
    $instagram = get_post_meta($post_id, '_' . str_replace('_position', '', $position_meta) . 'instagram', true);
    $x = get_post_meta($post_id, '_' . str_replace('_position', '', $position_meta) . 'x', true);
    $bio = get_the_content(); ?>
    <div class="team-card">
        <div class="team-image-wrapper"><?php if (has_post_thumbnail()) { the_post_thumbnail('large'); } else { echo '<img src="'. get_template_directory_uri().'/assets/images/placeholder.png" alt="Team Member"/>'; } ?>
            <div class="team-overlay">
                <div class="team-overlay-content">
                    <h3 class="team-name"><?php the_title(); ?></h3>
                    <div class="team-socials">
                        <?php if ($facebook) : ?><a href="<?= esc_url($facebook); ?>" target="_blank" class="social-link"><i class="fab fa-facebook-f"></i></a><?php endif; ?>
                        <?php if ($x) : ?><a href="<?= esc_url($x); ?>" target="_blank" class="social-link"><i class="fab fa-twitter"></i></a><?php endif; ?>
                        <?php if ($instagram) : ?><a href="<?= esc_url($instagram); ?>" target="_blank" class="social-link"><i class="fab fa-instagram"></i></a><?php endif; ?>
                        <?php if ($linkedin) : ?><a href="<?= esc_url($linkedin); ?>" target="_blank" class="social-link"><i class="fab fa-linkedin-in"></i></a><?php endif; ?>
                    </div>
                    <?php if ($bio) : ?><button class="read-more-btn" onclick="openModal<?= $post_id; ?>()">Read More</button><?php endif; ?>
                </div>
            </div>
        </div>
        <?php if ($position) : ?><div class="team-position-under"><?= esc_html($position); ?></div><?php endif; ?>
    </div>
    <?php if ($bio) : ?>
    <div id="modal-<?= $post_id; ?>" class="team-modal" onclick="closeModal<?= $post_id; ?>()">
        <div class="modal-content" onclick="event.stopPropagation()">
            <span class="modal-close" onclick="closeModal<?= $post_id; ?>()">&times;</span>
            <div class="modal-body-container">
                <div class="modal-image-column">
                    <?php if (has_post_thumbnail()) : ?><div class="modal-image"><?php the_post_thumbnail('large'); ?></div><?php endif; ?>
                </div>
                <div class="modal-content-column">
                    <div class="modal-header">
                        <h2><?php the_title(); ?></h2>
                        <?php if ($position) : ?><p class="modal-position"><?= esc_html($position); ?></p><?php endif; ?>
                    </div>
                    <div class="modal-body"><?= wpautop($bio); ?></div>
                </div>
            </div>
        </div>
    </div>
    <script>function openModal<?= $post_id; ?>() { document.getElementById('modal-<?= $post_id; ?>').style.display = 'flex'; document.body.style.overflow = 'hidden'; } function closeModal<?= $post_id; ?>() { document.getElementById('modal-<?= $post_id; ?>').style.display = 'none'; document.body.style.overflow = 'auto'; }</script>
    <?php endif; ?>
    <?php endwhile; ?></div></div></div><?php wp_reset_postdata(); return ob_get_clean();
}
?>