<?php
/**
 * Template Name: Business Page
 * Description: Modern two-column layout with hero, structured content, and latest news.
 */

get_header();
?>

<?php include get_template_directory() . '/inc/menus/menu.php'; ?>

<?php
// Hero background image = Featured Image
if (has_post_thumbnail()) {
  $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
}
?>

<section class="hero-section" style="background-image: url('<?php echo esc_url($backgroundImg[0]); ?>'); background-size: cover; background-position: center; position: relative;">
    
    <!-- Corporate overlay -->
    <div class="hero-overlay-uegcl"></div>

    <div class="hero-content-uegcl">
        <div class="container-xxl">
            <h1 class="page-hero-title-uegcl"><?php the_title(); ?></h1>
            <p class="page-hero-subtitle-uegcl">20 years of Generating for GENERATIONS</p>
            <div class="page-hero-breadcrumb-uegcl">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>
    
    <!-- SVG Wave Bottom -->
    <div class="hero-wave-bottom"></div>
</section>



<!-- Main Layout -->
<div class="business-page-container container-xxl">

  <!-- Left Column -->
  <main class="business-content-main">

    
    <div class="content-body-business">
      <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
        <div class="business-content">
          <?php the_content(); ?>
        </div>
      <?php endwhile; endif; ?>
    </div>
  </main>

  <!-- Right Column -->
<!-- Right Column -->
<aside class="business-news-sidebar">

  <!-- 📂 Publications Section -->
  
  <!-- 📰 News Section -->
  <div class="sidebar-header">
    <h3>Latest News</h3>
  </div>

  <div class="news-list">
    <?php
      $news_query = new WP_Query([
        'category_name'  => 'news',
        'posts_per_page' => 3,
      ]);

      if ($news_query->have_posts()) :
        while ($news_query->have_posts()) : $news_query->the_post(); ?>
          <div class="business-news-item">
            <?php if (has_post_thumbnail()) : ?>
              <div class="news-thumbnail">
                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('medium'); ?></a>
              </div>
            <?php endif; ?>
            <div class="news-content">
              <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
              <div class="news-meta">
                <span><?php echo get_the_date(); ?></span>
              </div>
              <div class="news-excerpt">
                <?php echo wp_trim_words(get_the_excerpt(), 15); ?>
              </div>
            </div>
          </div>
        <?php endwhile;
        wp_reset_postdata();
      else :
        echo '<p>No recent news available.</p>';
      endif;
    ?>
  </div>


  
  <div class="sidebar-header">
    <h3>Latest Publications</h3>
  </div>

  <div class="publications-list">
    <?php
      $publications_query = new WP_Query([
        'post_type'      => 'downloads',
        'posts_per_page' => 4,
        'orderby'        => 'date',
        'order'          => 'DESC'
      ]);

      if ($publications_query->have_posts()) :
        while ($publications_query->have_posts()) : $publications_query->the_post();
          $file_url = get_post_meta(get_the_ID(), '_file_url', true);
          $file_size = '';
          if ($file_url) {
            $headers = @get_headers($file_url, 1);
            $file_size = isset($headers['Content-Length']) ? size_format($headers['Content-Length']) : '';
          }
          ?>
          <div class="publication-item">
            <?php if (has_post_thumbnail()) : ?>
              <div class="publication-thumb">
                <a href="<?php echo esc_url($file_url ? $file_url : get_permalink()); ?>" target="_blank">
                  <?php the_post_thumbnail('thumbnail'); ?>
                </a>
              </div>
            <?php endif; ?>
            <div class="publication-content">
              <h4>
                <a href="<?php echo esc_url($file_url ? $file_url : get_permalink()); ?>" target="_blank">
                  <?php the_title(); ?>
                </a>
              </h4>
              <?php if ($file_size) : ?>
                <p class="file-size"><?php echo esc_html($file_size); ?></p>
              <?php endif; ?>
            </div>
          </div>
        <?php
        endwhile;
        wp_reset_postdata();
      else :
        echo '<p>No publications available.</p>';
      endif;
    ?>
  </div>


</aside>

</div>

<!-- Call to Action Section -->
<section class="business-cta">
  <div class="cta-content">
    <h2>Ready to Work With Us?</h2>
    <p>Contact us today to learn more about our services and how we can help your business grow.</p>
    <div class="cta-buttons">
      <a href="<?php echo home_url('/contact'); ?>" class="cta-button">Get In Touch</a>
      <a href="<?php echo home_url('/company-overview'); ?>" class="cta-button secondary">Company Overview</a>
    </div>
  </div>
</section>

<?php get_footer(); ?>