<?php
/**
 * Template for Single Download Page
 * Displays download details, file info, and social sharing.
 */

if (is_singular('downloads')) {

    get_header();
    include get_template_directory() . '/inc/menus/menu.php';

    $post_id        = get_the_ID();
    $file_url       = get_post_meta($post_id, '_file_url', true);
    $downloadCount  = get_post_meta($post_id, '_download_count', true);

    // Get file size dynamically
    $file_size = '';
    if ($file_url) {
        $headers = get_headers($file_url, 1);
        $file_size = isset($headers['Content-Length']) ? size_format($headers['Content-Length']) : '';
    }

    // Featured image as header background
    $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
?>

<main role="main">

    <!-- ========================= -->
    <!-- Hero Section -->
    <!-- ========================= -->
    <section>
        <div class="header-wrap1"
            style="background: linear-gradient(90deg, rgba(6, 6, 5, 0.8), rgba(12, 12, 12, 0.5)), url('<?php echo esc_url($backgroundImg[0]); ?>') no-repeat center center / cover;">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 entry-title" data-aos="fade-up">
                        <h1><?php the_title(); ?></h1>
                        <?php custom_breadcrumb(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ========================= -->
    <!-- Download Content Section -->
    <!-- ========================= -->
    <section>
        <div class="container-xxl page-content2 mt-4">
            <div class="post-content">
                <div class="row justify-content-between pub-single">

                    <!-- Left Column: Thumbnail -->
                    <div class="col-lg-5 col-md-5 col-sm-12" data-aos="fade-up">
                        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="post-thumbnail">
                                        <?php the_post_thumbnail(); ?>
                                    </div>
                                <?php endif; ?>
                    </div>

                    <!-- Right Column: Details -->
                    <div class="col-lg-7 col-md-7 col-sm-12">
                        <div class="about-side-pub">

                            <h1 class="entry-title"><?php the_title(); ?></h1>
                            <h4 class="pub-summ">Overview</h4>

                            <div class="pub-desc">
                                <?php the_content(); ?>
                            </div>

                            <hr />

                            <!-- Download Button -->
                            <div class="pub-download">
                                <a href="<?= esc_url($file_url); ?>" target="_blank" onclick="updateDownloadCount(<?= $post_id; ?>)">
                                    <button class="btn btn-primary">
                                        <i class="bi bi-download"></i> Download
                                    </button>
                                </a>
                            </div>

                            <!-- File Info -->
                            <div class="pub-stats py-3">
                                <i class="bi bi-bar-chart-fill"></i>
                                <small>No. Of Downloads: <?= esc_html($downloadCount); ?></small>
                                &nbsp;&nbsp;
                                <i class="bi bi-file-earmark-pdf"></i>
                                <small>File Size: <?= esc_html($file_size); ?></small>
                            </div>

                            <!-- ========================= -->
                            <!-- Social Media Sharing -->
                            <!-- ========================= -->
                            <div class="d-flex justify-content-start bd-highlight mb-5">
                                <div class="bd-highlight p-1">
                                    <small class="text-muted">Share this publication</small>
                                </div>

                                <!-- Facebook -->
                                <div class="bd-highlight p-1">
                                    <a class="btn btn-sm btn-facebook"
                                       href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>"
                                       target="_blank" rel="noopener noreferrer" title="Facebook">
                                        <small>Share on <i class="bi bi-facebook"></i></small>
                                    </a>
                                </div>

                                <!-- Twitter -->
                                <div class="bd-highlight p-1">
                                    <a class="btn btn-sm btn-twitter"
                                       href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= urlencode(get_the_title()); ?>"
                                       target="_blank" rel="noopener noreferrer" title="Twitter">
                                        <small>Share on <i class="bi bi-twitter-x"></i></small>
                                    </a>
                                </div>

                                <!-- WhatsApp -->
                                <div class="bd-highlight p-1">
                                    <a class="btn btn-sm btn-whatsapp"
                                       href="whatsapp://send?text=Check out this publication: <?= urlencode(get_the_title()); ?> - <?= esc_url(get_permalink()); ?>"
                                       data-action="share/whatsapp/share" title="WhatsApp">
                                        <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                    </a>
                                </div>

                                <!-- Back Button -->
                                <div class="bd-highlight p-1">
                                    <?php do_action('back_button'); ?>
                                </div>
                            </div>
                            <!-- End Social Sharing -->

                        </div> <!-- /.about-side-pub -->
                    </div> <!-- /.col-lg-7 -->

                </div> <!-- /.row -->
            </div> <!-- /.post-content -->

            <?php edit_post_link(); ?>

            </article>
        <?php endwhile; else : ?>
            <article>
                <h2><?php _e('Sorry, nothing to display.', 'kipya'); ?></h2>
            </article>
        <?php endif; ?>
        </div>
    </section>

    <!-- ========================= -->
    <!-- JS: Update Download Count -->
    <!-- ========================= -->
    <script>
        function updateDownloadCount(post_id) {
            jQuery.ajax({
                type: 'POST',
                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                data: {
                    action: 'update_download_count',
                    post_id: post_id
                },
                success: function(response) {
                    console.log('Download count updated successfully.');
                }
            });
        }
    </script>

</main>

<?php
} else {
    // Fallback if not on a 'downloads' post
    echo '<p>Sorry, this page is only for downloads.</p>';
}

get_footer();
?>
