<!-- Main Header -->
<header class="main-header">
    <!-- Sticky Main Header -->
    <div class="header-main sticky-top">
        <div class="container-xxl">
            <div class="header-container">
                <!-- Logo -->
                <div class="logo">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <?php
                        $custom_logo_id = get_theme_mod('custom_logo');
                        $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
                        if ($logo) {
                            echo '<img src="' . esc_url($logo[0]) . '" alt="' . get_bloginfo('name') . '">';
                        } else {
                            echo '<h2>' . get_bloginfo('name') . '</h2>';
                        }
                        ?>
                    </a>
                </div>

                <!-- Navigation Menu -->
                <nav class="main-nav">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'container' => false,
                        'menu_class' => 'nav-menu',
                        'fallback_cb' => false,
                        'walker' => new Mega_Menu_Walker()
                    ));
                    ?>
                    
                    <!-- Search Icon - Desktop -->
                    <div class="search-icon-wrapper desktop-search">
                        <button class="search-toggle" id="searchToggle">
                            <i class="bi bi-search"></i>
                        </button>
                        <div class="search-dropdown" id="searchDropdown">
                            <form class="search-form" role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                                <div class="search-input-wrapper">
                                    <input type="search" class="search-input" placeholder="What are you looking for?" name="s" id="header-search-input" required>
                                    <button type="submit" class="search-submit">
                                        <i class="bi bi-arrow-right"></i>
                                    </button>
                                </div>
                            </form>
                            <div class="search-results" id="header-search-results"></div>
                        </div>
                    </div>
                </nav>

                <!-- Header Actions -->
                <div class="header-actions">
                    <!-- Search Icon - Mobile -->
                    <div class="search-icon-wrapper mobile-search">
                        <button class="search-toggle" id="mobileSearchToggle">
                            <i class="bi bi-search"></i>
                        </button>
                        <div class="search-dropdown" id="mobileSearchDropdown">
                            <form class="search-form" role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                                <div class="search-input-wrapper">
                                    <input type="search" class="search-input" placeholder="What are you looking for?" name="s" id="mobile-search-input" required>
                                    <button type="submit" class="search-submit">
                                        <i class="bi bi-arrow-right"></i>
                                    </button>
                                </div>
                            </form>
                            <div class="search-results" id="mobile-search-results"></div>
                        </div>
                    </div>
                    
                    <!-- Contact Toggle Button -->
                    <button class="contact-toggle" id="contactToggle">
                        <i class="bi bi-grid"></i>
                    </button>
                    <button class="mobile-nav-toggle" id="mobileNavToggle">
                        <i class="bi bi-list"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Contact Canvas -->
<div class="contact-canvas" id="contactCanvas">
    <div class="contact-canvas-header">
        <h3>Contact Information</h3>
        <button class="contact-canvas-close" id="contactCanvasClose">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    
    <div class="contact-canvas-content">
        <div class="contact-info-section">
            <div class="contact-item">
                <div class="contact-icon">
                    <i class="bi bi-telephone-fill"></i>
                </div>
                <div class="contact-details">
                    <h4>Phone Numbers</h4>
                    <a href="tel:+256777461759">+256 777461759</a>
                    <a href="tel:+256706960708">+256 706960708</a>
                </div>
            </div>
            
            <div class="contact-item">
                <div class="contact-icon">
                    <i class="bi bi-envelope-fill"></i>
                </div>
                <div class="contact-details">
                    <h4>Email</h4>
                    <a href="mailto:info@uegcl.co.ug">info@uegcl.co.ug</a>
                </div>
            </div>
            
            <div class="contact-item">
                <div class="contact-icon">
                    <i class="bi bi-geo-alt-fill"></i>
                </div>
                <div class="contact-details">
                    <h4>Address</h4>
                    <p>Plot 10, Hannington Road<br>P.O. Box 7051, Kampala, Uganda</p>
                </div>
            </div>
            
            <div class="contact-item">
                <div class="contact-icon">
                    <i class="bi bi-clock-fill"></i>
                </div>
                <div class="contact-details">
                    <h4>Working Hours</h4>
                    <p>Monday - Friday: 8:00 AM - 5:00 PM<br>Saturday: 9:00 AM - 1:00 PM</p>
                </div>
            </div>
        </div>
        
        <div class="social-section">
            <h4>Follow Us</h4>
            <div class="social-icons-grid">
                <a href="https://x.com/uegcl?s=09" class="social-icon" title="Twitter">
                    <i class="bi bi-twitter"></i>
                </a>
                <a href="#" class="social-icon" title="YouTube">
                    <i class="bi bi-youtube"></i>
                </a>
                <a href="http://www.linkedin.com/in/uegcl-2421b3387" class="social-icon" title="LinkedIn">
                    <i class="bi bi-linkedin"></i>
                </a>
                <a href="http://www.facebook.com/in/uegcl-2421b3387" class="social-icon" title="Facebook">
                    <i class="bi bi-facebook"></i>
                </a>
                <a href="http://www.instagram.com/in/uegcl-2421b3387" class="social-icon" title="Instagram">
                    <i class="bi bi-instagram"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Contact Canvas Overlay -->
<div class="contact-canvas-overlay" id="contactCanvasOverlay"></div>

<!-- Mobile Navigation Menu -->
<div class="mobile-nav-menu" id="mobileNavMenu">
    <div class="mobile-nav-header">
        <h3>Menu</h3>
        <button class="mobile-nav-close" id="mobileNavClose">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    <?php
    wp_nav_menu(array(
        'theme_location' => 'primary',
        'container' => false,
        'menu_class' => 'mobile-nav-list',
        'fallback_cb' => false,
        'walker' => new Mobile_Menu_Walker()
    ));
    ?>
</div>

<!-- Mobile Navigation Overlay -->
<div class="mobile-nav-overlay" id="mobileNavOverlay"></div>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Contact Canvas Toggle
        const contactToggle = document.getElementById('contactToggle');
        const contactCanvas = document.getElementById('contactCanvas');
        const contactCanvasClose = document.getElementById('contactCanvasClose');
        const contactCanvasOverlay = document.getElementById('contactCanvasOverlay');
        const mainHeader = document.querySelector('.main-header');
        
        contactToggle.addEventListener('click', function() {
            contactCanvas.classList.add('active');
            contactCanvasOverlay.classList.add('active');
            mainHeader.classList.add('canvas-active');
        });
        
        contactCanvasClose.addEventListener('click', function() {
            contactCanvas.classList.remove('active');
            contactCanvasOverlay.classList.remove('active');
            mainHeader.classList.remove('canvas-active');
        });
        
        contactCanvasOverlay.addEventListener('click', function() {
            contactCanvas.classList.remove('active');
            contactCanvasOverlay.classList.remove('active');
            mainHeader.classList.remove('canvas-active');
        });
        
        // Mobile Navigation Toggle
        const mobileNavToggle = document.getElementById('mobileNavToggle');
        const mobileNavMenu = document.getElementById('mobileNavMenu');
        const mobileNavClose = document.getElementById('mobileNavClose');
        const mobileNavOverlay = document.getElementById('mobileNavOverlay');
        
        mobileNavToggle.addEventListener('click', function() {
            mobileNavMenu.classList.add('active');
            mobileNavOverlay.classList.add('active');
        });
        
        mobileNavClose.addEventListener('click', function() {
            mobileNavMenu.classList.remove('active');
            mobileNavOverlay.classList.remove('active');
        });
        
        mobileNavOverlay.addEventListener('click', function() {
            mobileNavMenu.classList.remove('active');
            mobileNavOverlay.classList.remove('active');
        });
        
        // Desktop Search Toggle Functionality
        const searchToggle = document.getElementById('searchToggle');
        const searchDropdown = document.getElementById('searchDropdown');
        const searchInput = document.getElementById('header-search-input');
        const searchResults = document.getElementById('header-search-results');
        
        searchToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            searchDropdown.classList.toggle('active');
            if (searchDropdown.classList.contains('active')) {
                searchInput.focus();
            }
        });
        
        // Mobile Search Toggle Functionality
        const mobileSearchToggle = document.getElementById('mobileSearchToggle');
        const mobileSearchDropdown = document.getElementById('mobileSearchDropdown');
        const mobileSearchInput = document.getElementById('mobile-search-input');
        const mobileSearchResults = document.getElementById('mobile-search-results');
        
        mobileSearchToggle.addEventListener('click', function(e) {
            e.stopPropagation();
            mobileSearchDropdown.classList.toggle('active');
            if (mobileSearchDropdown.classList.contains('active')) {
                mobileSearchInput.focus();
            }
        });
        
        // Close search dropdowns when clicking outside
        document.addEventListener('click', function(e) {
            // Desktop search
            if (!searchDropdown.contains(e.target) && !searchToggle.contains(e.target)) {
                searchDropdown.classList.remove('active');
            }
            
            // Mobile search
            if (!mobileSearchDropdown.contains(e.target) && !mobileSearchToggle.contains(e.target)) {
                mobileSearchDropdown.classList.remove('active');
            }
        });
        
        // AJAX Live Search Functionality - Desktop
        searchInput.addEventListener('keyup', function() {
            const query = this.value.trim();
            performLiveSearch(query, searchResults);
        });
        
        // AJAX Live Search Functionality - Mobile
        mobileSearchInput.addEventListener('keyup', function() {
            const query = this.value.trim();
            performLiveSearch(query, mobileSearchResults);
        });
        
        // Shared Live Search Function
        function performLiveSearch(query, resultsContainer) {
            // If empty → clear dropdown and stop
            if (query.length === 0) {
                resultsContainer.innerHTML = '';
                resultsContainer.classList.remove('has-results');
                return;
            }

            // If less than 2 characters → clear dropdown
            if (query.length < 2) {
                resultsContainer.innerHTML = '';
                resultsContainer.classList.remove('has-results');
                return;
            }

            // AJAX request
            fetch('<?php echo admin_url("admin-ajax.php"); ?>?action=live_search&term=' + encodeURIComponent(query))
                .then(response => response.text())
                .then(html => {
                    resultsContainer.innerHTML = html;
                    if (html.trim() !== '') {
                        resultsContainer.classList.add('has-results');
                    } else {
                        resultsContainer.classList.remove('has-results');
                    }
                })
                .catch(error => {
                    console.error('Search error:', error);
                    resultsContainer.innerHTML = '<div class="no-results">Search temporarily unavailable</div>';
                    resultsContainer.classList.add('has-results');
                });
        }

        // Close search results when clicking a result
        searchResults.addEventListener('click', function(e) {
            if (e.target.closest('.search-result-item')) {
                searchDropdown.classList.remove('active');
            }
        });
        
        mobileSearchResults.addEventListener('click', function(e) {
            if (e.target.closest('.search-result-item')) {
                mobileSearchDropdown.classList.remove('active');
            }
        });
        
        // Add scroll effect to header
        window.addEventListener('scroll', function() {
            const header = document.querySelector('.main-header');
            if (window.scrollY > 50) {
                header.classList.add('scrolled');
            } else {
                header.classList.remove('scrolled');
            }
        });
    });

    // Multi-Level Mobile Accordion Dropdowns
    document.addEventListener('DOMContentLoaded', () => {
        const mobileMenu = document.getElementById('mobileNavMenu');

        mobileMenu.addEventListener('click', function (e) {
            const link = e.target.closest('.has-children > a');
            if (link) {
                e.preventDefault();
                const parentLi = link.parentElement;
                const submenu = parentLi.querySelector(':scope > .mobile-submenu');

                // Close sibling dropdowns at the same level
                const siblingLis = parentLi.parentElement.querySelectorAll('.has-children');
                siblingLis.forEach(sibling => {
                    if (sibling !== parentLi) {
                        sibling.classList.remove('open');
                        const siblingSub = sibling.querySelector(':scope > .mobile-submenu');
                        if (siblingSub) siblingSub.classList.remove('active');
                    }
                });

                // Toggle this submenu
                if (submenu) {
                    submenu.classList.toggle('active');
                    parentLi.classList.toggle('open');
                }
            }
        });
    });
</script>

<?php
    // Custom Walker Class for mega dropdown navigation
    class Mega_Menu_Walker extends Walker_Nav_Menu {
        private $has_grandchildren = false;
        
        function start_lvl(&$output, $depth = 0, $args = null) {
            if ($depth == 0) {
                if ($this->has_grandchildren) {
                    $output .= '<div class="mega-menu"><div class="mega-menu-content">';
                } else {
                    $output .= '<ul class="simple-dropdown">';
                }
            } else {
                $output .= '<ul class="sub-menu">';
            }
        }
        
        function end_lvl(&$output, $depth = 0, $args = null) {
            if ($depth == 0) {
                if ($this->has_grandchildren) {
                    $output .= '</div></div>';
                } else {
                    $output .= '</ul>';
                }
                $this->has_grandchildren = false;
            } else {
                $output .= '</ul>';
            }
        }
        
        function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;
            
            $has_children = in_array('menu-item-has-children', $classes);
            
            if ($depth == 0 && $has_children) {
                $this->has_grandchildren = $this->check_for_grandchildren($item->ID);
                if ($this->has_grandchildren) {
                    $classes[] = 'has-mega-menu has-dropdown';
                } else {
                    $classes[] = 'has-simple-dropdown has-dropdown';
                }
            }
            
            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
            $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
            
            if ($depth == 0) {
                $output .= '<li' . $class_names . '>';
            } elseif ($depth == 1 && $this->has_grandchildren) {
                $output .= '<div class="mega-menu-column"><h4>';
            } else {
                $output .= '<li' . $class_names . '>';
            }
            
            $atts = array();
            $atts['title']  = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel']    = !empty($item->xfn) ? $item->xfn : '';
            $atts['href']   = !empty($item->url) ? $item->url : '';
            
            if ($depth == 0) {
                $atts['class'] = 'nav-item' . ($has_children ? ' dropdown-toggle' : '');
            }
            
            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
            
            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
            
            $item_output = $args->before;
            
            if ($depth == 1 && $this->has_grandchildren) {
                $item_output .= '<a' . $attributes . '>';
                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                $item_output .= '</a>';
                $item_output .= '</h4><ul>';
            } else {
                $item_output .= '<a' . $attributes . '>';
                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                if ($depth == 0 && $has_children) {
                   
                }
                $item_output .= '</a>';
            }
            
            $item_output .= $args->after;
            
            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
        }
        
        function end_el(&$output, $item, $depth = 0, $args = null) {
            if ($depth == 0) {
                $output .= '</li>';
            } elseif ($depth == 1 && $this->has_grandchildren) {
                $output .= '</ul></div>';
            } else {
                $output .= '</li>';
            }
        }
        
        private function check_for_grandchildren($parent_id) {
            $menu_items = wp_get_nav_menu_items(get_nav_menu_locations()['primary']);
            if (!$menu_items) return false;
            
            $children = array();
            foreach ($menu_items as $item) {
                if ($item->menu_item_parent == $parent_id) {
                    $children[] = $item->ID;
                }
            }
            
            foreach ($children as $child_id) {
                foreach ($menu_items as $item) {
                    if ($item->menu_item_parent == $child_id) {
                        return true;
                    }
                }
            }
            
            return false;
        }
    }

    // Mobile Menu Walker
    class Mobile_Menu_Walker extends Walker_Nav_Menu {
        function start_lvl(&$output, $depth = 0, $args = null) {
            $output .= '<ul class="mobile-submenu">';
        }
        
        function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;
            
            $has_children = in_array('menu-item-has-children', $classes);
            if ($has_children) {
                $classes[] = 'has-children';
            }
            
            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
            $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
            
            $output .= '<li' . $class_names . '>';
            
            $atts = array();
            $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
            $atts['href'] = !empty($item->url) ? $item->url : '';
            $atts['class'] = 'mobile-nav-item';
            
            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
            
            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
            
            $item_output = $args->before;
            $item_output .= '<a' . $attributes . '>';
            $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
            if ($has_children) {
                
            }
            $item_output .= '</a>';
            $item_output .= $args->after;
            
            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
        }
    }
?>