<?php
// Register shortcode
add_shortcode('uegcl_about_section', 'uegcl_about_section_callback');

function uegcl_about_section_callback($atts) {
    // Parse attributes
    $atts = shortcode_atts(array(
        'title' => 'Who We Are',
        'subtitle' => 'ABOUT UEGCL',
        'description' => 'Uganda Electricity Generation Company Limited (UEGCL) was incorporated in 2001 to assume the electricity generation functions previously held by the defunct Uganda Electricity Board (UEB) under the Companies Act and the Electricity Act of the Laws of Uganda. The Assets acquired then included Nalubaale HPP (180MW) and Kiira HPP (200MW) in Jinja. The portfolio has since expanded to include the majestic 600 MW Karuma HPP, 183 MW Isimba HPP, Namanve TPP (50MW), and the 6.6 MW Nyagak III HPP.',
        'card_1_title' => 'Power Generation Excellence',
        'card_1_text' => 'Leading Uganda\'s energy sector with state-of-the-art hydroelectric and thermal power generation facilities across multiple strategic locations.',
        'card_2_title' => 'Sustainable Energy',
        'card_2_text' => 'Committed to environmentally responsible power generation that meets today\'s needs while preserving resources for future generations.',
        'card_3_title' => 'National Development',
        'card_3_text' => 'Powering Uganda\'s future with clean, reliable energy for generations to come.',
        'cta_text' => 'Powering Uganda\'s future with clean, reliable energy for generations to come.',
        'button_text' => 'Learn More About UEGCL',
        'button_url' => '#',
        
        // Safety section attributes
        'safety_title' => 'Safety Indicators By Plant',
        'safety_description' => 'Our commitment to workplace safety is unwavering. We track Lost Time Injury (LTI) metrics across all facilities to ensure the highest safety standards.',
        'card_1_days' => '1725',
        'card_1_plant' => 'Isimba HPP',
        'card_2_days' => '1725',
        'card_2_plant' => 'Karuma HPP',
        'card_3_days' => '946',
        'card_3_plant' => 'Nalubaale-Kiira',
        'card_4_days' => '1338',
        'card_4_plant' => 'Namanve TPP',
        // Starting date for calculation (format: YYYY-MM-DD)
        'safety_start_date' => '2025-11-03',
    ), $atts);
    
    ob_start();
    ?>
    
    <section class="uegcl-about-section">
        <!-- Enhanced SVG Background Graphics -->
        <div class="uegcl-bg-graphics">
            <svg class="uegcl-bg-element uegcl-bg-circles" viewBox="0 0 800 800">
                <defs>
                    <linearGradient id="circleGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                        <stop offset="0%" style="stop-color:rgba(109, 198, 216, 0.08);stop-opacity:1" />
                        <stop offset="100%" style="stop-color:rgba(109, 198, 216, 0.03);stop-opacity:1" />
                    </linearGradient>
                </defs>
                <circle cx="400" cy="400" r="350" fill="none" stroke="url(#circleGrad)" stroke-width="2"/>
                <circle cx="400" cy="400" r="280" fill="none" stroke="url(#circleGrad)" stroke-width="2"/>
                <circle cx="400" cy="400" r="210" fill="none" stroke="url(#circleGrad)" stroke-width="2"/>
                <circle cx="400" cy="400" r="140" fill="none" stroke="url(#circleGrad)" stroke-width="1.5"/>
            </svg>
            
            <svg class="uegcl-bg-element uegcl-bg-grid" viewBox="0 0 100 100">
                <defs>
                    <pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse">
                        <path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(109, 198, 216, 0.08)" stroke-width="0.5"/>
                    </pattern>
                </defs>
                <rect width="100" height="100" fill="url(#grid)" />
            </svg>
            
            <svg class="uegcl-bg-element uegcl-bg-hexagons" viewBox="0 0 400 400">
                <path d="M200,50 L280,100 L280,200 L200,250 L120,200 L120,100 Z" fill="none" stroke="rgba(109, 198, 216, 0.1)" stroke-width="2"/>
                <path d="M200,90 L260,130 L260,190 L200,230 L140,190 L140,130 Z" fill="none" stroke="rgba(109, 198, 216, 0.06)" stroke-width="1.5"/>
            </svg>
            
            <div class="uegcl-bg-orb uegcl-bg-orb-1"></div>
            <div class="uegcl-bg-orb uegcl-bg-orb-2"></div>
            <div class="uegcl-bg-orb uegcl-bg-orb-3"></div>
        </div>
        
        <div class="uegcl-about-container">
            <div class="uegcl-about-header">
                <span class="uegcl-about-subtitle"><?php echo esc_html($atts['subtitle']); ?></span>
                <h2 class="uegcl-about-title"><?php echo esc_html($atts['title']); ?></h2>
            </div>
            
            <div class="uegcl-content-wrapper">
                <div class="uegcl-description-column">
                    <p class="uegcl-about-description"><?php echo esc_html($atts['description']); ?></p>
                </div>
                
                <div class="uegcl-stats-column">
                    <div class="uegcl-stats-grid">
                        <div class="uegcl-stat-item">
                            <div class="uegcl-stat-icon uegcl-stat-icon-2">
                                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <circle cx="12" cy="12" r="10"/>
                                    <path d="M12 6v6l4 2"/>
                                </svg>
                            </div>
                            <div class="uegcl-stat-content">
                                <h3 class="uegcl-counter uegcl-about-counter" data-target="99.8">0</h3>
                                <p class="uegcl-stat-label">% Uptime Reliability</p>
                                <p class="uegcl-stat-text">Consistent energy supply</p>
                            </div>
                        </div>
                        
                        
                        
                        <div class="uegcl-stat-item">
                            <div class="uegcl-stat-icon uegcl-stat-icon-1">
                                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M20 7h-9M14 17H5M6 3h12a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2z"/>
                                </svg>
                            </div>
                            <div class="uegcl-stat-content">
                                <h3 class="uegcl-counter uegcl-about-counter" data-target="1219">0</h3>
                                <p class="uegcl-stat-label">MW Total Capacity</p>
                                <p class="uegcl-stat-text">Powering Uganda's growth</p>
                            </div>
                        </div>
                        
                        
                        
                        <div class="uegcl-stat-item">
                            <div class="uegcl-stat-icon uegcl-stat-icon-3">
                                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                                </svg>
                            </div>
                            <div class="uegcl-stat-content">
                                <h3 class="uegcl-counter uegcl-about-counter" data-target="850">0</h3>
                                <p class="uegcl-stat-label">+ Skilled Engineers</p>
                                <p class="uegcl-stat-text">Expert technical team</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="uegcl-cta-row">
                <div class="uegcl-cta-card">
                    <div class="uegcl-cta-bg-pattern"></div>
                    <div class="uegcl-cta-content">
                        <div class="uegcl-cta-icon-wrapper">
                            <div class="uegcl-cta-icon-bg"></div>
                            <svg class="uegcl-cta-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                            </svg>
                        </div>
                        <h3 class="uegcl-cta-title">Our Commitment</h3>
                        <p class="uegcl-cta-text"><?php echo esc_html($atts['cta_text']); ?></p>
                        <a href="<?php echo esc_url($atts['button_url']); ?>" class="uegcl-cta-button">
                            <?php echo esc_html($atts['button_text']); ?>
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                <line x1="5" y1="12" x2="19" y2="12"/>
                                <polyline points="12 5 19 12 12 19"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <section class="uegcl-safety-section" data-start-date="<?php echo esc_attr($atts['safety_start_date']); ?>">
        <div class="uegcl-safety-bg-pattern"></div>
        <div class="uegcl-safety-container">
            <div class="uegcl-safety-header">
                <span class="uegcl-safety-subtitle">SAFETY FIRST</span>
                <h2 class="uegcl-safety-title"><?php echo esc_html($atts['safety_title']); ?></h2>
                <p class="uegcl-safety-description"><?php echo esc_html($atts['safety_description']); ?></p>
            </div>
            <div class="uegcl-safety-grid">
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/>
                            <path d="M9 12l2 2 4-4"/>
                        </svg>
                    </div>
                    <div class="uegcl-safety-content">
                        <h3 class="uegcl-counter uegcl-safety-counter" data-target="<?php echo esc_attr($atts['card_1_days']); ?>" data-base-days="<?php echo esc_attr($atts['card_1_days']); ?>" style="font-size: 2.15rem;">0</h3>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3 class="uegcl-plant-name"><?php echo esc_html($atts['card_1_plant']); ?></h3>
                    </div>
                </div>
                
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                            <path d="M2 17l10 5 10-5M2 12l10 5 10-5"/>
                        </svg>
                    </div>
                    <div class="uegcl-safety-content">
                        <h3 class="uegcl-counter uegcl-safety-counter" data-target="<?php echo esc_attr($atts['card_2_days']); ?>" data-base-days="<?php echo esc_attr($atts['card_2_days']); ?>" style="font-size: 2.15rem;">0</h3>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3 class="uegcl-plant-name"><?php echo esc_html($atts['card_2_plant']); ?></h3>
                    </div>
                </div>
                
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2.69l5.66 5.66a8 8 0 1 1-11.31 0z"/>
                        </svg>
                    </div>
                    <div class="uegcl-safety-content">
                        <h3 class="uegcl-counter uegcl-safety-counter" data-target="<?php echo esc_attr($atts['card_3_days']); ?>" data-base-days="<?php echo esc_attr($atts['card_3_days']); ?>" style="font-size: 2.15rem;">0</h3>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3 class="uegcl-plant-name"><?php echo esc_html($atts['card_3_plant']); ?></h3>
                    </div>
                </div>
                
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                    </svg>
                    </div>
                    <div class="uegcl-safety-content">
                        <h3 class="uegcl-counter uegcl-safety-counter" data-target="<?php echo esc_attr($atts['card_4_days']); ?>" data-base-days="<?php echo esc_attr($atts['card_4_days']); ?>" style="font-size: 2.15rem;">0</h3>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3 class="uegcl-plant-name"><?php echo esc_html($atts['card_4_plant']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <script>
    (function() {
        // Calculate days passed since start date
        function calculateDaysPassed(startDate) {
            const start = new Date(startDate);
            const today = new Date();
            today.setHours(0, 0, 0, 0);
            start.setHours(0, 0, 0, 0);
            const diffTime = Math.abs(today - start);
            const diffDays = Math.floor(diffTime / (1000 * 60 * 60 * 24));
            return diffDays;
        }
        
        // Animate counter
        function animateCounter(element) {
            const target = parseFloat(element.getAttribute('data-target'));
            const duration = 2000;
            const start = 0;
            const startTime = performance.now();
            const isDecimal = target % 1 !== 0;
            
            function update(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                
                const easeOutQuart = 1 - Math.pow(1 - progress, 4);
                const current = start + (target - start) * easeOutQuart;
                
                element.textContent = isDecimal ? current.toFixed(1) : Math.floor(current);
                
                if (progress < 1) {
                    requestAnimationFrame(update);
                } else {
                    element.textContent = isDecimal ? target.toFixed(1) : target;
                }
            }
            
            requestAnimationFrame(update);
        }
        
        // Update safety counters with auto-increment
        function updateSafetyCounters() {
            const safetySection = document.querySelector('.uegcl-safety-section');
            if (!safetySection) return;
            
            const startDate = safetySection.getAttribute('data-start-date');
            const daysPassed = calculateDaysPassed(startDate);
            
            const safetyCounters = safetySection.querySelectorAll('.uegcl-safety-counter');
            safetyCounters.forEach(counter => {
                const baseDays = parseInt(counter.getAttribute('data-base-days'));
                const newTarget = baseDays + daysPassed;
                counter.setAttribute('data-target', newTarget);
            });
        }
        
        // Initialize counters on page load
        updateSafetyCounters();
        
        // Single observer for ALL counters in both sections
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    // Find ALL counters in the intersecting section
                    const counters = entry.target.querySelectorAll('.uegcl-counter');
                    counters.forEach(counter => {
                        if (!counter.classList.contains('animated')) {
                            counter.classList.add('animated');
                            animateCounter(counter);
                        }
                    });
                }
            });
        }, { threshold: 0.3 });
        
        // Observe both sections
        const aboutSection = document.querySelector('.uegcl-about-section');
        const safetySection = document.querySelector('.uegcl-safety-section');
        
        if (aboutSection) observer.observe(aboutSection);
        if (safetySection) observer.observe(safetySection);
        
        // Update safety counters daily at midnight
        function scheduleNextUpdate() {
            const now = new Date();
            const tomorrow = new Date(now);
            tomorrow.setDate(tomorrow.getDate() + 1);
            tomorrow.setHours(0, 0, 0, 0);
            
            const timeUntilMidnight = tomorrow - now;
            
            setTimeout(function() {
                updateSafetyCounters();
                // Re-animate counters after update
                const safetyCounters = document.querySelectorAll('.uegcl-safety-counter');
                safetyCounters.forEach(counter => {
                    counter.classList.remove('animated');
                    animateCounter(counter);
                });
                scheduleNextUpdate();
            }, timeUntilMidnight);
        }
        
        scheduleNextUpdate();
    })();
    </script>

    <style>
    /* 3-column grid for statistics */
    .uegcl-stats-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 20px;
        width: 100%;
    }

    .uegcl-stat-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 20px;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 12px;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .uegcl-stat-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
    }

    .uegcl-stat-icon {
        width: 60px;
        height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, var(--kpy-primary), #1e88e5);
        border-radius: 50%;
        margin-bottom: 15px;
    }

    .uegcl-stat-icon svg {
        width: 24px;
        height: 24px;
        color: white;
    }

    .uegcl-stat-content {
        flex: 1;
    }

    /* General counter styles */
    .uegcl-counter {
        font-weight: 700;
        color: var(--kpy-primary);
        margin: 0 0 10px 0;
        line-height: 1;
    }

    /* About section counter styles */
    .uegcl-about-counter {
        font-size: 2.5rem;
    }

    /* Safety section counter styles with inline override */
    .uegcl-safety-counter {
        /* Font size is set inline in HTML: 2.15rem */
    }

    .uegcl-stat-label {
        font-size: 0.9rem;
        font-weight: 600;
        color: #333;
        margin: 0 0 5px 0;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .uegcl-stat-text {
        font-size: 0.8rem;
        color: #666;
        margin: 0;
        line-height: 1.4;
    }

    /* Safety section specific styles */
    .uegcl-safety-label {
        font-size: 0.9rem;
        font-weight: 600;
        color: #333;
        margin: 0 0 5px 0;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Plant name styling */
    .uegcl-plant-name {
        font-size: 1.15rem;
        font-weight: 600;
        color: #333;
        margin: 10px 0 0 0;
    }

    /* Responsive design */
    @media (max-width: 1024px) {
        .uegcl-stats-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }
    }

    @media (max-width: 768px) {
        .uegcl-stats-grid {
            grid-template-columns: 1fr;
            gap: 15px;
        }
        
        .uegcl-stat-item {
            padding: 15px;
        }
        
        .uegcl-about-counter {
            font-size: 2rem;
        }
        
        .uegcl-safety-counter {
            font-size: 1.85rem !important;
        }
    }
    </style>
    
    <?php
    return ob_get_clean();
}

// Helper function for safety icon (kept for compatibility)
function uegcl_get_safety_icon() {
    return '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>';
}

function uegcl_powerplants_section_callback($atts) {
    $atts = shortcode_atts(array(
        'bg_image' => '',
        'title' => 'Major Hydro Powerplants',
        'description' => 'UEGCL offers expert professional services for all types of hydropower development projects from Mini to Large development schemes, low to high head projects, run of the river to storage schemes, surface to subsurface development projects etc.',
        'button_text' => 'SEE ALL STATIONS',
        'button_link' => '#all-stations'
    ), $atts);
    
    $plants = array(
        array('name' => 'Kiira Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/kiira-power-station.jpg'),
        array('name' => 'Isimba Hydro Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Isimba-Hydro.jpg'),
        array('name' => 'Nalubaale Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Nalubaale.jpg'),
        array('name' => 'Karuma Hydro Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Karuma.jpg'),
    );
    
    ob_start();
    ?>
    <section class="pp-section">
        <div class="pp-parallax" style="background-image:linear-gradient(135deg,rgba(var(--kpy-primary-rgb),.95),rgba(var(--kpy-primary-rgb),.85)),url('<?php echo esc_url($atts['bg_image']); ?>');"></div>
        <div class="pp-overlay"></div>
        
        <div class="pp-container">
            <div class="pp-content-wrapper">
                <div class="pp-text-content">
                    <h2 class="pp-title"><?php echo wp_kses_post(nl2br($atts['title'])); ?></h2>
                    <p class="pp-description"><?php echo esc_html($atts['description']); ?></p>
                    <a href="<?php echo esc_url($atts['button_link']); ?>" class="pp-cta-btn"><?php echo esc_html($atts['button_text']); ?></a>
                </div>
                
                <div class="pp-carousel-wrapper">
                    <div class="pp-carousel">
                        <?php foreach($plants as $index => $plant): ?>
                            <div class="pp-card" style="--delay: <?php echo $index * 0.2; ?>s">
                                <div class="pp-card-image">
                                    <img src="<?php echo esc_url($plant['image']); ?>" alt="<?php echo esc_attr($plant['name']); ?>">
                                    <div class="pp-card-overlay"></div>
                                </div>
                                <div class="pp-card-footer">
                                    <h3 class="pp-card-title"><?php echo esc_html($plant['name']); ?></h3>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        
                        <?php foreach($plants as $index => $plant): ?>
                            <div class="pp-card" style="--delay: <?php echo ($index + count($plants)) * 0.2; ?>s">
                                <div class="pp-card-image">
                                    <img src="<?php echo esc_url($plant['image']); ?>" alt="<?php echo esc_attr($plant['name']); ?>">
                                    <div class="pp-card-overlay"></div>
                                </div>
                                <div class="pp-card-footer">
                                    <h3 class="pp-card-title"><?php echo esc_html($plant['name']); ?></h3>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const parallax = document.querySelector('.pp-parallax');
            if (parallax && window.matchMedia('(prefers-reduced-motion: no-preference)').matches) {
                let ticking = false;
                window.addEventListener('scroll', function() {
                    if (!ticking) {
                        window.requestAnimationFrame(function() {
                            const scrolled = window.pageYOffset;
                            const sectionTop = parallax.closest('.pp-section').offsetTop;
                            const offset = (scrolled - sectionTop) * 0.5;
                            parallax.style.transform = `translateY(${offset}px)`;
                            ticking = false;
                        });
                        ticking = true;
                    }
                });
            }
        });
    </script>
    <?php
    return ob_get_clean();
}

add_shortcode('uegcl_powerplants_section', 'uegcl_powerplants_section_callback');