<!Doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>
        <?php
        $seo_title = get_post_meta(get_the_ID(), '_seo_title', true);
        if (!empty($seo_title)) {
            echo esc_html($seo_title);
        } else {
            echo esc_html(get_the_title());
        }
        ?>
    </title>

    <meta name="description" content="<?php
        $seo_description = get_post_meta(get_the_ID(), '_seo_description', true);
        if (!empty($seo_description)) {
            echo esc_html($seo_description);
        } else {
            echo esc_html(get_the_excerpt());
        }
    ?>">
    <meta name="keywords" content="<?php
        $seo_keywords = get_post_meta(get_the_ID(), '_seo_keywords', true);
        if (!empty($seo_keywords)) {
            echo esc_html($seo_keywords);
        } else {
            echo esc_html('UEGCL Uganda Electricity Generation Company Limited Electricity Generation Uganda Karuma Hydro Power Plant Isimba Hydro Power Plant Nalubaale HPP Kiira HPP Namanve TPP Nyagak III HPP Uganda Power Assets ERA Regulated');
        }
    ?>">

    <!-- Open Graph Meta -->
    <meta property="og:title" content="<?php echo !empty($seo_title) ? esc_html($seo_title) : esc_html(get_the_title()); ?>" />
    <meta property="og:description" content="<?php echo !empty($seo_description) ? esc_html($seo_description) : esc_html(get_the_excerpt()); ?>" />
    <meta property="og:image" content="<?php
        $featured_image = get_the_post_thumbnail_url();
        $default_image = get_template_directory_uri() . '/assets/images/jobconnect-uganda.jpg';
        echo !empty($featured_image) ? esc_url($featured_image) : esc_url($default_image);
    ?>" />
    <meta property="og:url" content="<?php the_permalink(); ?>" />

    <!-- Twitter Meta -->
    <meta name="twitter:title" content="<?php echo !empty($seo_title) ? esc_html($seo_title) : esc_html(get_the_title()); ?>" />
    <meta name="twitter:description" content="<?php echo !empty($seo_description) ? esc_html($seo_description) : esc_html(get_the_excerpt()); ?>" />
    <meta name="twitter:image" content="<?php echo !empty($featured_image) ? esc_url($featured_image) : esc_url($default_image); ?>" />

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Roboto:ital,wght@0,100..900;1,100..900&family=Source+Sans+3:ital,wght@0,200..900;1,200..900&display=swap" rel="stylesheet">

    <!-- ✅ Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-HmXJQ1L4zAYbmC8Z+yXK2VdtcQQM+U1BD1IS5cwQp7z1J3DPRzYwHTzE3F4I0VvN" crossorigin="anonymous">

    <!-- ✅ Font Awesome 6 -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" rel="stylesheet" integrity="sha512-Vu5y8yMN1L8PzQbK6dZ+bE8bcEqf7oMnxEv3VZbON6sw1hCzSP7oQENiK0HIl4AGfa7g5K+LM+M7wFZtx5i4/A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <!-- ✅ AOS (Animate On Scroll) -->
    <link href="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


    <!-- WordPress Head -->
    <?php wp_head(); ?>

    <!-- ✅ Bootstrap JS Bundle (Popper included) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ENjdO4Dr2bkBIFxQpeoYiFj6sUBa5z6x9pRrB6HY6D+6L4U8ih8Zh4qTnNQhUHUo" crossorigin="anonymous"></script>

    <!-- ✅ AOS JS -->
    <script src="https://cdn.jsdelivr.net/npm/aos@2.3.4/dist/aos.js"></script>

    <script>
      document.addEventListener('DOMContentLoaded', function() {
        AOS.init({
          duration: 800,
          easing: 'ease-in-out',
          once: true,
          offset: 100
        });
      });
    </script>

</head>
