<?php /* Template Name: Alternative Contact Page Template */ get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
    
    // Handle form submission (same as before)
    if (isset($_POST['contact_submitted'])) {
        $name = sanitize_text_field($_POST['contact_name']);
        $email = sanitize_email($_POST['contact_email']);
        $phone = sanitize_text_field($_POST['contact_phone']);
        $subject = sanitize_text_field($_POST['contact_subject']);
        $message = sanitize_textarea_field($_POST['contact_message']);
        
        $post_content = "Name: $name\n";
        $post_content .= "Email: $email\n";
        $post_content .= "Phone: $phone\n";
        $post_content .= "Subject: $subject\n\n";
        $post_content .= "Message:\n$message";
        
        $contact_post = array(
            'post_title' => 'New Contact: ' . $name . ' - ' . $subject,
            'post_content' => $post_content,
            'post_status' => 'private',
            'post_type' => 'contact_submission',
        );
        
        $post_id = wp_insert_post($contact_post);
        
        if ($post_id) {
            $submission_success = true;
        }
    }
?>

<main role="main">
    
<?php 
$backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); 
?>
    

<section class="hero-section" style="background-image: url('<?php echo esc_url($backgroundImg[0]); ?>');">
    <!-- Bigger floating spiritual elements -->
    <div class="spiritual-element cross" style="top:15%; left:5%; animation-delay:0s;">✝</div>
    <div class="spiritual-element dove" style="top:25%; right:10%; animation-delay:1s;">🕊</div>
    <div class="spiritual-element halo" style="bottom:30%; left:15%; animation-delay:2s;">☀</div>
    <div class="spiritual-element cross" style="bottom:20%; right:5%; animation-delay:1.5s;">✟</div>
    <div class="spiritual-element dove" style="top:60%; left:20%; animation-delay:2.5s;">🕊</div>
    
    <div class="hero-overlay">
        <div class="hero-content">
            <h1 class="hero-title"><?php the_title(); ?></h1>
            <div class="hero-breadcrumb">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>

</section>

<div class="alt-contact-container">
    <?php if (have_posts()): while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php the_content(); ?>
            
            <?php if (isset($submission_success) && $submission_success): ?>
            <div class="alt-contact-success-popup">
                <div class="alt-success-content">
                    <div class="alt-checkmark">
                        <svg viewBox="0 0 52 52">
                            <circle cx="26" cy="26" r="25" fill="var(--kpy-primary)"/>
                            <path fill="none" stroke="#fff" stroke-width="4" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
                        </svg>
                    </div>
                    <h3>Message Sent!</h3>
                    <p>We've received your message and will respond soon. God bless you.</p>
                    <button class="alt-close-popup">Close</button>
                </div>
            </div>
            <?php endif; ?>
            
            
        </article>
    <?php endwhile; endif; ?>
    
    <!-- New Contact Layout with Map -->
    <div class="alt-contact-layout">
        <!-- Left Column - Contact Info -->
        <div class="alt-contact-info-col">
            <div class="alt-contact-info-card">
                <h3 class="alt-contact-info-title">Our Information</h3>
                
                <div class="alt-contact-info-item">
                    <div class="alt-contact-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--kpy-primary)">
                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                        </svg>
                    </div>
                    <div class="alt-contact-text">
                        <h4>Location</h4>
                        <p>123 Faith Avenue<br>Kampala, Uganda</p>
                    </div>
                </div>
                
                <div class="alt-contact-info-item">
                    <div class="alt-contact-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--kpy-primary)">
                            <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                        </svg>
                    </div>
                    <div class="alt-contact-text">
                        <h4>Email Us</h4>
                        <p>info@truelight.org<br>https://kavodtruelightyouthhub.org/</p>
                    </div>
                </div>
                
                <div class="alt-contact-info-item">
                    <div class="alt-contact-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--kpy-primary)">
                            <path d="M20.01 15.38c-1.23 0-2.42-.2-3.53-.56-.35-.12-.74-.03-1.01.24l-1.57 1.97c-2.83-1.35-5.48-3.9-6.89-6.83l1.95-1.66c.27-.28.35-.67.24-1.02-.37-1.11-.56-2.3-.56-3.53 0-.54-.45-.99-.99-.99H4.19C3.65 3 3 3.24 3 3.99 3 13.28 10.73 21 20.01 21c.71 0 .99-.63.99-1.18v-3.45c0-.54-.45-.99-.99-.99z"/>
                        </svg>
                    </div>
                    <div class="alt-contact-text">
                        <h4>Call Us</h4>
                        <p>+254 700 123456<br>+254 733 987654</p>
                    </div>
                </div>
                
                <div class="alt-contact-hours">
                    <h4>Available</h4>
                    <p>Monday - Friday: 8:00 AM - 5:00 PM<br>
                    Saturday: 9:00 AM - 2:00 PM<br>
                    Sunday: Closed (Worship Day)</p>
                </div>
            </div>
            
            <div class="alt-contact-social">
                <h4>Connect With Us</h4>
                <div class="alt-social-icons">
                    <a href="#" class="alt-social-icon"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="alt-social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="alt-social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="alt-social-icon"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>
        
        <!-- Middle Column - Contact Form -->
        <div class="alt-contact-form-col">
            <div class="alt-contact-form-card">
                <h3 class="alt-form-title">Send Us a Message</h3>
                <p class="alt-form-subtitle">Fill out the form below and we'll respond as soon as possible.</p>
                
                <form id="alt-contact-form" method="post" class="alt-contact-form">
                    <div class="alt-form-group">
                        <label for="alt_contact_name">Your Name <span>*</span></label>
                        <input type="text" id="alt_contact_name" name="contact_name" required>
                    </div>
                    
                    <div class="alt-form-row">
                        <div class="alt-form-group alt-form-half">
                            <label for="alt_contact_email">Email Address <span>*</span></label>
                            <input type="email" id="alt_contact_email" name="contact_email" required>
                        </div>
                        <div class="alt-form-group alt-form-half">
                            <label for="alt_contact_phone">Phone Number</label>
                            <input type="tel" id="alt_contact_phone" name="contact_phone">
                        </div>
                    </div>
                    
                    <div class="alt-form-group">
                        <label for="alt_contact_subject">Subject <span>*</span></label>
                        <input type="text" id="alt_contact_subject" name="contact_subject" required>
                    </div>
                    
                    <div class="alt-form-group">
                        <label for="alt_contact_message">Your Message <span>*</span></label>
                        <textarea id="alt_contact_message" name="contact_message" rows="6" required></textarea>
                    </div>
                    
                    <div class="alt-form-submit">
                        <button type="submit" name="contact_submitted" class="alt-submit-btn">
                            Send Message
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Right Column - Map -->
        <div class="alt-contact-map-col">
            <div class="alt-contact-map-card">
                <h3 class="alt-map-title">Find Us</h3>
                <div class="alt-map-container">
                    <!-- Embed your Google Map here -->
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3988.808156227057!2d36.82114631475395!3d-1.292385635979157!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x182f10d664f5b3c9%3A0x4e3e1a3d5f8b3b1d!2sFaith%20Avenue!5e0!3m2!1sen!2ske!4v1620000000000!5m2!1sen!2ske" 
                            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
                </div>
                <div class="alt-map-directions">
                    <a href="https://maps.google.com?daddr=123+Faith+Avenue+Nairobi" target="_blank" class="alt-directions-btn">
                        Get Directions
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

</main>


<script>
jQuery(document).ready(function($) {
    // Show success popup if submission was successful
    <?php if (isset($submission_success) && $submission_success): ?>
        $('.alt-contact-success-popup').addClass('active');
    <?php endif; ?>
    
    // Close popup handler
    $('.alt-close-popup').on('click', function() {
        $('.alt-contact-success-popup').removeClass('active');
    });
});
</script>

<?php get_footer(); ?>