<section class="main-slider">
    <?php
    $slider_query = new WP_Query([
        'post_type'      => 'slides',
        'posts_per_page' => -1
    ]);
    ?>

    <div class="swiper-container thm-swiper__slider" data-swiper-options='{
        "slidesPerView": 1,
        "loop": true,
        "effect": "fade",
        "pagination": {
            "el": "#main-slider-pagination",
            "type": "bullets",
            "clickable": true
        },
        "navigation": {
            "nextEl": "#main-slider__swiper-button-next",
            "prevEl": "#main-slider__swiper-button-prev"
        },
        "autoplay": {
            "delay": 5000
        }
    }'>
        <div class="swiper-wrapper">
            <?php if ($slider_query->have_posts()): ?>
                <?php while ($slider_query->have_posts()): $slider_query->the_post();
                    $title        = get_the_title();
                    $description  = get_the_excerpt();
                    $url          = get_post_meta(get_the_ID(), 'slide_url', true);
                    $backgroundImg = get_the_post_thumbnail_url(get_the_ID());
                ?>
                    <div class="swiper-slide">
                        <div class="image-layer" style="background-image: url('<?= esc_url($backgroundImg); ?>');"></div>
                        <div class="slider-overlay"></div>

                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-content">
                                        <div class="main-slider-content__inner">
                                            <div class="big-title">
                                                <h2><?= esc_html($title) ?></h2>
                                            </div>
                                            <div class="text">
                                                <p><?= esc_html($description) ?></p>
                                            </div>
                                            <div class="hero-buttons">
                                                <a href="<?= home_url('/group/'); ?>" class="buttons buttons-join">Join Us</a>
                                                <a href="<?= home_url('/volunteer/'); ?>" class="buttons buttons-volunteer">Volunteer</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- container -->
                    </div><!-- swiper-slide -->
                <?php endwhile; ?>
            <?php endif; ?>
        </div>
    </div>
    <?php wp_reset_postdata(); ?>
</section>
