<?php
// Custom Walker Class to modify the sidebar menu output
class Sidebar_Menu_Walker extends Walker_Nav_Menu {
  function start_lvl(&$output, $depth = 0, $args = null) {
    $output .= '<ul class="dropdown-menu show">';
  }
  
  function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
    // Always show dropdown menus expanded
    $classes = empty($item->classes) ? array() : (array) $item->classes;
    $classes[] = 'menu-item-' . $item->ID;
    
    if ($args->walker->has_children) {
      $classes[] = 'menu-item-has-children';
    }
    
   $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
$class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
    
    $output .= '<li' . $class_names . '>';
    
    $atts = array();
    $atts['title']  = !empty($item->attr_title) ? $item->attr_title : '';
    $atts['target'] = !empty($item->target)     ? $item->target     : '';
    $atts['rel']    = !empty($item->xfn)        ? $item->xfn        : '';
    $atts['href']   = !empty($item->url)        ? $item->url        : '';
    $atts['class']  = 'nav-link';
    
    $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
    
    $attributes = '';
    foreach ($atts as $attr => $value) {
      if (!empty($value)) {
        $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
        $attributes .= ' ' . $attr . '="' . $value . '"';
      }
    }
    
    $item_output = $args->before;
    $item_output .= '<a' . $attributes . '>';
    $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
    $item_output .= '</a>';
    $item_output .= $args->after;
    
    $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
  }
}
?>
  <?php wp_head(); ?>

<body <?php body_class(); ?>>

<!-- Transparent Header -->
<header class="transparent-header py-2" id="transparentHeader">
  <div class="container">
    <div class="d-flex align-items-center justify-content-between">
      <!-- Logo - Left Side -->
      <div class="transparent-logo">
        <?php
          $custom_logo_id = get_theme_mod('custom_logo');
          $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
          if ($logo) {
            echo '<a href="' . esc_url(home_url('/')) . '"><img src="' . esc_url($logo[0]) . '" alt="' . get_bloginfo('name') . '"></a>';
          } else {
            echo '<a href="' . esc_url(home_url('/')) . '" class="text-decoration-none">';
            echo '<span class="text-white fw-bold fs-3">' . get_bloginfo('name') . '</span>';
            echo '</a>';
          }
        ?>
      </div>

      <!-- Right Side Container for Menu + Burger -->
      <div class="d-flex align-items-center">
        <!-- Desktop Menu - Pushed Right -->
        <nav class="d-none d-lg-block me-3"> <!-- Added margin-right -->
          <?php
            wp_nav_menu(array(
              'theme_location' => 'primary',
              'container' => false,
              'menu_class' => 'nav transparent-menu',
              'fallback_cb' => '__return_false',
              'depth' => 2,
              'walker' => new bootstrap_5_wp_nav_menu_walker()
            ));
          ?>
        </nav>

        <!-- Sidebar Menu Toggle - Far Right -->
        <button class="sidebar-menu-toggle" id="sidebarMenuToggle">
          <i class="bi bi-grid"></i>
        </button>
      </div>
    </div>
  </div>
</header>

<div class="sidebar-menu" id="sidebarMenu">
    <button class="close-btn" id="sidebarMenuClose">
        <i class="bi bi-x-lg"></i>
    </button>
    
    <h3 class="text-white mb-4">Menu</h3>
    
<div class="sidebar-search mb-4">
  <div class="input-group">
    <input type="search" id="sidebar-search-input" placeholder="Search..." value="" name="s" class="form-control">
    <button type="submit" class="btn btn-primary">Search</button>
  </div>

  <!-- Results dropdown -->
  <div id="sidebar-search-results"></div>
</div>

    
    <?php 
    wp_nav_menu(array(
        'theme_location' => 'sidebar',
        'menu_class' => 'sidebar-nav-grid',
        'container' => false,
        'depth' => 2
    )); 
    ?>
    
    <div class="sidebar-social">
        <?php 
        $social_links = array(
            'facebook' => '#',
            'twitter' => '#',
            'instagram' => '#',
            'youtube' => '#',
            'tiktok' => '#'
        );
        
        foreach ($social_links as $platform => $url) {
            echo '<a href="'.esc_url($url).'" class="social-icon">';
            echo '<i class="bi bi-'.$platform.'"></i>';
            echo '</a>';
        }
        ?>
    </div>
</div>

<!-- Overlay -->
<div class="overlay" id="overlay"></div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const header = document.getElementById('transparentHeader');
    const sidebarToggle = document.getElementById('sidebarMenuToggle');
    const sidebarClose = document.getElementById('sidebarMenuClose');
    const sidebarMenu = document.getElementById('sidebarMenu');
    const overlay = document.getElementById('overlay');
    
    // Add scroll effect
    window.addEventListener('scroll', function() {
      if (window.scrollY > 100) {
        header.classList.add('scrolled');
      } else {
        header.classList.remove('scrolled');
      }
    });
    
    // Toggle sidebar menu
    sidebarToggle.addEventListener('click', function() {
      sidebarMenu.classList.add('active');
      overlay.classList.add('active');
      document.body.style.overflow = 'hidden';
    });
    
    // Close sidebar menu
    sidebarClose.addEventListener('click', function() {
      closeSidebar();
    });
    
    overlay.addEventListener('click', function() {
      closeSidebar();
    });
    
    function closeSidebar() {
      sidebarMenu.classList.remove('active');
      overlay.classList.remove('active');
      document.body.style.overflow = '';
    }
    
    // Close when clicking a link (optional)
    document.querySelectorAll('.sidebar-nav .nav-link').forEach(function(link) {
      link.addEventListener('click', function() {
        closeSidebar();
      });
    });
  });
  
document.addEventListener('DOMContentLoaded', function() {

  const sidebarInput  = document.getElementById('sidebar-search-input');
  const sidebarResult = document.getElementById('sidebar-search-results');

  sidebarInput.addEventListener('keyup', function() {
    const query = this.value.trim();

    // If empty → clear dropdown and stop
    if (query.length === 0) {
      sidebarResult.innerHTML = '';
      return;
    }

    // If less than 2 characters → clear dropdown (optional)
    if (query.length < 2) {
      sidebarResult.innerHTML = '';
      return;
    }

    // AJAX request
    fetch('<?php echo admin_url("admin-ajax.php"); ?>?action=live_search&term=' + encodeURIComponent(query))
      .then(response => response.text())
      .then(html => {
        sidebarResult.innerHTML = html;
      });
  });

});

</script>

<?php wp_footer(); ?>
