<?php /* Template Name: Single News Article Template */ get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
?>
	<main role="main">
	    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
		<section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center; ">
		    <div class="overlay">
		    <div class="page-title">
        		  <div class="container">
                    <div class="row justify-content-between">
                    <div class="col-lg-12 align-self-end"> <h1 class="entry-title"><?php the_title(); ?></h1>
                    </div>
                    </div>
                </div>
		    </div>
		    </div>
        </section><!-- Header Section !-->
		<section>
		    <div class="container page-content2">
		        <div class="row">
		            <div class="col-lg-9 col-md-9 col-sm-9" data-aos="fade up"><div class="post-content">
		        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
			<!-- article -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		            <!-- post thumbnail -->
        			<div class="post-thumbnail">
        			<?php if ( has_post_thumbnail()) : // Check if Thumbnail exists ?>
        				<?php the_post_thumbnail(); // Fullsize image for the single post ?>
        			<?php endif; ?>
        			</div>
        			<!-- /post thumbnail -->
                <h1 class="entry-title mb-0"><?php the_title(); ?></h1>
		        <p class="author date post-details mt-0"><small>Published By <strong> JobConnect </strong> <span class="author-name vcard fn author" itemprop="name"></span> 
			| <i class="bi bi-calendar3"></i> &nbsp;<?php the_time('F j, Y'); ?></small></p>
				<?php the_content(); ?>
				
				<!-- social media sharing !-->
				<div class="d-flex justify-content-center bd-highlight mb-1">
                            <div class="bd-highlight p-1">
                                <small class="text-muted">share this article</small>
                            </div>
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                <small>Share on <i class="bi bi-facebook"></i> </small>
                                </a>
                            </div><!-- Facebook !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                <small> Share on <i class="bi bi-twitter-x"></i></small>
                                </a>
                            </div><!-- Twitter !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this product: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                </a>
                            </div><!-- WhatsApp !-->
                        </div><!-- social sharing !-->
				<!-- End of Social Media sharing !-->
		        </div>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-3">
		            <div class="about-side">
		                <h3>Latest Stories</h3>
		                <?php
                        include get_template_directory() . '/inc/related-news.php';
                        ?>

		            </div>
		        </div>
		        </div>
				<?php edit_post_link(); ?>

			</article>
			<!-- /article -->

		<?php endwhile; ?>

		<?php else: ?>

			<!-- article -->
			<article>

				<h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>

			</article>
			<!-- /article -->

		<?php endif; ?>
		    </div>
		</section>
		<div class="mb-md-5 mt-3"></div>
		<!-- /section -->
 </main>


<?php get_footer(); ?>