<?php //Custom Post Type :: SLIDING PHOTOS

function custom_post_type_slides() {
    $labels = array(
        'name'                => __('Slides', 'kipya' ),
        'add_new_item'        => __( 'Add New Slide', 'kipya' ),
        'add_new'             => __( 'Add New Slide', 'kipya' ),
        'edit_item'           => __( 'Edit Slide', 'kipya' ),
        'update_item'         => __( 'Update Slide', 'kipya' ),
        'all_items'           => __( 'All Slides', 'kipya' ),
        'search_items'        => __( 'Search Slide', 'kipya' ),
        'singular_name'       => __('Slide'),
    );
    $supports = array(
        'title',        // Post title
        'excerpt',      // Allows short description
        'thumbnail',    // Allows feature images
        
        //'custom-fields' // Supports by custom fields
    );
    $args = array(
        'labels'              => $labels,
        'description'         => 'Post type for sliding photos', 
        'supports'            => $supports,
        'hierarchical'        => false, 
        'public'              => true,  // Makes the post type public
        'show_ui'             => true,  // Displays an interface for this post type
        'show_in_menu'        => true,  // Displays in the Admin Menu (the left panel)
        'show_in_admin_bar'   => true,  // Displays in the black admin bar
        'menu_position'       => 6,     // The position number in the left menu
        'menu_icon'           => 'dashicons-format-gallery',  
        'can_export'          => true,  // Allows content export using Tools -> Export
        'has_archive'         => true,  // Enables post type archive (by month, date, or year)
        'exclude_from_search' => false, 
        'capability_type'     => 'post' // Allows read, edit, delete like “Post”
    );
    register_post_type('slides', $args);
}
add_action('init', 'custom_post_type_slides');

// Register meta boxes individually
    add_action('add_meta_boxes_slides', 'add_custom_meta_boxes_slides');
    
    
//Add Custom Meta Boxes For Slide Link
function add_custom_meta_boxes_slides() {
    add_meta_box('partners_details', 'Slide URL', 'render_custom_meta_box_slides', 'slides', 'normal', 'high');
}
function render_custom_meta_box_slides($post) {
    // Get existing values
	$post_id    = $post->ID;
    $url    = get_post_meta($post->ID, '_url', true);

    // Output fields
    ?>
    <div class="row">
        <div class="col-md-12 mb-3">
            <label for="link" class="form-label"><b>Insert Post or Page Link </b></label><br/>
            <input type="text" id="link" name="url" style="width: 100%" value="<?= esc_attr($url); ?>" placeholder="https://www.example.com">
        </div>
    </div>
    <?php
}
// Save custom meta box data
function save_custom_meta_box_slides($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    // Save custom fields
    // Define an array of field names
    $fields = array('url');
    foreach ($fields as $field) {
        // Check if the field key is set in $_POST
        if (isset($_POST[$field])) {
            // If set, update post meta
            if ($field === 'project') {
                update_post_meta($post_id, '_' . $field, wp_kses_post($_POST[$field]));
            } else {
                update_post_meta($post_id, '_' . $field, sanitize_text_field($_POST[$field]));
            }
        } else {
            // If not set, handle accordingly (you can leave it empty or provide a default value)
            update_post_meta($post_id, '_' . $field, ''); // Setting it to an empty string in this case
        }
    }
}

add_action('add_meta_boxes', 'add_custom_meta_boxes_slides');
add_action('save_post', 'save_custom_meta_box_slides');


// Add custom columns to the SLIDING PHOTOS - DASHBOARD
function add_custom_columns_to_slides($columns) {
    // Add new columns
    $new_columns = array(
        'slide_photo'       => 'Photo',
        'title'             => 'Title',
        'slide_description' => 'Description',
    );

    unset($columns['date']); // Remove default date column
    // Merge the new columns with the existing columns
    $columns = array_merge($new_columns, $columns);
    return $columns;
}
add_filter('manage_edit-slides_columns', 'add_custom_columns_to_slides');


function populate_custom_columns_slides($column, $post_id) {
    switch ($column) {
        case 'slide_photo':
            // Display the featured image
            $photo_url = get_the_post_thumbnail_url($post_id, 'thumbnail'); // You can adjust the image size ('thumbnail', 'medium', 'large', 'full')
            if ($photo_url) {
                echo '<img src="' . esc_url($photo_url) . '" alt="Slide Photo" style="max-height: 80px; width: auto;" />';
            } else {
                echo 'No photo available';
            }
            break;        

        case 'slide_description':
            // Display the start date
            $descr = get_the_content($post_id, 'content');
            echo esc_html($descr);
            break;
    }
}
add_action('manage_slides_posts_custom_column', 'populate_custom_columns_slides', 10, 2);