<?php

function more_events_shortcode($atts) {
    // Define shortcode attributes, if needed
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 15,
        ),
        $atts,
        'more_events'
    );

    // Custom query to retrieve upcoming events
    $events_args = array(
        'post_type' => 'events', // Replace with your custom post type slug
        'posts_per_page' => $atts['posts_per_page'],
        'order' => 'ASC',
        'orderby' => 'meta_value',
        'meta_key' => '_start_date',
        'meta_query' => array(
            array(
                'key' => '_start_date',
                'value' => date('Y-m-d'),
                'compare' => '>=',
                'type' => 'DATE',
            ),
        ),
    );

    $events_query = new WP_Query($events_args);

    ob_start();

    // Check if there are upcoming events
    if ($events_query->have_posts()) :
        while ($events_query->have_posts()) : $events_query->the_post();
            $post_id = get_the_ID();
            $text = get_the_content();
            $url =  get_post_meta(get_the_ID(), '_link', true);
            $location =  get_post_meta(get_the_ID(), '_location', true);
            $start_date = get_post_meta(get_the_ID(), '_start_date', true);
            $formatted_start_date = date('jS, F Y', strtotime($start_date)); // Format for Date
            $formatted_start_month = date('F', strtotime($start_date)); // Format for Month
            $formatted_start_time = date('g:i A', strtotime($start_date)); // Format for Time
            ?>
            
            <div class="row kpy_event mb-3 p-2 shadow-sm" data-aos="fade-up">
                <div class="col-xl-1 col-lg-3 col-md-3 col-3">
                    <?php
                        $photo_url = get_the_post_thumbnail_url($post_id, 'thumbnail'); // You can adjust the image size ('thumbnail', 'medium', 'large', 'full')
                        if ($photo_url) {
                            echo '<img src="' . esc_url($photo_url) . '" alt="Event Photo" />';
                        } else {
                            echo '<img src="'. get_template_directory_uri().'/assets/images/placeholder-image.jpg" alt="Event Photo" class="img-fluid"/>';
                        } 
                    ?>
                </div>
                <div class="col-xl-9 col-lg-9 col-md-9 col-8">
                    <h2><?php the_title(); ?></h2>
                    <div class="row">
                        <div class="col-4 time">
                           <span style="font-weight:600;"><small>Deadline:</small></span>   <?= esc_html($formatted_start_date); ?>
                        </div>
                        <div class="col-8 time">
                        <span style="font-weight:600;"><small>From:</small></span>  <?= esc_html($location); ?>
                        </div>
                    </div><!-- Date & Time !-->
                    <span class="location">  <?= esc_html($text); ?></span>
                </div>
                <div class="col-1 align-self-center link">
                    <a href="<?= esc_url($url); ?>" target="_blank"> 
                    <i class="bi bi-chevron-double-right fs-2"></i>
                    </a> 
                </div>
            </div>
            <?php
        endwhile;
        wp_reset_postdata();
    else :
        echo 'No scholarships or opportunites.';
    endif;

    return ob_get_clean();
}

add_shortcode('more_events', 'more_events_shortcode');