<?php 
/* 
 * Template Name: Team Page Template 
 */ 
get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ); ?>
    <section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center;">
        <div class="overlay">
            <div class="page-title">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-12 align-self-end">
                            <h1 class="entry-title"><?php the_title(); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Team Section -->
    <section class="team-template-section">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="team-template-intro">
                        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
                            <?php the_content(); ?>
                        <?php endwhile; endif; ?>
                    </div>
                </div>
            </div>
            
            <?php 
            // Get team categories if you want to filter
            $categories = get_terms(array(
                'taxonomy' => 'team_category',
                'hide_empty' => true,
            ));
            
            // Query team members
            $team_args = array(
                'post_type' => 'team',
                'posts_per_page' => -1,
                'orderby' => 'menu_order',
                'order' => 'ASC'
            );
            
            $team_query = new WP_Query($team_args);
            
            if ($team_query->have_posts()) : ?>
                <div class="row team-template-members">
                    <?php while ($team_query->have_posts()) : $team_query->the_post(); 
                        // Get all custom fields
                        $position = get_post_meta(get_the_ID(), '_position', true);
                        $department = get_post_meta(get_the_ID(), '_department', true);
                        $phone = get_post_meta(get_the_ID(), '_phone', true);
                        $email = get_post_meta(get_the_ID(), '_email', true);
                        $website = get_post_meta(get_the_ID(), '_website', true);
                        
                        // Social fields
                        $facebook = get_post_meta(get_the_ID(), '_facebook', true);
                        $linkedin = get_post_meta(get_the_ID(), '_linkedin', true);
                        $instagram = get_post_meta(get_the_ID(), '_instagram', true);
                        $twitter = get_post_meta(get_the_ID(), '_x', true);
                        $whatsapp = get_post_meta(get_the_ID(), '_whatsapp', true);
                        
                        // Get categories for filtering
                        $terms = get_the_terms(get_the_ID(), 'team_category');
                        $term_classes = '';
                        if ($terms && !is_wp_error($terms)) {
                            foreach ($terms as $term) {
                                $term_classes .= ' team-template-cat-' . $term->slug;
                            }
                        }
                    ?>
                        <div class="col-lg-4 col-md-6 team-template-member<?php echo esc_attr($term_classes); ?>">
                            <div class="team-template-card">
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="team-template-image position-relative">
                                        <?php the_post_thumbnail('medium', array('class' => 'img-fluid')); ?>
                            
                                        <div class="team-template-social-overlay">
                                            <?php if ($linkedin) : ?>
                                                <a href="<?php echo esc_url($linkedin); ?>" target="_blank" rel="noopener noreferrer" aria-label="LinkedIn">
                                                    <i class="fab fa-linkedin"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($twitter) : ?>
                                                <a href="<?php echo esc_url($twitter); ?>" target="_blank" rel="noopener noreferrer" aria-label="Twitter">
                                                    <i class="fab fa-twitter"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($facebook) : ?>
                                                <a href="<?php echo esc_url($facebook); ?>" target="_blank" rel="noopener noreferrer" aria-label="Facebook">
                                                    <i class="fab fa-facebook"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($instagram) : ?>
                                                <a href="<?php echo esc_url($instagram); ?>" target="_blank" rel="noopener noreferrer" aria-label="Instagram">
                                                    <i class="fab fa-instagram"></i>
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($whatsapp) : ?>
                                                <a href="<?php echo esc_url($whatsapp); ?>" target="_blank" rel="noopener noreferrer" aria-label="WhatsApp">
                                                    <i class="fab fa-whatsapp"></i>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                    <div class="team-template-info text-center">
                                        <h3 class="team-template-name">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h3>
                                
                                        <?php if ($position) : ?>
                                            <p class="team-template-position"><?php echo esc_html($position); ?></p>
                                        <?php endif; ?>
                                
                                        <div class="team-template-contact">
                                            <?php if ($email) : ?>
                                                <p class="team-template-email">
                                                    <i class="fas fa-envelope"></i> 
                                                    <a href="mailto:<?php echo esc_attr($email); ?>">
                                                        <?php echo esc_html($email); ?>
                                                    </a>
                                                </p>
                                            <?php endif; ?>
                                            
                                            <?php if ($phone) : ?>
                                                <p class="team-template-phone">
                                                    <i class="fas fa-phone"></i> 
                                                    <a href="tel:<?php echo esc_attr(preg_replace('/[^0-9]/', '', $phone)); ?>">
                                                        <?php echo esc_html($phone); ?>
                                                    </a>
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    <?php endwhile; wp_reset_postdata(); ?>
                </div>
            <?php else : ?>
                <div class="row">
                    <div class="col-12">
                        <p><?php _e('No team members found.', 'kipya'); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
</main>

<?php get_footer(); ?>