<?php
/**
 * Template Name: News Page Template
 */
get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
    <section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat; background-size: cover; background-position: center center;">
        <div class="overlay">
            <div class="page-title">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-12 align-self-end">
                            <h1 class="entry-title"><?php the_title(); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- News Section -->
    <section class="news-template-section py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="news-template-intro mb-5">
                        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
                            <?php the_content(); ?>
                        <?php endwhile; endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Category Filter -->
            <?php 
            $news_categories = get_terms(array(
                'taxonomy' => 'news_category',
                'hide_empty' => true,
            ));
            
            if ($news_categories && !is_wp_error($news_categories)) : ?>
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <div class="news-template-filter">
                            <button class="btn btn-filter active" data-filter="*">All News</button>
                            <?php foreach ($news_categories as $category) : ?>
                                <button class="btn btn-filter" data-filter=".news-template-cat-<?php echo esc_attr($category->slug); ?>">
                                    <?php echo esc_html($category->name); ?>
                                </button>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            
            <div class="row news-template-grid">
                <?php
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $news_args = array(
                    'post_type' => 'news',
                    'posts_per_page' => 9,
                    'paged' => $paged
                );
                
                $news_query = new WP_Query($news_args);
                
                if ($news_query->have_posts()) : 
                    while ($news_query->have_posts()) : $news_query->the_post(); 
                        $categories = get_the_terms(get_the_ID(), 'news_category');
                        $category_classes = '';
                        if ($categories && !is_wp_error($categories)) {
                            foreach ($categories as $category) {
                                $category_classes .= ' news-template-cat-' . $category->slug;
                            }
                        }
                        ?>
                        <div class="col-lg-4 col-md-6 mb-4 news-template-item<?php echo esc_attr($category_classes); ?>">
                            <article class="news-template-card h-100">
                                <a href="<?php the_permalink(); ?>" class="news-template-image-link">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <?php the_post_thumbnail('medium', array('class' => 'news-template-image img-fluid')); ?>
                                    <?php else : ?>
                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/default-featured.jpg" alt="<?php the_title(); ?>" class="news-template-image img-fluid">
                                    <?php endif; ?>
                                </a>
                                <div class="news-template-card-body">
                                    <?php if ($categories) : ?>
                                        <div class="news-template-categories">
                                            <?php foreach ($categories as $category) : ?>
                                                <span class="news-template-category-badge"><?php echo esc_html($category->name); ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <h3 class="news-template-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                    
                                    <div class="news-template-meta">
                                        <span class="news-template-date"><i class="bi bi-calendar-check"></i> <?php echo get_the_date(); ?></span>
                                    </div>
                                    
                                    <div class="news-template-excerpt">
                                        <?php the_excerpt(); ?>
                                    </div>
                                    
                                    <a href="<?php the_permalink(); ?>" class="news-template-read-more">Read More →</a>
                                </div>
                            </article>
                        </div>
                    <?php endwhile; ?>
                    
                    <div class="col-12">
                        <div class="news-template-pagination">
                            <?php
                            echo paginate_links(array(
                                'total' => $news_query->max_num_pages,
                                'prev_text' => __('« Previous'),
                                'next_text' => __('Next »'),
                            ));
                            ?>
                        </div>
                    </div>
                    
                    <?php wp_reset_postdata(); ?>
                <?php else : ?>
                    <div class="col-12">
                        <p><?php _e('No news articles found.', 'kipya'); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</main>

<?php 
// Enqueue Isotope for filtering
wp_enqueue_script('isotope', 'https://unpkg.com/isotope-layout@3/dist/isotope.pkgd.min.js', array('jquery'), '3.0.6', true);
?>
<script>
jQuery(document).ready(function($) {
    // Initialize Isotope if filter buttons exist
    if ($('.news-template-filter').length) {
        var $grid = $('.news-template-grid').isotope({
            itemSelector: '.news-template-item',
            layoutMode: 'fitRows'
        });

        // Filter items on button click
        $('.news-template-filter').on('click', 'button', function() {
            var filterValue = $(this).attr('data-filter');
            $grid.isotope({ filter: filterValue });
        });

        // Change active class on buttons
        $('.news-template-filter').each(function(i, buttonGroup) {
            var $buttonGroup = $(buttonGroup);
            $buttonGroup.on('click', 'button', function() {
                $buttonGroup.find('.active').removeClass('active');
                $(this).addClass('active');
            });
        });
    }
});
</script>

<?php get_footer(); ?>