<?php
/* 
Template Name: Gallery Page Template 
*/

get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
	<section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center; ">
	    <div class="overlay">
	    <div class="page-title">
    		  <div class="container">
                <div class="row justify-content-between">
                <div class="col-lg-12 align-self-end"> <h1 class="entry-title"><?php the_title(); ?></h1>
                </div>
                </div>
            </div>
	    </div>
	    </div>
    </section>
    
    <section>
        <div class="container">
    <div class="gallery-content-area section-pad">
        <?php
        $args = array(
            'category_name' => 'gallery', // Ensure your posts are categorized under 'gallery'
            'posts_per_page' => -1, // Retrieve all posts
        );

        $query = new WP_Query($args);

        if ($query->have_posts()) : ?>
            <div class="gallery-container gallery-clearfix gallery-album-design-1">
                <?php while ($query->have_posts()) : $query->the_post(); ?>
                    <div class="gallery-item">
                        <div class="gallery-stack">
                            <a class="gallery-img-link" href="<?php the_permalink(); ?>" target="_self">
                                <?php if (has_post_thumbnail()) : ?>
                                    <img decoding="async" class="gallery-img" src="<?php the_post_thumbnail_url('large'); ?>" alt="<?php the_title(); ?>">
                                <?php endif; ?>
                            </a>
                        </div>
                        <div class="gallery-info">
                            <a class="gallery-img-link" href="<?php the_permalink(); ?>" target="_self">
                                <div class="gallery-img-title"><?php the_title(); ?></div>
                            </a>
                            <div class="gallery-img-count"><?php echo get_post_gallery_images_count(); ?> Photos</div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
        <?php else : ?>
            <article>
                <h2><?php _e('Sorry, nothing to display.', 'kipya'); ?></h2>
            </article>
        <?php endif; wp_reset_postdata(); ?>
    </div>
</div>

    </section>
    <!-- /section -->
</main>

<?php get_footer(); ?>

<?php
// Function to get the gallery images count
function get_post_gallery_images_count() {
    $gallery = get_post_gallery(get_the_ID(), false);
    return isset($gallery['ids']) ? count(explode(',', $gallery['ids'])) : 0;
}
?>