<?php 
if (is_singular('job_listing')) {
/* Template Name: Single Job Template */ get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 

	$location = get_post_meta(get_the_ID(), '_job_location', true);
    $company = get_post_meta(get_the_ID(), '_job_company', true);
    $start_date = get_post_meta(get_the_ID(), '_job_start_date', true);
    $expiry_date = get_post_meta(get_the_ID(), '_job_expiry_date', true);

    $job_type = get_post_meta(get_the_ID(), 'job_type', true);
    $jobtypes = get_the_terms(get_the_ID(), 'job_type');
    $jobtype_names = !empty($jobtypes) ? implode(', ', wp_list_pluck($jobtypes, 'name')) : 'None';

    $categories = get_the_terms(get_the_ID(), 'job_category');
        $category_names = !empty($categories) ? implode(', ', wp_list_pluck($categories, 'name')) : 'Uncategorized';
	?>
	<main role="main">
		<section>
		    <div class="container page-content2">
		        <div class="row">
		            <div class="col-lg-9 col-md-9 col-sm-9" data-aos="fade up"><div class="post-content">
		        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
			<!-- article -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<h1 class="entry-title"><?php the_title(); ?></h1>
				<hr>
				<div class="row">
					<div class="col-md-7">
					<strong>Company:</strong> <?= esc_html($company); ?>
					</div>
					<div class="col-md-5"><small>
						<div class="row g-1">
							<div class="col"><span class="badge bg-info"><?= esc_html($jobtype_names); ?></span></div>
							<div class="col"><span class="badge bg-warning"><?= esc_html($category_names); ?></span></div>
							<div class="col"><span class="badge bg-success"><?= esc_html($location); ?></span></div>
						</div></small>
					</div>
				</div>
				<hr>
				<?php the_content(); ?>
				
				<!-- social media sharing !-->
				<div class="d-flex justify-content-center bd-highlight mb-1">
                            <div class="bd-highlight p-1">
                                <small class="text-muted">share this article</small>
                            </div>
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                <small>Share on <i class="bi bi-facebook"></i> </small>
                                </a>
                            </div><!-- Facebook !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                <small> Share on <i class="bi bi-twitter-x"></i></small>
                                </a>
                            </div><!-- Twitter !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this product: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                </a>
                            </div><!-- WhatsApp !-->
                        </div><!-- social sharing !-->
				<!-- End of Social Media sharing !-->
		        </div>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-3">
		            <div class="about-side">
		                <h3>Latest Stories</h3>
		                <?php
                        include get_template_directory() . '/inc/related-news.php';
                        ?>

		            </div>
		        </div>
		        </div>
				<?php edit_post_link(); ?>

			</article>
			<!-- /article -->

		<?php endwhile; ?>

		<?php else: ?>

			<!-- article -->
			<article>

				<h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>

			</article>
			<!-- /article -->

		<?php endif; ?>
		    </div>
		</section>
		<div class="mb-md-5 mt-3"></div>
		<!-- /section -->
 </main>
<?php 
} else {
    // If the post type is not "downloads", you can display a message or redirect to another page
    echo '<p>Sorry, this page is only for Jobs.</p>';
}
get_footer(); ?>