<?php
// Register Custom Post Type for Stats
function create_stats_post_type() {
    register_post_type('stats',
        array(
            'labels' => array(
                'name' => __('Stats'),
                'singular_name' => __('Stat'),
                'add_new_item' => __('Add New Stat'),
                'edit_item' => __('Edit Stat'),
                'new_item' => __('New Stat'),
                'view_item' => __('View Stat'),
                'search_items' => __('Search Stats'),
            ),
            'public' => true,
            'has_archive' => false,
            'show_in_menu' => true,
            'menu_icon' => 'dashicons-chart-bar',
            'supports' => array('title'),
            'rewrite' => array('slug' => 'stats'),
        )
    );
}
add_action('init', 'create_stats_post_type');

// Add custom fields for Stats
function add_stats_meta_boxes() {
    add_meta_box(
        'stats_details',
        'Stat Details',
        'stats_meta_box_callback',
        'stats',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_stats_meta_boxes');

function stats_meta_box_callback($post) {
    wp_nonce_field('stats_meta_box', 'stats_meta_box_nonce');
    
    $icon = get_post_meta($post->ID, '_stat_icon', true);
    $figure = get_post_meta($post->ID, '_stat_figure', true);
    $description = get_post_meta($post->ID, '_stat_description', true);
    
    echo '<p><label for="stat_icon">Font Awesome Icon Class:</label>';
    echo '<input type="text" id="stat_icon" name="stat_icon" value="' . esc_attr($icon) . '" class="widefat" placeholder="fas fa-users"></p>';
    
    echo '<p><label for="stat_figure">Figure:</label>';
    echo '<input type="text" id="stat_figure" name="stat_figure" value="' . esc_attr($figure) . '" class="widefat" placeholder="500+"></p>';
    
    echo '<p><label for="stat_description">Description:</label>';
    echo '<input type="text" id="stat_description" name="stat_description" value="' . esc_attr($description) . '" class="widefat" placeholder="Clients"></p>';
}

function save_stats_meta($post_id) {
    if (!isset($_POST['stats_meta_box_nonce']) || !wp_verify_nonce($_POST['stats_meta_box_nonce'], 'stats_meta_box')) {
        return;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    
    if (isset($_POST['stat_icon'])) {
        update_post_meta($post_id, '_stat_icon', sanitize_text_field($_POST['stat_icon']));
    }
    
    if (isset($_POST['stat_figure'])) {
        update_post_meta($post_id, '_stat_figure', sanitize_text_field($_POST['stat_figure']));
    }
    
    if (isset($_POST['stat_description'])) {
        update_post_meta($post_id, '_stat_description', sanitize_text_field($_POST['stat_description']));
    }
}
add_action('save_post', 'save_stats_meta');
?>