<section class="main-slider position-relative">
    <?php $slider_query = new WP_Query(array('post_type' => 'slides', 'posts_per_page' => -1)); ?>
    
    <div class="swiper-container thm-swiper__slider" data-swiper-options='{
        "slidesPerView": 1,
        "loop": true,
        "effect": "fade",
        "fadeEffect": { "crossFade": true },
        "speed": 1000,
        "pagination": {
            "el": "#main-slider-pagination",
            "type": "bullets",
            "clickable": true
        },
        "navigation": {
            "nextEl": "#main-slider__swiper-button-next",
            "prevEl": "#main-slider__swiper-button-prev"
        },
        "autoplay": {
            "delay": 5000
        }
    }'>
        <div class="swiper-wrapper">
            <?php if ($slider_query->have_posts()): while ($slider_query->have_posts()): $slider_query->the_post(); ?>
                <div class="swiper-slide">
                    <div class="image-layer position-absolute w-100 h-100" 
                         style="background-image: url(<?= get_the_post_thumbnail_url(); ?>);"
                         loading="lazy"></div>
                         <div class="slider-overlay position-absolute w-100 h-100"></div>
                    <!--<div class="slider-overlay position-absolute w-100 h-100" -->
                    <!--     style="background: linear-gradient(to right, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0.3) 100%);"></div>-->
                    
                    <div class="container h-75">
                        <div class="row h-75 align-items-end">
                            <!-- Text Column -->
                            <div class="col-lg-8 d-flex flex-column align-items-start justify-content-end">
                                <div class="main-slider-content text-white" data-aos="fade-right">
                                	<div class="big-title">
									    <h2><?= esc_html(get_the_title()) ?></h2>
									</div>
									<div class="text">
										<p><?= esc_html(get_the_excerpt()) ?></p>
									</div>
                                    
                                    <hr class="hero-line border-top border-1 border-white w-100 my-4">
                                </div>
                                <a href="#" class="btn-lg px-5 py-3 fw-regular schedule-button text-white">
                                    Schedule a Consultation <i class="bi bi-arrow-right ms-2"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; endif; ?>
        </div>

        <!-- Navigation -->
       	<div class="main-slider__nav">
            <div class="swiper-button-prev" id="main-slider__swiper-button-next" tabindex="0" role="button" aria-label="Next slide">
                <i class="bi bi-chevron-left"></i>
            </div>
            <div class="swiper-button-next" id="main-slider__swiper-button-prev" tabindex="0" role="button" aria-label="Previous slide">
                <i class="bi bi-chevron-right"></i>
            </div>
	    </div>

    </div>
    <?php wp_reset_postdata(); ?>
</section>

