<?php 
function law_sidebar_menu_shortcode() {
    ob_start();

    $categories = array(
        'commercial-and-corporate-law' => 'commercial-and-corporate-law',
        'conveyancing-and-real-property-loyal-practice' => 'conveyancing-and-real-property-loyal-practice',
        'litigation-and-dispute-resolution' => 'litigation-and-dispute-resolution',
    );

    echo '<div class="sidebar-service-list"><ul>';

    foreach ($categories as $slug => $label) {
        // Get top-level category link
        $term = get_term_by('slug', $slug, 'page_category');
        $term_link = get_term_link($term);

        echo '<li><a href="' . esc_url($term_link) . '"><i class="fas fa-angle-right"></i><span>' . esc_html($label) . '</span></a>';

        // Fetch child pages in this category
        $args = array(
            'post_type' => 'page',
            'posts_per_page' => -1,
            'orderby' => 'title',
            'order' => 'ASC',
            'tax_query' => array(
                array(
                    'taxonomy' => 'page_category',
                    'field' => 'slug',
                    'terms' => $slug,
                ),
            ),
        );

        $sub_query = new WP_Query($args);

        if ($sub_query->have_posts()) {
            echo '<ul>';
            while ($sub_query->have_posts()) {
                $sub_query->the_post();
                echo '<li><a href="' . get_permalink() . '">' . get_the_title() . '</a></li>';
            }
            echo '</ul>';
        }

        echo '</li>';
        wp_reset_postdata();
    }

    echo '</ul></div>';

    return ob_get_clean();
}
add_shortcode('law_sidebar_menu', 'law_sidebar_menu_shortcode');

?>
