<div class="row">
<?php //upcoming Events

 // Custom query to retrieve upcoming events
    $events_args = array(
        'post_type' => 'events', // Replace with your custom post type slug
        'posts_per_page' => 4,
        'order' => 'ASC',
        'orderby' => 'meta_value',
        'meta_key' => '_start_date',
        'meta_query' => array(
            array(
                'key' => '_start_date',
                'value' => date('Y-m-d'),
                'compare' => '>=',
                'type' => 'DATE',
            ),
        ),
    );

    $events_query = new WP_Query($events_args);
    
// Check if there are upcoming events
    if ($events_query->have_posts()) :
        while ($events_query->have_posts()) : $events_query->the_post();
            $post_id = get_the_ID();
            $location =  get_post_meta(get_the_ID(), '_location', true);
            $start_date = get_post_meta(get_the_ID(), '_start_date', true);
            $formatted_start_date = date('jS, F Y', strtotime($start_date)); // Format for Date
            $formatted_start_month = date('F', strtotime($start_date)); // Format for Month
            $formatted_start_time = date('g:i A', strtotime($start_date)); // Format for Time
            ?>
            <div class="col-xl-3 col-lg-4 col-sm-6">
            <a data-bs-toggle="offcanvas" data-bs-target="#staticBackdrop-<?= $post_id; ?>" aria-controls="staticBackdrop-<?= $post_id; ?>" style="cursor: pointer">
                <div class="card shadow-sm mb-3 border-0" data-aos="fade-up">
					<div class="post-thumbnail">
						<?php // Display the post thumbnail
							if (has_post_thumbnail()) {
								the_post_thumbnail(); 
							}else{
								echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="NGO Forum" class="img-fluid"/>';
							}
						?>
					</div><!-- thumbnail !-->
					<div class="card-body">
					    <div class="date">
					        <i class="bi bi-calendar2-event"></i>  <?= esc_html($formatted_start_date); ?>
					    </div>
						<h3><?php the_title(); ?></h3>
						<span class="location"><i class="bi bi-geo-alt"></i>  <?= esc_html($location); ?></span>
					</div><!-- card body !-->
				</div><!-- card !-->
            </a>
            </div><!-- col !-->
            
            <!-- Full Event !-->
            <div class="offcanvas offcanvas-end kpy_event_details"  tabindex="-1" id="staticBackdrop-<?php echo $post_id; ?>" aria-labelledby="staticBackdropLabel-<?php echo $post_id; ?>">
                    <?php // Display the post thumbnail
							if (has_post_thumbnail()) {
								the_post_thumbnail(); 
							}else{
								echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="NGO Forum" class="img-fluid"/>';
							}
					?>
                <div class="offcanvas-header">
                    <h5 class="offcanvas-title" id="staticBackdropLabel"><?php the_title(); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    <div class="row mb-4">
                        <div class="col-6 time">
                            <i class="bi bi-calendar-check"></i>  <?= esc_html($formatted_start_date); ?>
                        </div>
                        <div class="col-6 location">
                            <i class="bi bi-geo-alt"></i>  <?php echo esc_html($location); ?>
                        </div>
                    </div><!-- Date & Location !-->
                    <div>
                    <?= esc_html(the_content()); ?>
                    </div>
                </div>
            </div><!-- offcanvas !-->
            <?php
        endwhile;
        wp_reset_postdata();
    else :
        echo 'Sorry! No upcoming events found.';
    endif;
    ?>
 </div>