<?php
/**
 * Handle contact form submission
 */
function handle_contact_form_submission() {
    if (isset($_POST['contact_submit']) && wp_verify_nonce($_POST['contact_nonce'], 'contact_form_action')) {
        
        // Sanitize all inputs
        $first_name = sanitize_text_field($_POST['first_name']);
        $last_name  = sanitize_text_field($_POST['last_name']);
        $email      = sanitize_email($_POST['email']);
        $phone      = sanitize_text_field($_POST['phone']);
        $subject    = sanitize_text_field($_POST['subject']);
        $message    = wp_kses_post($_POST['message']);
        
        // Validate required fields
        if (empty($first_name) || empty($last_name) || empty($email) || empty($message)) {
            wp_redirect(add_query_arg('contact', 'error', wp_get_referer()));
            exit;
        }
        
        // Email setup
        $to = get_option('admin_email'); // Sends to admin email by default
        $email_subject = "New Contact Form Submission: $subject";
        
        $email_body = "
            <h2>New Contact Form Submission</h2>
            <p><strong>Name:</strong> $first_name $last_name</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Phone:</strong> $phone</p>
            <p><strong>Subject:</strong> $subject</p>
            <p><strong>Message:</strong></p>
            <div style=\"padding:10px;background:#f5f5f5;border-radius:5px;\">$message</div>
            <p style=\"margin-top:20px;\"><em>This message was sent from your website contact form.</em></p>
        ";
        
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            "From: $first_name $last_name <$email>",
            "Reply-To: $first_name $last_name <$email>"
        );
        
        // Send email
        $mail_sent = wp_mail($to, $email_subject, $email_body, $headers);
        
        // Redirect with status
        wp_redirect(add_query_arg('contact', $mail_sent ? 'success' : 'error', wp_get_referer()));
        exit;
    }
}
add_action('template_redirect', 'handle_contact_form_submission');

/**
 * Display contact form shortcode
 */
function display_custom_contact_form($atts) {
    // Check for success/error messages
    $status = isset($_GET['contact']) ? $_GET['contact'] : '';
    
    ob_start(); ?>
    
    <?php if ($status === 'success') : ?>
        <div class="alert alert-success mb-4 px-5">
            Thank you! Your message has been sent successfully.
        </div>
    <?php elseif ($status === 'error') : ?>
        <div class="alert alert-danger mb-px-5 v">
            There was an error sending your message. Please try again.
        </div>
    <?php endif; ?>
    
    <form method="post" class="contact-form px-5">
        <?php wp_nonce_field('contact_form_action', 'contact_nonce'); ?>
        
        <div class="row g-3">
            <div class="col-md-6">
                <input type="text" name="first_name" class="form-control form-glass py-3" 
                       placeholder="First Name" required value="<?php echo isset($_POST['first_name']) ? esc_attr($_POST['first_name']) : ''; ?>">
            </div>
            <div class="col-md-6">
                <input type="text" name="last_name" class="form-control form-glass py-3" 
                       placeholder="Last Name" required value="<?php echo isset($_POST['last_name']) ? esc_attr($_POST['last_name']) : ''; ?>">
            </div>
            <div class="col-12">
                <input type="email" name="email" class="form-control form-glass py-3" 
                       placeholder="Email" required value="<?php echo isset($_POST['email']) ? esc_attr($_POST['email']) : ''; ?>">
            </div>
            <div class="col-12">
                <input type="tel" name="phone" class="form-control form-glass py-3" 
                       placeholder="Phone" value="<?php echo isset($_POST['phone']) ? esc_attr($_POST['phone']) : ''; ?>">
            </div>
            <div class="col-12">
                <select name="subject" class="form-select form-glass py-3" required>
                    <option value="" disabled <?php selected(!isset($_POST['subject'])); ?>>Subject</option>
                    <option value="General Inquiry" <?php selected(isset($_POST['subject']) && $_POST['subject'] === 'General Inquiry'); ?>>General Inquiry</option>
                    <option value="Support Request" <?php selected(isset($_POST['subject']) && $_POST['subject'] === 'Support Request'); ?>>Support Request</option>
                    <option value="Partnership" <?php selected(isset($_POST['subject']) && $_POST['subject'] === 'Partnership'); ?>>Partnership</option>
                </select>
            </div>
            <div class="col-12">
                <textarea name="message" class="form-control form-glass py-3" rows="4" 
                          placeholder="Your Message" required><?php echo isset($_POST['message']) ? esc_textarea($_POST['message']) : ''; ?></textarea>
            </div>
            <div class="col-12">
                <button type="submit" name="contact_submit" class="btn btn-dark w-100 py-3 fw-bold">
                    Send Message
                </button>
            </div>
        </div>
    </form>
    
    <?php
    return ob_get_clean();
}
add_shortcode('custom_contact_form', 'display_custom_contact_form');
?>