<?php
    // Function to display breadcrumb
    function custom_breadcrumb() {
    echo '<div class="breadcrumb" data-aos="fade-up">';
    echo '<a href="' . home_url() . '">Home</a>';

    // Check if on a single post or page
    if (is_single() || is_page()) {
        $categories = get_the_category();
        if ($categories) {
            $category = $categories[0];
            echo ' / <a href="' . esc_url(get_category_link($category->term_id)) . '">' . esc_html($category->name) . '</a>';
        }

        echo ' / ' . get_the_title();
    } elseif (is_category()) {
        $category = get_queried_object();
        echo ' / ' . esc_html($category->name);
    } elseif (is_tag()) {
        $tag = get_queried_object();
        echo ' / ' . esc_html($tag->name);
    } elseif (is_author()) {
        $author = get_queried_object();
        echo ' / ' . esc_html($author->display_name);
    } elseif (is_search()) {
        echo ' / Search results for "' . esc_html(get_search_query()) . '"';
    } elseif (is_404()) {
        echo ' / 404 Page Not Found';
    }

    echo '</div>';
}

?>
