<?php
function allNews_shortcode() {
    ob_start(); // Start output buffering

	$news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 20,
		'category_name' => 'news, blog',
		);
	?>																
	<?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			<div class="col-md-12 kpy-all-news">
				<article>
					<div class="card card-body mb-3 border-0" data-aos="fade-up">
						<a href="<?= esc_url(get_permalink()); ?>"><h3><?php the_title(); ?></h3></a>
							<div class="catz">
									<i class="bi bi-calendar-check"></i> <?php
									$post_date = get_the_date();
									echo $post_date;
									?>
								</div><!-- Date !-->
							<div class="post-thumbnail">
								<?php 
									if (has_post_thumbnail()) {
										the_post_thumbnail('full'); 
									}else{
										echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="NGO" class="img-fluid"/>';
									}
								?>
								
							</div>
							<div class="post-excerpt">
								<?php the_excerpt(); ?>	
							</div>	
						<a href="<?= esc_url(get_permalink()); ?>" class="read-more">Continue Reading </a>
					</div><!-- card !-->
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
	<style>
	    .kpy-all-news .post-thumbnail{margin: 20px 0 20px 0;border-radius: 15px;width: 100%;overflow: hidden;transition: all .3s cubic-bezier(.3,.58,.55,1);}
        .kpy-all-news img {width: 100%; height: 400px;  object-fit: cover;overflow-clip-margin: content-box;overflow: clip;}
        .kpy-all-news .post-thumbnail:hover img{zoom: 1;transform: scale(1.05) !important; transition: transform 2.4s cubic-bezier(.075,.82,.165,1);vertical-align: top;}
        .kpy-all-news h3{font-size: 34px;font-weight: 700;margin: 20px 0 5px 0;color: #000000;letter-spacing: 0px;line-height: 1.5;}
        .kkpy-all-news .catz{margin: 0 0 10px 0;display: inline-block;font-size: 15px;font-weight: 500;}
        .kpy-all-news .catz i::before {padding-right:0.5rem;}
        .kpy-all-news .post-excerpt p{padding-top: .7em;padding-bottom: 1.3em;color: #000000;line-height: 1.7;}
        .kpy-all-news .read-more{color: #000;display: flex;transition: 0.5s all;}
        .kpy-all-news .read-more::after{content:"\F138" ;font-family: bootstrap-icons;font-size: 15px;margin-left: 5px;}
	</style>
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('all_news', 'allNews_shortcode');

?>