<!Doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<title>
    <?php
      $seo_title = get_post_meta(get_the_ID(), '_seo_title', true);
      if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
    ?>
		</title>
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="description" content="
      <?php
      $seo_description = get_post_meta(get_the_ID(), '_seo_description', true);
      if (!empty($seo_description)) { echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
      ?>
    ">
    <meta name="keywords" content="
      <?php
      $seo_keywords = get_post_meta(get_the_ID(), '_seo_keywords', true);
      if (!empty($seo_keywords)) {echo esc_html($seo_keywords);} else {echo esc_html('Uganda law firm, Best advocates in Kampala, Corporate lawyers Uganda, International legal services Uganda, NARE Advocates Kampala, Licensed lawyers Uganda, Legal consultation Uganda');}
      ?>
    ">
		<!-- Open Graph and Twitter Card Meta Tags -->
    <meta property="og:title" content="
      <?php
        if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
      ?>
    "/>
    <meta property="og:description" content="
      <?php
        if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
      ?>
    "/>
    <meta property="og:image" content="
      <?php
      $featured_image = get_the_post_thumbnail_url();
      $default_image=  get_template_directory() . '/assets/images/jobconnect-uganda.jpg'; 
      if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
      ?>
    " />
    <meta property="og:url" content="<?php the_permalink(); ?>" />
    <meta name="twitter:title" content="
      <?php
      if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
      ?>
    "/>
    <meta name="twitter:description" content="
      <?php
      if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());} 
      ?>
    "/>
    <meta name="twitter:image" content="
      <?php
      if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
      ?>
    "/>
    <meta name="twitter:url" content="<?php the_permalink(); ?>" />
		  <meta name="google-site-verification" content="Sk61s_LXBI0q4E5gbDGbnmSTqiUJFFC1zBgwWLIXQ64" />
		    <link href="//www.google-analytics.com" rel="dns-prefetch">
        <link href="<?php echo get_template_directory_uri(); ?>/favicon.png" rel="shortcut icon">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Noto+Sans:ital,wght@0,100..900;1,100..900&family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&family=Urbanist:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
        <!-- Add the Font Awesome CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
		<!--Popup Modal-->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <!-- Include Magnific Popup -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
        <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
        <script>
  document.addEventListener('DOMContentLoaded', function() {
    // Define the breakpoint where "mobile" behavior starts
    const mobileBreakpoint = 992; //Bootstrap's mobile breakpoint

    // Select all dropdown elements
    var dropdowns = document.querySelectorAll('.dropdown');

    function handleDropdownHover() {
      dropdowns.forEach(function(dropdown) {
        dropdown.addEventListener('mouseenter', function() {
          var dropdownMenu = this.querySelector('.dropdown-menu');
          if (dropdownMenu) {
            dropdownMenu.classList.add('show');
          }
        });

        dropdown.addEventListener('mouseleave', function() {
          var dropdownMenu = this.querySelector('.dropdown-menu');
          if (dropdownMenu) {
            dropdownMenu.classList.remove('show');
          }
        });
      });
    }

    function handleDropdownClick() {
      dropdowns.forEach(function(dropdown) {
        dropdown.addEventListener('click', function(e) {
          e.stopPropagation(); // Stop the click event from bubbling up
          var dropdownMenu = this.querySelector('.dropdown-menu');
          if (dropdownMenu) {
            dropdownMenu.classList.toggle('show');
          }
        });
      });

      // Close the dropdown menu if clicked outside of it
      document.addEventListener('click', function(e) {
        dropdowns.forEach(function(dropdown) {
          var dropdownMenu = dropdown.querySelector('.dropdown-menu');
          if (dropdownMenu && !dropdown.contains(e.target)) {
            dropdownMenu.classList.remove('show');
          }
        });
      });
    }

    function handleResponsiveDropdowns() {
      if (window.innerWidth >= mobileBreakpoint) {
        // Desktop - hover behavior
        handleDropdownHover();
      } else {
        // Mobile - click behavior
        handleDropdownClick();
      }
    }

    // Initialize the correct behavior based on the screen size
    handleResponsiveDropdowns();

    // Add resize event listener to re-check screen size
    window.addEventListener('resize', function() {
      // Clear any active event listeners to avoid duplicates
      dropdowns.forEach(function(dropdown) {
        dropdown.replaceWith(dropdown.cloneNode(true)); // Removes all attached event listeners
      });

      // Reinitialize the behavior based on new screen size
      handleResponsiveDropdowns();
    });
  });

add_action('wp_footer', 'add_team_script');
</script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css" />
        <script src="https://cdn.jsdelivr.net/gh/mcstudios/glightbox/dist/js/glightbox.min.js"></script>   
        <?php wp_head(); ?>

	</head>
	<body <?php body_class(); ?>>
	