t. document.addEventListener("DOMContentLoaded", function() {
    // Wait for images to load
    if (document.querySelector('.what-we-do-section')) {
        window.addEventListener('load', function() {
            const servicesList = document.querySelector(".services-list");
            const rightContent = document.querySelector(".right-content");
            
            if (servicesList && rightContent) {
                // Calculate the scrollable distance
                const scrollDistance = servicesList.scrollHeight - rightContent.offsetHeight;
                
                // Reset position
                gsap.set(".services-list", { y: 0 });
                
                // Register ScrollTrigger plugin
                gsap.registerPlugin(ScrollTrigger);
                
                // Animate the services list
                gsap.to(".services-list", {
                    y: -scrollDistance,
                    ease: "none",
                    scrollTrigger: {
                        trigger: ".what-we-do-section",
                        pin: true,
                        start: "top top",
                        end: () => `+=${scrollDistance}`,
                        scrub: 1,
                        markers: false,
                        invalidateOnRefresh: true
                    }
                });
            }
        });
        
        // Handle resize events
        function handleResize() {
            ScrollTrigger.refresh();
        }
        
        window.addEventListener('resize', handleResize);
    }
}); 