<?php
// Function to display breadcrumb with styled title + Home link
function custom_breadcrumb() {
    // Figure out the "current" label
    if ( is_single() || is_page() ) {
        $current = get_the_title();
    } elseif ( is_category() ) {
        $obj     = get_queried_object();
        $current = esc_html( $obj->name );
    } elseif ( is_tag() ) {
        $obj     = get_queried_object();
        $current = esc_html( $obj->name );
    } elseif ( is_author() ) {
        $obj     = get_queried_object();
        $current = esc_html( $obj->display_name );
    } elseif ( is_search() ) {
        $current = 'Search results for "' . esc_html( get_search_query() ) . '"';
    } elseif ( is_404() ) {
        $current = '404 Page Not Found';
    } else {
        $current = get_the_archive_title();
    }
    
    if ( ! $current ) {
        return;
    }
    
    // Output markup
echo '<div class="custom-breadcrumb" style="text-align: center; color: var(--ls-white); position: relative; z-index: 10;">';
  // Bold, uppercase, primary color page title
 echo '<h1 class="breadcrumb-title" style="font-size: clamp(1.2rem, 4vw, 2.5rem); font-weight: 900; color: var(--ls-white); line-height: 1.2; margin-top: clamp(80px, 15vw, 150px); margin-bottom: clamp(15px, 3vw, 25px);">'
       . esc_html( $current )
       . '</h1>';
  // Home / Current link trail
  echo '<div class="breadcrumb-nav" style="font-size:12px; color: var(--ls-white); margin-top: 18px; font-weight: 600; text-shadow: 2px 2px 4px rgba(0,0,0,0.7);">'
       . '<a href="' . esc_url( home_url() ) . '" style="color: var(--ls-white); text-decoration:none; transition: color 0.3s ease; font-weight: 700; text-shadow: 2px 2px 4px rgba(0,0,0,0.7);" onmouseover="this.style.color=\'var(--ls-white)\'" onmouseout="this.style.color=\'var(--ls-white)\'">Home</a>'
       . ' <span style="margin: 0 8px; font-weight: 700; text-shadow: 2px 2px 4px rgba(0,0,0,0.7);">/</span> '
       . '<span style="color: var(--ls-white); font-weight: 700; text-shadow: 2px 2px 4px rgba(0,0,0,0.7);">' . esc_html( $current ) . '</span>'
       . '</div>';
echo '</div>';
}
?>