<?php
function allProjects_shortcode() {
    ob_start();

    $projects_args = array(
        'post_type' => array('post'),
        'posts_per_page' => 20,
        'category_name' => 'projects',
    );
    
    $projects_query = new WP_Query($projects_args); ?>

    <div class="liberty-projects-wrapper" data-aos="fade-up">
        <?php if ($projects_query->have_posts()) : ?>
            <div class="liberty-projects-container">
                <div class="liberty-projects-grid">
                    <?php $delay = 0; while ($projects_query->have_posts()) :
                        $projects_query->the_post();
                        $categories = get_the_category();
                        $primary_category = !empty($categories) ? $categories[0]->name : 'Projects';
                    ?>
                    <div class="liberty-project-card" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
                        <div class="liberty-project-image">
                            <div class="liberty-project-img" style="background-image: url('<?php echo has_post_thumbnail() ? esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')) : esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg'); ?>');">
                            </div>
                        </div>
                        <div class="liberty-project-content">
                            <h3 class="liberty-project-title"><?php the_title(); ?></h3>
                            <div class="liberty-project-description">
                                <?php echo wp_trim_words(get_the_excerpt(), 10); ?>
                            </div>
                            <a href="<?php echo esc_url(add_query_arg('project_view', get_the_ID(), get_permalink())); ?>" class="liberty-project-btn">
                                Read More
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M5 12h14M12 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                    <?php $delay += 100; endwhile;
                        wp_reset_postdata();
                    else :
                        echo '<p class="text-center py-5" data-aos="fade-up">No projects found.</p>';
                    endif;
                    ?>
                </div>
            </div>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('all_projects', 'allProjects_shortcode');

function projects_slider_shortcode() {
    ob_start();

    $projects_args = array(
        'post_type' => array('post'),
        'posts_per_page' => 6,
        'category_name' => 'projects',
    );
    
    $projects_query = new WP_Query($projects_args); ?>
    
    <div class="liberty-projects-slider-wrapper" data-aos="fade-up">
        <div class="liberty-projects-slider-header" data-aos="fade-up" data-aos-delay="100">
            <div class="ls-hero-badge" data-aos="fade-up">What We Work On</div>
            <h2 class="liberty-projects-slider-title">Our Projects</h2>
            <p class="liberty-projects-slider-subtitle">Discover the impact we're making through our projects</p>
        </div>
        
        <div class="liberty-projects-slider-container" data-aos="fade-up" data-aos-delay="200">
            <div class="liberty-projects-slider">
                <?php if ($projects_query->have_posts()) : ?>
                    <?php while ($projects_query->have_posts()) : $projects_query->the_post(); ?>
                    <div class="liberty-projects-slide">
                        <div class="liberty-project-card">
                            <div class="liberty-project-image">
                                <div class="liberty-project-img" style="background-image: url('<?php echo has_post_thumbnail() ? esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')) : esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg'); ?>');"></div>
                                <!--<div class="liberty-project-badge">Project</div>-->
                            </div>
                            <div class="liberty-project-content">
                                <div class="liberty-project-meta">
                                    <span class="liberty-project-category"><?php echo get_the_category_list(', '); ?></span>
                                </div>
                                <h3 class="liberty-project-title"><?php the_title(); ?></h3>
                                <div class="liberty-project-description">
                                    <?php echo wp_trim_words(get_the_excerpt(), 8); ?>
                                </div>
                                <div class="liberty-project-footer">
                                    <a href="<?php echo esc_url(add_query_arg('project_view', get_the_ID(), get_permalink())); ?>" class="liberty-project-btn">
                                        Read More
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M5 12h14M12 5l7 7-7 7"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                <?php else : ?>
                    <p class="liberty-projects-slider-empty">No projects found. Check back soon for updates.</p>
                <?php endif; ?>
            </div>
            
            <div class="liberty-slider-dots"></div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const slider = document.querySelector('.liberty-projects-slider');
        const slides = document.querySelectorAll('.liberty-projects-slide');
        const dotsContainer = document.querySelector('.liberty-slider-dots');
        
        if (!slider || !slides.length) return;
        
        let currentIndex = 0;
        let autoScrollInterval;
        let isHovered = false;
        
        // Create dots
        slides.forEach((_, index) => {
            const dot = document.createElement('button');
            dot.classList.add('liberty-slider-dot');
            dot.setAttribute('aria-label', `Go to slide ${index + 1}`);
            dot.addEventListener('click', () => goToSlide(index));
            dotsContainer.appendChild(dot);
        });
        
        const dots = document.querySelectorAll('.liberty-slider-dot');
        
        function updateDots() {
            dots.forEach((dot, index) => {
                if (index === currentIndex) {
                    dot.classList.add('active');
                } else {
                    dot.classList.remove('active');
                }
            });
        }
        
        function goToSlide(index) {
            currentIndex = index;
            slider.scrollTo({
                left: index * slider.offsetWidth,
                behavior: 'smooth'
            });
            updateDots();
        }
        
        function nextSlide() {
            currentIndex = (currentIndex + 1) % slides.length;
            goToSlide(currentIndex);
        }
        
        function startAutoScroll() {
            autoScrollInterval = setInterval(() => {
                if (!isHovered) {
                    nextSlide();
                }
            }, 5000);
        }
        
        slider.addEventListener('mouseenter', () => isHovered = true);
        slider.addEventListener('mouseleave', () => isHovered = false);
        
        // Initialize
        updateDots();
        startAutoScroll();
        
        // Cleanup on unmount
        return () => clearInterval(autoScrollInterval);
    });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('projects_slider', 'projects_slider_shortcode');

function projects_gallery_shortcode($atts) {
    ob_start();
    
    $atts = shortcode_atts(array(
        'posts_per_page' => -1,
        'category' => 'projects'
    ), $atts);
    
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'category_name' => $atts['category'],
        'paged' => $paged
    );
    
    $projects_query = new WP_Query($args);
    
    if ($projects_query->have_posts()) : ?>
        <div class="liberty-projects-gallery-wrapper" data-aos="fade-up">
            <div class="liberty-projects-gallery-container">
                <div class="liberty-projects-gallery-grid">
                    <?php $delay = 0; while ($projects_query->have_posts()) : $projects_query->the_post(); ?>
                        <div class="liberty-project-gallery-card" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
                            <div class="liberty-project-gallery-image">
                                <div class="liberty-project-gallery-img" style="background-image: url('<?php echo has_post_thumbnail() ? esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')) : esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg'); ?>');">
                                </div>
                            </div>
                            <div class="liberty-project-gallery-content">
                                <div class="liberty-project-gallery-icon">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                                    </svg>
                                </div>
                                <h3 class="liberty-project-gallery-title"><?php the_title(); ?></h3>
                                <div class="liberty-project-gallery-description">
                                    <?php echo wp_trim_words(get_the_excerpt(), 20); ?>
                                </div>
                                <a href="<?php echo esc_url(add_query_arg('project_view', get_the_ID(), get_permalink())); ?>" class="liberty-project-gallery-btn">
                                    Read More
                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M5 12h14M12 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    <?php $delay += 100; endwhile; ?>
                </div>
                
                <div class="liberty-projects-gallery-pagination" data-aos="fade-up" data-aos-delay="300">
                    <?php
                    echo paginate_links(array(
                        'total' => $projects_query->max_num_pages,
                        'current' => $paged,
                        'prev_text' => __('<span class="pagination-arrow">&larr;</span> Previous'),
                        'next_text' => __('Next <span class="pagination-arrow">&rarr;</span>'),
                        'type' => 'list',
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>
        </div>
    <?php else : ?>
        <p class="liberty-no-projects" data-aos="fade-up">No projects found.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('projects_gallery', 'projects_gallery_shortcode');
?>