<?php
function allNews_shortcode() {
    ob_start();

    $news_args = array(
        'post_type' => array('post'),
        'posts_per_page' => 20,
        'category_name' => 'news, blog',
    );
    
    $news_query = new WP_Query($news_args); ?>

    <div class="liberty-news-wrapper" data-aos="fade-up">
        <?php if ($news_query->have_posts()) : ?>
        <div class="liberty-news-container">
            <div class="liberty-news-grid">
                <?php $delay = 0; while ($news_query->have_posts()) :
                    $news_query->the_post();
                    $categories = get_the_category();
                    $primary_category = !empty($categories) ? $categories[0]->name : 'News';
                ?>
                <article class="liberty-news-card" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
                    <div class="liberty-news-image">
                        <a href="<?= esc_url(get_permalink()); ?>">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium_large', ['class' => 'liberty-news-img']); ?>
                            <?php else : ?>
                                <img src="<?= get_template_directory_uri(); ?>/assets/images/photo-placeholder.jpg" alt="<?php the_title(); ?>" class="liberty-news-img"/>
                            <?php endif; ?>
                        </a>
                        <span class="liberty-news-badge"><?= esc_html($primary_category); ?></span>
                    </div>
                    <div class="liberty-news-content">
                        <div class="liberty-news-meta">
                            <span class="liberty-news-date">
                                <i class="bi bi-calendar-check"></i>
                                <?php echo get_the_date(); ?>
                            </span>
                        </div>
                        <h3 class="liberty-news-title">
                            <a href="<?= esc_url(get_permalink()); ?>"><?php the_title(); ?></a>
                        </h3>
                        <div class="liberty-news-excerpt">
                            <?php echo wp_trim_words(get_the_excerpt(), 10); ?>
                        </div>
                        <div class="liberty-news-footer">
                            <a href="<?= esc_url(get_permalink()); ?>" class="liberty-news-btn">
                                Read More <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </article>
                <?php $delay += 100; endwhile;
                    wp_reset_postdata();
                else :
                    echo '<p class="text-center py-5" data-aos="fade-up">No blogs found.</p>';
                endif;
                ?>
            </div>
        </div>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('all_news', 'allNews_shortcode');

function news_slider_shortcode() {
    ob_start();

    $news_args = array(
        'post_type' => array('post'),
        'posts_per_page' => 6,
        'category_name' => 'news, blog',
    );
    
    $news_query = new WP_Query($news_args); ?>
    
    <div class="liberty-slider-wrapper" data-aos="fade-up">
        <div class="liberty-slider-header" data-aos="fade-up" data-aos-delay="100">
            <h2 class="liberty-slider-title">Latest Blogs</h2>
            <p class="liberty-slider-subtitle">Discover our community impact through these inspiring updates</p>
        </div>
        
        <div class="liberty-slider-container" data-aos="fade-up" data-aos-delay="200">
            <div class="liberty-slider">
                <?php if ($news_query->have_posts()) : ?>
                    <?php while ($news_query->have_posts()) : $news_query->the_post(); ?>
                    <div class="liberty-slide">
                        <article class="liberty-slide-card">
                            <a href="<?= esc_url(get_permalink()); ?>" class="liberty-slide-link">
                                <div class="liberty-slide-image">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('medium_large', ['class' => 'liberty-slide-img']); 
                                    } else {
                                        echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="News thumbnail" class="liberty-slide-img"/>';
                                    } ?>
                                </div>
                                <div class="liberty-slide-content">
                                    <h3 class="liberty-slide-title"><?php the_title(); ?></h3>
                                    <div class="liberty-slide-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 18); ?></div>
                                    <span class="liberty-slide-btn">
                                        Read More
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M5 12h14M12 5l7 7-7 7"></path>
                                        </svg>
                                    </span>
                                </div>
                            </a>
                        </article>
                    </div>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                <?php else : ?>
                    <p class="liberty-slider-empty">No stories found. Check back soon for updates.</p>
                <?php endif; ?>
            </div>
            
            <button class="liberty-slider-prev" aria-label="Previous slide">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M15 18l-6-6 6-6"></path>
                </svg>
            </button>
            <button class="liberty-slider-next" aria-label="Next slide">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M9 18l6-6-6-6"></path>
                </svg>
            </button>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const slider = document.querySelector('.liberty-slider');
        const prevBtn = document.querySelector('.liberty-slider-prev');
        const nextBtn = document.querySelector('.liberty-slider-next');
        const slides = document.querySelectorAll('.liberty-slide');
        let currentIndex = 0;
        const slideWidth = slides[0]?.offsetWidth + 30;
        
        prevBtn.addEventListener('click', () => {
            currentIndex = Math.max(currentIndex - 1, 0);
            slider.scrollTo({
                left: currentIndex * slideWidth,
                behavior: 'smooth'
            });
        });
        
        nextBtn.addEventListener('click', () => {
            currentIndex = Math.min(currentIndex + 1, slides.length - 1);
            slider.scrollTo({
                left: currentIndex * slideWidth,
                behavior: 'smooth'
            });
        });
        
        let autoScrollInterval;
        let isHovered = false;
        
        function startAutoScroll() {
            autoScrollInterval = setInterval(() => {
                if (!isHovered) {
                    currentIndex = (currentIndex + 1) % slides.length;
                    slider.scrollTo({
                        left: currentIndex * slideWidth,
                        behavior: 'smooth'
                    });
                }
            }, 5000);
        }
        
        slider.addEventListener('mouseenter', () => isHovered = true);
        slider.addEventListener('mouseleave', () => isHovered = false);
        
        startAutoScroll();
        
        return () => clearInterval(autoScrollInterval);
    });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('news_slider', 'news_slider_shortcode');

function gallery_cards_shortcode($atts) {
    ob_start();
    
    $atts = shortcode_atts(array(
        'posts_per_page' => -1,
        'category' => 'photo-gallery'
    ), $atts);
    
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'category_name' => $atts['category'],
        'paged' => $paged
    );
    
    $gallery_query = new WP_Query($args);
    
    if ($gallery_query->have_posts()) : ?>
        <div class="liberty-gallery-wrapper" data-aos="fade-up">
            <div class="liberty-gallery-container">
                <div class="liberty-gallery-grid">
                    <?php $delay = 0; while ($gallery_query->have_posts()) : $gallery_query->the_post(); ?>
                        <div class="liberty-gallery-card" data-aos="fade-up" data-aos-delay="<?= $delay ?>">
                            <a href="<?php the_permalink(); ?>" class="liberty-gallery-link">
                                <div class="liberty-gallery-image">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <?php the_post_thumbnail('large', array('class' => 'liberty-gallery-img')); ?>
                                    <?php else : ?>
                                        <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg'); ?>" 
                                             alt="<?php esc_attr(the_title()); ?>" 
                                             class="liberty-gallery-img">
                                    <?php endif; ?>
                                    <div class="liberty-gallery-overlay">
                                        <h3 class="liberty-gallery-title"><?php the_title(); ?></h3>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php $delay += 100; endwhile; ?>
                </div>
                
                <div class="liberty-gallery-pagination" data-aos="fade-up" data-aos-delay="300">
                    <?php
                    echo paginate_links(array(
                        'total' => $gallery_query->max_num_pages,
                        'current' => $paged,
                        'prev_text' => __('<span class="pagination-arrow">&larr;</span> Previous'),
                        'next_text' => __('Next <span class="pagination-arrow">&rarr;</span>'),
                        'type' => 'list',
                        'mid_size' => 2
                    ));
                    ?>
                </div>
            </div>
        </div>
    <?php else : ?>
        <p class="liberty-no-galleries" data-aos="fade-up">No photo galleries found.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('gallery', 'gallery_cards_shortcode');

function enqueue_lightbox_assets() {
    wp_enqueue_style('fancybox-css', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css');
    wp_enqueue_script('fancybox-js', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js', array('jquery'), null, true);
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css');
    wp_enqueue_style('aos-css', 'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css');
    wp_enqueue_script('aos-js', 'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js', array(), null, true);
    
    wp_add_inline_script('aos-js', 'AOS.init({ duration: 800, easing: "ease-in-out", once: true, offset: 100 });');
    
    wp_add_inline_script('fancybox-js', '
        jQuery(document).ready(function($) {
            $("[data-fancybox]").fancybox({
                buttons: ["zoom", "slideShow", "thumbs", "close"],
                animationEffect: "fade",
                transitionEffect: "slide",
                loop: true,
                infobar: true,
                toolbar: true,
                protect: false,
                modal: false,
                touch: { vertical: true, momentum: true },
                thumbs: { autoStart: false, hideOnClose: true, parentEl: ".fancybox-container", axis: "y" },
                caption: function(instance, item) {
                    var caption = $(item.opts.$orig).data("caption");
                    return caption && caption.trim() ? 
                        "<div class=\"fancybox-caption-custom\">" + caption + "</div>" : "";
                },
                beforeShow: function(instance, current) {
                    if (!$("#fancybox-caption-styles").length) {
                        $("head").append(`
                            <style id="fancybox-caption-styles">
                                .fancybox-caption-custom { color: #fff !important; font-size: 16px; line-height: 1.4; padding: 12px 20px; background: rgba(0,0,0,0.8); border-radius: 6px; text-align: center; margin: 10px auto 0; max-width: 80%; backdrop-filter: blur(10px); }
                                .fancybox-caption { color: #fff !important; text-align: center !important; }
                                .fancybox-toolbar { background: rgba(0,0,0,0.5) !important; }
                                @media (max-width: 768px) { .fancybox-caption-custom { font-size: 14px; padding: 10px 15px; max-width: 90%; } }
                            </style>
                        `);
                    }
                }
            });
        });
    ');
}
add_action('wp_enqueue_scripts', 'enqueue_lightbox_assets');

add_action('wp_ajax_get_image_data', 'get_image_data_callback');
add_action('wp_ajax_nopriv_get_image_data', 'get_image_data_callback');

function get_image_data_callback() {
    $image_id = intval($_GET['id']);
    $image_url = wp_get_attachment_image_url($image_id, 'full');
    $image_caption = get_the_title($image_id);
    
    wp_send_json(array(
        'url' => $image_url,
        'caption' => $image_caption
    ));
}
?>