<footer class="ls-footer">
  <!-- SVG curved top (inverted from the slider) -->
  <svg class="footer-top-curve" viewBox="0 0 2100 150" preserveAspectRatio="none">
    <path d="M0,150 C700,-30 1400,-30 2100,150 L2100,0 L0,0 Z" fill="#ffffff"/>
  </svg>

  <div class="container py-5">
    <!-- Logo positioned at the curve bottom and centered -->
    <div class="footer-logo-curve-position" style="position:relative;z-index:2;margin-top:-75px;margin-bottom:30px;text-align:center;">
      <div class="footer-logo-wrapper" style="display:inline-block;padding:10px 20px;box-shadow:0 4px 12px rgba(0,0,0,0.1);">
        <?php if ( has_custom_logo() ) : ?>
          <?php
            // get HTML for the custom logo and add inline styles to the <img>
            $logo_html = get_custom_logo(); // returns <a><img class="custom-logo" ...></a>
            // ensure we don't duplicate style if already present
            if ( strpos( $logo_html, 'style="' ) === false ) {
              $logo_html = str_replace(
                '<img',
                '<img style="width:120px;height:auto;max-width:100%;display:block;margin:0 auto;object-fit:contain;"',
                $logo_html
              );
            } else {
              // fallback: force inline CSS via JS if img already has style attr
              echo $logo_html;
            }
            echo $logo_html;
          ?>
          <script>
            document.addEventListener('DOMContentLoaded', function(){
              var img = document.querySelector('.footer-logo-wrapper .custom-logo');
              if(img){
                // final enforcement in case theme overrides or image had its own attrs
                img.style.width = '200px';
                img.style.height = 'auto';
                img.style.maxWidth = '100%';
                img.style.display = 'block';
                img.style.margin = '0 auto';
                img.style.objectFit = 'contain';
              }
            });
          </script>
        <?php else : ?>
          <div class="ls-logo-icon" style="text-align:center;">
            <svg width="120" height="120" viewBox="0 0 60 60" class="ls-icon-combined"
                 style="width:120px;height:auto;max-width:100%;display:block;margin:0 auto;">
              <path d="M30 5L5 30l25 25 25-25z" fill="var(--ls-construction-orange)"/>
              <circle cx="30" cy="30" r="12" fill="var(--ls-water-blue)"/>
              <path d="M18 18h24v24H18z" fill="var(--ls-supply-green)"/>
            </svg>
            <span class="ls-logo-text" style="display:block;margin-top:8px;text-align:center;">Liberty Scope Ltd</span>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Main content row with better spacing -->
    <div class="row g-5 mt-4 justify-content-between">
      
      <!-- Company Info Section -->
      <div class="col-lg-4 col-md-6 text-center text-md-start">
        <p class="small mt-3">
          Delivering innovative and sustainable solutions in civil engineering, water works, and general supplies across Uganda.
        </p>
        <div class="ls-specializations mt-3">
          <span class="ls-specialization-badge bg-construction">Civil Works</span>
          <span class="ls-specialization-badge bg-water">Water Systems</span>
          <span class="ls-specialization-badge bg-supply">General Supplies</span>
        </div>
      </div>

      <!-- Services Section -->
      <div class="col-lg-3 col-md-6">
        <h5>Our Services</h5>
        <ul class="footer-links">
          <li><a href="https://lwegatech.net/liberty-scope/residential-and-commercial-building-construction/"><i class="bi bi-building fs-6 me-2 ls-civil"></i>Construction(Roads and Buildings)</a></li>
          <li><a href="https://lwegatech.net/liberty-scope/borehole-drilling-and-rehabilitation/"><i class="bi bi-droplet fs-6 me-2 ls-water"></i> Borehole Drilling</a></li>
          <li><a href="https://lwegatech.net/liberty-scope/solar-powered-irrigation-systems/"><i class="bi bi-lightning-charge fs-6 me-2 ls-water"></i> Solar Irrigation</a></li>
          <li><a href="https://lwegatech.net/liberty-scope/construction-materials-and-equipment/"><i class="bi bi-truck fs-6 me-2 ls-supply"></i> Construction Supplies</a></li>
          <li><a href="https://lwegatech.net/liberty-scope/solar-and-electrical-equipment/"><i class="bi bi-sun fs-6 me-2 ls-supply"></i> Solar Equipment</a></li>
        </ul>
      </div>

      <!-- Contact Information -->
      <div class="col-lg-4 col-md-6">
        <h5>Contact Us</h5>
        <ul class="footer-contact">
          <li><i class="bi bi-geo-alt-fill me-2"></i> Plot 32, Lumumba Avenue, Padre Pio House, Floor 5, Kampala-Uganda</li>
          <li><i class="bi bi-envelope-fill me-2"></i> info@libertyscope.co.ug</li>
          <li><i class="bi bi-telephone-fill me-2"></i> +256 777461759</li>
          <li><i class="bi bi-telephone-fill me-2"></i> +256 706960708</li>
        </ul>
      </div>

    </div>

    <!-- Social section as a separate centered row -->
    <div class="row mt-5">
      <div class="col-12 text-center">
        <p class="small">Follow our projects and updates on social media.</p>
        
        <div class="social-links justify-content-center mt-4">
          <a href="https://x.com/Liberty_Scope?s=09" class="social-link twitter"><i class="bi bi-twitter"></i></a>
          <a href="http://www.linkedin.com/in/liberty-scope-2421b3387" class="social-link linkedin"><i class="bi bi-linkedin"></i></a>
          <a href="#" class="social-link youtube"><i class="bi bi-youtube"></i></a>
        </div>
      </div>
    </div>

  </div>

  <!-- Bottom Bar -->
  <div class="footer-bottom">
    <div class="container">
      <div class="d-flex flex-column flex-md-row justify-content-between align-items-center">
        <p class="mb-0 small">&copy; <?php echo date("Y"); ?> Liberty Scope Ltd. All Rights Reserved.</p>
        <div class="mt-2 mt-md-0">
          <a href="#" class="small me-3">Privacy Policy</a>
          <a href="#" class="small me-3">Terms of Service</a>
          <span class="small">Designed by <a href="https://www.lwegatech.com/" target="_blank">Lwegatech</a></span>
        </div>
      </div>
    </div>
  </div>
  
  <script>
document.addEventListener('DOMContentLoaded', function() {
    const btnOpenOffcanvasList = document.querySelectorAll('.btn-open-offcanvas');

    btnOpenOffcanvasList.forEach(btn => {
        btn.addEventListener('click', function() {
            const postId = this.getAttribute('data-post-id');
            const offcanvasContent = document.getElementById('offcanvas-content');

            // Use AJAX to fetch post content
            const xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    offcanvasContent.innerHTML = xhr.responseText;
                }
            };
            xhr.open('GET', '<?php echo admin_url('admin-ajax.php'); ?>?action=get_post_content&post_id=' + postId, true);
            xhr.send();
        });
    });
});
</script>
<script>
        jQuery(document).ready(function($) {
            $('#downloads-table').DataTable({
                // DataTables options here
                "paging": true,
                "searching": true,
                // Add more options as needed
            });
        });
    </script>
<script>
    (function (w, d, s, u) {
    w.gbwawc = {
    url: u,
    options: {
            waId: "+256777461759",
            siteName: "Liberty Scope Ltd",
            siteTag: "",
            siteLogo: "https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/Liberty-scope-LOGO-SMALL.gif",
            widgetPosition: "RIGHT",
            triggerMessage: "Chat With Us!",
            welcomeMessage: "How can we help you?",
            brandColor: "#25D366",
            messageText: "",
            replyOptions: ['',''],
        },
    };
    var h = d.getElementsByTagName(s)[0],
    j = d.createElement(s);
    j.async = true;
    j.src = u + "/whatsapp-widget.min.js?_=" + Math.random();
    h.parentNode.insertBefore(j, h);
    })(window, document, "script", "https://waw.gallabox.com");
    </script>

</footer>