<?php
// Set up SEO meta tags
$page_title = "JamboApp - Coming Soon | Revolutionizing Digital Experiences";
$page_description = "JamboApp is launching soon - a revolutionary platform that will transform how you connect, work, and create. Join our waitlist for exclusive early access.";
$page_keywords = "JamboApp, coming soon, app launch, digital platform, innovation, Tanzania tech";
$page_author = "JamboApp Team";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- SEO Meta Tags -->
    <title><?php echo $page_title; ?></title>
    <meta name="description" content="<?php echo $page_description; ?>">
    <meta name="keywords" content="<?php echo $page_keywords; ?>">
    <meta name="author" content="<?php echo $page_author; ?>">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo $page_title; ?>">
    <meta property="og:description" content="<?php echo $page_description; ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="https://jamboapp.io">
    <meta property="og:image" content="https://jamboapp.io/images/og-image.jpg">
    
    <!-- Favicon -->
   <link rel="icon" type="image/jpeg" href="jambo-logo.jpg">
    
<style>
    :root { --kpy-primary: #0a3161; --kpy-primary-light: #1a4a8a; --kpy-primary-dark: #051d3d; --kpy-accent: #ffa500; --kpy-accent-light: #ffb833; --kpy-accent-dark: #cc8400; --kpy-success: #22c55e; --kpy-error: #ef4444; --kpy-warning: #f59e0b; --kpy-info: #3b82f6; --kpy-muted: #64748b; --kpy-bg-light: #f8fafc; --kpy-border: #e5e7eb; --kpy-surface: #ffffff; --kpy-shadow: rgba(0,0,0,0.1); --kpy-white:#ffffff; --kpy-gradient: linear-gradient(135deg, var(--kpy-primary) 0%, var(--kpy-primary-light) 100%); }

* { margin: 0; padding: 0; box-sizing: border-box; }

html { scroll-behavior: smooth; }

body { font-family: 'Montserrat' , sans-serif; line-height: 1.6; color: #333; background-color: var(--kpy-bg-light); overflow-x: hidden; }

.container { max-width: 1100px; margin: 0 auto; padding: 0 20px; }

.hero { background: var(--kpy-gradient); color: var(--kpy-white); min-height: 100vh; display: flex; align-items: center; position: relative; overflow: hidden; }

.hero::after { content: ''; position: absolute; bottom: 0; left: 0; width: 100%; height: 100px; background: url("data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1440 100'><path fill='%23ffffff' d='M0,0 C200,100 600,0 1000,100 1440,0 1440,100 1440,100 L1440,100 L0,100 Z'></path></svg>") no-repeat bottom center; background-size: cover; }

.hero-content { display: grid; grid-template-columns: 1.2fr 0.8fr; gap: 80px; align-items: center; position: relative; z-index: 2; }

.hero-text { padding-right: 20px; }

.logo { display: flex; align-items: center; margin-bottom: 40px; }

.logo-icon { width: 90px; height: 90px; margin-right: 20px; border-radius: 22px; display: flex; align-items: center; justify-content: center; overflow: hidden; }

.logo-icon img { width: 100%; height: 100%; object-fit: cover; }

.logo-text { font-size: 48px; font-weight: 800; letter-spacing: -0.5px; }

.hero-text h1 { font-size: 38px; margin-bottom: 25px; line-height: 1.1; font-weight: 800; letter-spacing: -1px; }

.hero-text p { font-size: 17px; margin-bottom: 40px; color: rgba(255, 255, 255, 0.85); max-width: 90%; }

.cta-section { display: flex; gap: 15px; flex-wrap: wrap; }

.cta-button { display: inline-flex; align-items: center; background-color: var(--kpy-accent); color: var(--kpy-primary); padding: 16px 32px; border-radius: 50px; text-decoration: none; font-weight: 600; transition: all 0.3s ease; box-shadow: 0 5px 15px rgba(255, 165, 0, 0.3); }

.cta-button:hover { transform: translateY(-3px); box-shadow: 0 10px 25px rgba(255, 165, 0, 0.4); background-color: var(--kpy-accent-light); }

.hero-image { display: flex; justify-content: center; align-items: center; position: relative; }

.hero-image::before { content: ''; position: absolute; width: 500px; height: 500px; background: radial-gradient(circle, var(--kpy-accent) 0%, transparent 70%); opacity: 0.2; border-radius: 50%; filter: blur(40px); z-index: -1; animation: glow 4s ease-in-out infinite alternate; }

@keyframes glow { 0% { transform: scale(1); opacity: 0.2; } 100% { transform: scale(1.1); opacity: 0.3; } }

.image-container { width: 100%; max-width: 600px; border-radius: 0; overflow: visible; animation: float-image 6s ease-in-out infinite; position: relative; }

@keyframes float-image { 0%, 100% { transform: translateY(0) rotate(0deg); } 50% { transform: translateY(-20px) rotate(2deg); } }

.app-screenshot { width: 100%; height: auto; display: block; transition: transform 0.5s ease; border-radius: 0; }

.image-container:hover .app-screenshot { transform: scale(1.03); }

.contact { padding: 60px 0; background-color: var(--kpy-white); position: relative; }

.contact::before { content: ''; position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: radial-gradient(circle at 10% 20%, rgba(10, 49, 97, 0.03) 0%, transparent 50%), radial-gradient(circle at 90% 80%, rgba(255, 165, 0, 0.03) 0%, transparent 50%); z-index: 0; }

.section-title { text-align: center; margin-bottom: 70px; position: relative; z-index: 1; }

.section-title h2 { font-size: 42px; color: var(--kpy-primary); margin-bottom: 15px; font-weight: 800; letter-spacing: -1px; }

.section-title p { color: var(--kpy-muted); max-width: 600px; margin: 0 auto; font-size: 18px; }

.contact-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 30px; position: relative; z-index: 1; }

.contact-card { background-color: var(--kpy-white); padding: 40px 30px; border-radius: 16px; text-align: center; transition: all 0.3s ease; box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05); border: 1px solid var(--kpy-border); position: relative; overflow: hidden; }

.contact-card::before { content: ''; position: absolute; top: 0; left: 0; width: 100%; height: 5px; background: var(--kpy-gradient); }

.contact-card:hover { transform: translateY(-10px); box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1); }

.contact-icon { background: var(--kpy-gradient); color: var(--kpy-white); width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 25px; font-size: 30px; }

.contact-card h3 { margin-bottom: 15px; color: var(--kpy-primary); font-size: 22px; font-weight: 700; }

.contact-card p { color: var(--kpy-muted); margin-bottom: 5px; }

.contact-card a { color: var(--kpy-primary); text-decoration: none; transition: color 0.3s; font-weight: 500; }

.contact-card a:hover { color: var(--kpy-accent); }

footer { background-color: var(--kpy-primary); color: var(--kpy-white); padding: 30px 0; text-align: center; }

.footer-content { display: flex; justify-content: space-between; align-items: center; }

.copyright { font-size: 14px; opacity: 0.8; }

.footer-logo { display: flex; align-items: center; font-size: 16px; font-weight: 500; }

.footer-tagline { font-size: 14px; opacity: 0.7; margin-top: 5px; }

@media (max-width: 1100px) { .hero-content { gap: 50px; } .hero-text h1 { font-size: 46px; } }

@media (max-width: 992px) { .hero-content { grid-template-columns: 1fr; gap: 50px; text-align: center; } .hero-text { padding-right: 0; } .hero-text p { max-width: 100%; } .cta-section { justify-content: center; } }

@media (max-width: 768px) { .hero-text h1 { font-size: 38px; } .logo-text { font-size: 36px; } .section-title h2 { font-size: 34px; } .footer-content { flex-direction: column; gap: 15px; } .logo-icon { width: 70px; height: 70px; } }

@media (max-width: 576px) { .hero-text h1 { font-size: 32px; } .logo { flex-direction: column; text-align: center; gap: 15px; } .logo-icon { margin-right: 0; } .cta-section { flex-direction: column; align-items: center; } .cta-button { width: 100%; justify-content: center; } .image-container { max-width: 400px; } }
</style>
</head>
<body>
    
    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <div class="hero-text">
                    <div class="logo">
                        <div class="logo-icon">
                            <img src="jambo-logo.jpg" alt="JamboApp Logo" />
                        </div>
                        <div class="logo-text">JamboApp</div>
                    </div>
                    <h1>Revolutionizing Digital Experiences in Tanzania</h1>
                    <p>We're building something extraordinary that will transform how you connect, work, and create. Join our exclusive waitlist to be the first to experience the future.</p>
                    
                    <div class="cta-section">
                        <a href="#contact" class="cta-button">Join Waitlist for Early Access</a>
                    </div>
                </div>
                
                <div class="hero-image">
                    <div class="image-container">
                        <img src="burger.png" alt="JamboApp Preview" class="app-screenshot">
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Contact Section -->
    <section class="contact" id="contact">
        <div class="container">
            <div class="section-title">
                <h2>Get In Touch With Us</h2>
                <p>Have questions or want to partner with us? We'd love to hear from you.</p>
            </div>
            
            <div class="contact-grid">
                <div class="contact-card">
                    <div class="contact-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                    </div>
                    <h3>Email Us</h3>
                    <p><a href="mailto:info@jamboapp.io">info@jamboapp.io</a></p>
                </div>
                
                <div class="contact-card">
                    <div class="contact-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M15.05 5A5 5 0 0 1 19 8.95M15.05 1A9 9 0 0 1 23 8.94m-1 7.98v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                        </svg>
                    </div>
                    <h3>Call Us</h3>
                    <p><a href="tel:+255692133866">+255 69 213 3866</a></p>
                </div>
                
                <div class="contact-card">
                    <div class="contact-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z"></path>
                            <circle cx="12" cy="10" r="3"></circle>
                        </svg>
                    </div>
                    <h3>Visit Us</h3>
                    <p>Kibada-Kigamboni</p>
                    <p>Dar es Salaam, Tanzania</p>
                </div>
                
            </div>
        </div>
    </section>
    
    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="footer-content">
                <div class="footer-logo">
                    JamboApp Building Tanzania's Digital Future
                </div>
                <div class="copyright">
                    <p>&copy; <?php echo date("Y"); ?> JamboApp. All rights reserved. Proudly made for Tanzania.</p>
                </div>
            </div>
        </div>
    </footer>
    
    <script>
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                
                const targetId = this.getAttribute('href');
                if (targetId === '#') return;
                
                const targetElement = document.querySelector(targetId);
                if (targetElement) {
                    window.scrollTo({
                        top: targetElement.offsetTop - 80,
                        behavior: 'smooth'
                    });
                }
            });
        });
        
        // Add scroll animation for contact cards
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);
        
        // Observe contact cards
        document.querySelectorAll('.contact-card').forEach(card => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            observer.observe(card);
        });
    </script>
</body>
</html>