<?php
/**
 * Template Name: Single Travel Package
 * Description: Display single travel package details
 */
get_header();

while (have_posts()) : the_post();
    $price_usd = get_post_meta(get_the_ID(), '_price_usd', true);
    $price_ugx = get_post_meta(get_the_ID(), '_price_ugx', true);
    $destination = get_post_meta(get_the_ID(), '_destination', true);
    $reviews = get_post_meta(get_the_ID(), '_reviews', true);
    $adults = get_post_meta(get_the_ID(), '_adults', true);
    $children = get_post_meta(get_the_ID(), '_children', true);
    $brief_description = get_post_meta(get_the_ID(), '_brief_description', true);
    $package_overview = get_post_meta(get_the_ID(), '_package_overview', true);
    $trip_duration = get_post_meta(get_the_ID(), '_trip_duration', true);
    $trip_difficulty = get_post_meta(get_the_ID(), '_trip_difficulty', true);
    $group_size = get_post_meta(get_the_ID(), '_group_size', true);
    $best_season = get_post_meta(get_the_ID(), '_best_season', true);
    $accommodation = get_post_meta(get_the_ID(), '_accommodation', true);
    $itinerary_days = get_post_meta(get_the_ID(), '_itinerary_days', true);
    $price_includes = get_post_meta(get_the_ID(), '_price_includes', true);
    $price_excludes = get_post_meta(get_the_ID(), '_price_excludes', true);
    $gallery_images = get_post_meta(get_the_ID(), '_gallery_images', true);
?>

<div class="single-travel-package">
    <div class="container">
        <!-- Hero Section -->
        <div class="package-hero">
            <?php if (has_post_thumbnail()) : ?>
                <div class="hero-image">
                    <?php the_post_thumbnail('full', array('class' => 'img-fluid')); ?>
                </div>
            <?php endif; ?>
            
            <div class="hero-content">
                <h1><?php the_title(); ?></h1>
                <?php if ($brief_description) : ?>
                    <p class="hero-description"><?php echo esc_html($brief_description); ?></p>
                <?php endif; ?>
                
                <div class="hero-meta">
                    <?php if ($destination) : ?>
                        <span class="destination"><i class="fas fa-map-marker-alt"></i> <?php echo esc_html($destination); ?></span>
                    <?php endif; ?>
                    
                    <?php if ($trip_duration) : ?>
                        <span class="duration"><i class="fas fa-clock"></i> <?php echo esc_html($trip_duration); ?></span>
                    <?php endif; ?>
                    
                    <?php if ($price_usd) : ?>
                        <span class="price"><?php echo esc_html($price_usd); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Package Details -->
        <div class="package-details">
            <div class="row">
                <div class="col-md-8">
                    <!-- Overview -->
                    <?php if ($package_overview) : ?>
                        <section class="package-section overview-section">
                            <h2>Package Overview</h2>
                            <div class="overview-content">
                                <?php echo wp_kses_post($package_overview); ?>
                            </div>
                        </section>
                    <?php endif; ?>
                    
                    <!-- Itinerary -->
                    <?php if (!empty($itinerary_days) && is_array($itinerary_days)) : ?>
                        <section class="package-section itinerary-section">
                            <h2>Itinerary</h2>
                            <div class="itinerary-days">
                                <?php foreach ($itinerary_days as $index => $day) : ?>
                                    <div class="itinerary-day">
                                        <h3>Day <?php echo $index + 1; ?>: <?php echo esc_html($day['day_title']); ?></h3>
                                        <div class="day-description">
                                            <?php echo wp_kses_post($day['day_description']); ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </section>
                    <?php endif; ?>
                    
                    <!-- Includes/Excludes -->
                    <div class="row">
                        <?php if (!empty($price_includes) && is_array($price_includes)) : ?>
                            <div class="col-md-6">
                                <section class='package-section includes-section'>
                                    <h2>Price Includes</h2>
                                    <ul>
                                        <?php foreach ($price_includes as $include) : ?>
                                            <li><?php echo esc_html($include); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </section>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($price_excludes) && is_array($price_excludes)) : ?>
                            <div class="col-md-6">
                                <section class='package-section excludes-section'>
                                    <h2>Price Excludes</h2>
                                    <ul>
                                        <?php foreach ($price_excludes as $exclude) : ?>
                                            <li><?php echo esc_html($exclude); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </section>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <!-- Booking Sidebar -->
                    <div class="booking-sidebar">
                        <div class="booking-card">
                            <h3>Book This Package</h3>
                            
                            <div class="price-info">
                                <?php if ($price_usd) : ?>
                                    <div class="price"><?php echo esc_html($price_usd); ?></div>
                                <?php endif; ?>
                                
                                <?php if ($price_ugx) : ?>
                                    <div class="local-price"><?php echo esc_html($price_ugx); ?></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="package-info">
                                <?php if ($trip_duration) : ?>
                                    <div class="info-item">
                                        <i class="fas fa-clock"></i>
                                        <span><?php echo esc_html($trip_duration); ?></span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($adults) : ?>
                                    <div class="info-item">
                                        <i class="fas fa-user"></i>
                                        <span><?php echo esc_html($adults); ?> Adults</span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($children) : ?>
                                    <div class="info-item">
                                        <i class="fas fa-child"></i>
                                        <span><?php echo esc_html($children); ?> Children</span>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($trip_difficulty) : ?>
                                    <div class="info-item">
                                        <i class="fas fa-tachometer-alt"></i>
                                        <span>Difficulty: <?php echo esc_html($trip_difficulty); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <a href="#inquiry-form" class="btn btn-primary btn-book-now">Book Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Gallery -->
        <?php if (!empty($gallery_images) && is_array($gallery_images)) : ?>
            <section class="package-section gallery-section">
                <h2>Gallery</h2>
                <div class="package-gallery">
                    <?php foreach ($gallery_images as $image_id) : ?>
                        <?php if ($image_url = wp_get_attachment_image_url($image_id, 'medium')) : ?>
                            <a href="<?php echo wp_get_attachment_image_url($image_id, 'full'); ?>" class="gallery-item" data-fancybox="gallery">
                                <img src="<?php echo esc_url($image_url); ?>" alt="Gallery Image">
                            </a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </section>
        <?php endif; ?>
        
        <!-- Inquiry Form -->
        <section id="inquiry-form" class="package-section inquiry-section">
            <h2>Inquire About This Package</h2>
            <?php 
            // Try to find a contact form
            $contact_form = do_shortcode('[contact-form-7 id="123" title="Package Inquiry"]');
            if (strpos($contact_form, 'Not found') !== false || empty($contact_form)) {
                echo '<p>Please create a contact form and update the shortcode in the template.</p>';
            } else {
                echo $contact_form;
            }
            ?>
        </section>
    </div>
</div>

<?php endwhile;
get_footer(); ?>