<?php
/**
 * Template Name: Enhanced Package Detail Template
 * Template Post Type: romantic_package, travel_package
 */
get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 

// Check if we're on a single package page
while (have_posts()) : the_post();
    $post_id = get_the_ID();
    $post_type = get_post_type();

    // Get all meta values from metaboxes
        $trip_duration = get_post_meta($post_id, '_trip_duration', true);
        $best_season = get_post_meta($post_id, '_best_season', true);
        $trip_price = get_post_meta($post_id, '_price_usd', true);
        $accommodation = get_post_meta($post_id, '_accommodation', true);
        $brief_description = get_post_meta($post_id, '_brief_description', true);
        $package_overview = get_post_meta($post_id, '_package_overview', true);
        $itinerary_days = get_post_meta($post_id, '_itinerary_days', true);
        $price_includes = get_post_meta($post_id, '_price_includes', true);
        $price_excludes = get_post_meta($post_id, '_price_excludes', true);
        $gallery_images = get_post_meta($post_id, '_gallery_images', true);
        
        // Get additional fields
        $destination = get_post_meta($post_id, '_destination', true);
        $reviews = get_post_meta($post_id, '_reviews', true);
        $price_ugx = get_post_meta($post_id, '_price_ugx', true);
        
        // NEW FIELDS for enhanced functionality
        $budget_tier = get_post_meta($post_id, '_budget_tier', true); // BUDGET, STANDARD, PREMIUM, LUXURY
        $starting_price = get_post_meta($post_id, '_starting_price', true);
        $duration_nights = get_post_meta($post_id, '_duration_nights', true);
        $default_adults = get_post_meta($post_id, '_default_adults', true) ?: '2';
        $default_children = get_post_meta($post_id, '_default_children', true) ?: '0';
        
        // For romantic packages specific logic
        if ($post_type === 'romantic_package') {
            // Add any romantic-specific fields here
        }
    
    // Customize content based on post type
    $page_title = ($post_type === 'romantic_package') ? 'About This Romantic Package' : 'About This Travel Package';
    $overview_title = ($post_type === 'romantic_package') ? 'ROMANTIC PACKAGE OVERVIEW' : 'TRAVEL PACKAGE OVERVIEW';
    
    // Ensure arrays are properly formatted
    if (empty($itinerary_days)) $itinerary_days = array();
    if (empty($price_includes)) $price_includes = array();
    if (empty($price_excludes)) $price_excludes = array();
    
    // Handle gallery images
    if (!empty($gallery_images) && !is_array($gallery_images)) {
        $gallery_images = explode(',', $gallery_images);
    }
    
    // Get featured image for hero
    $featured_image = get_the_post_thumbnail_url($post_id, 'full');
?>

<style>
/* Parallax Hero Section */
.parallax-hero { position: relative; height: 350px; overflow: hidden; display: flex; align-items: center; justify-content: center; }
.parallax-bg { position: absolute; top: -20%; left: 0; width: 100%; height: 120%; background-attachment: fixed; background-position: center center; background-repeat: no-repeat; background-size: cover; will-change: transform; z-index: 1; animation: zoomIn 20s ease-out infinite alternate; }

@keyframes zoomIn {
    0% { transform: scale(1); }
    100% { transform: scale(1.1); }
}

.hero-overlay { position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: linear-gradient(135deg, rgba(0,0,0,0.4) 0%, rgba(0,0,0,0.2) 100%); z-index: 2; }
.hero-content { position: relative; z-index: 3; text-align: center; color: white; padding: 2rem; max-width: 800px; margin: 0 auto; }
.hero-title { font-size: 3rem; font-weight: 700; margin-bottom: 1rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.5); line-height: 1.2; animation-duration: 1.5s; }
.hero-excerpt { font-size: 1.1rem; line-height: 1.6; margin-bottom: 1.5rem; text-shadow: 1px 1px 2px rgba(0,0,0,0.5); opacity: 0; animation-duration: 1.3s; }
.hero-line { position: absolute; bottom: 0; left: 0; width: 100%; height: 1px; background-color: white; z-index: 4; }

.trip-meta { display: flex; gap: 2rem; justify-content: center; flex-wrap: wrap; }
.trip-meta span { background: rgba(0,0,0,0.5); padding: 0.5rem 1rem; border-radius: 20px; font-size: 0.9rem; text-shadow: 1px 1px 2px rgba(0,0,0,0.7); }

/* Post type specific styling for parallax hero */
.romantic_package .hero-overlay { background: linear-gradient(135deg, rgba(255,20,147,0.3) 0%, rgba(0,0,0,0.4) 100%); }
.travel_package .hero-overlay { background: linear-gradient(135deg, rgba(0,0,0,0.4) 0%, rgba(0,0,0,0.2) 100%); }

/* Enhanced Package Info Box */
.package-info-box { background: white; padding: 2rem; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); margin: 2rem auto; max-width: 800px; }
.package-overview-short { margin-bottom: 1.5rem; color: #555; line-height: 1.6; }
.package-highlights { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; margin-bottom: 2rem; }
.highlight-item { text-align: center; padding: 1rem; background: #f8f9fa; border-radius: 10px; }
.highlight-item h4 { color: #2c3e50; margin-bottom: 0.5rem; font-size: 0.9rem; text-transform: uppercase; }
.highlight-value { font-size: 1.2rem; font-weight: bold; color: #e67e22; }
.view-details-btn { background: linear-gradient(135deg, #e67e22 0%, #d35400 100%); color: white; padding: 1rem 3rem; border: none; border-radius: 30px; font-size: 1.1rem; font-weight: bold; cursor: pointer; width: 100%; transition: all 0.3s ease; }
.view-details-btn:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(230, 126, 34, 0.4); }

/* Budget Cards Section */
.budget-cards-section { max-width: 1200px; margin: 3rem auto; padding: 0 2rem; }
.budget-cards-section h2 { text-align: center; color: #2c3e50; margin-bottom: 2rem; font-size: 2rem; }
.budget-cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin-bottom: 3rem; }
.budget-card { background: white; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1); text-align: center; transition: all 0.3s ease; border: 3px solid transparent; }
.budget-card:hover { transform: translateY(-5px); box-shadow: 0 10px 30px rgba(0,0,0,0.15); }
.budget-card.active { border-color: #e67e22; }
.budget-card h3 { color: #2c3e50; margin-bottom: 1rem; font-size: 1.3rem; }
.budget-price { font-size: 2rem; font-weight: bold; color: #e67e22; margin-bottom: 1rem; }
.budget-features { list-style: none; text-align: left; }
.budget-features li { margin-bottom: 0.5rem; padding-left: 1.5rem; position: relative; }
.budget-features li::before { content: "✓"; position: absolute; left: 0; color: #27ae60; font-weight: bold; }

/* Main Content */
.destination-container { max-width: 1200px; margin: 0 auto; padding: 2rem; display: grid; grid-template-columns: 2fr 1fr; gap: 3rem; }
.destination-content { background: white; }
.overview-section, .itinerary-section { margin-bottom: 2rem; }
.overview-section h2, .itinerary-section h2 { color: #2c3e50; margin-bottom: 1rem; font-size: 1.8rem; }
.overview-content { margin-bottom: 1.5rem; color: #555; line-height: 1.7; }
.overview-content p { margin-bottom: 1rem; }

/* Enhanced Itinerary with Images */
.itinerary-day { margin-bottom: 1rem; border: 1px solid #e0e0e0; border-radius: 10px; overflow: hidden; transition: all 0.3s ease; }
.itinerary-day:hover { box-shadow: 0 5px 15px rgba(0,0,0,0.1); }
.day-header { padding: 1.5rem; background: #f8f9fa; cursor: pointer; display: flex; align-items: center; gap: 1rem; }
.day-image-thumb { width: 60px; height: 60px; border-radius: 8px; object-fit: cover; }
.day-title { flex: 1; font-weight: bold; color: #2c3e50; font-size: 1.1rem; }
.toggle-icon { transition: transform 0.3s; color: #e67e22; font-size: 1.2rem; }
.romantic_package .toggle-icon { color: #e91e63; }
.toggle-icon.rotated { transform: rotate(180deg); }
.day-content { display: none; padding: 1.5rem; border-top: 1px solid #e0e0e0; }
.day-content.active { display: block; }
.day-images { display: flex; gap: 1rem; margin-bottom: 1rem; overflow-x: auto; padding-bottom: 0.5rem; }
.day-image { width: 150px; height: 100px; object-fit: cover; border-radius: 8px; cursor: pointer; transition: transform 0.3s; }
.day-image:hover { transform: scale(1.05); }

/* Sidebar - Non-sticky */
.destination-sidebar { display: flex; flex-direction: column; gap: 2rem; }
.booking-widget { color: #fff; padding: 2rem; border-radius: 10px; height: fit-content; background: linear-gradient(135deg,#c94b4b 0%,#4b134f 100%); }
.booking-widget h3 { color: #f39c12; margin-bottom: 1.5rem; font-size: 1.3rem; text-align: center; }
.romantic_package .booking-widget h3 { color: #ffb3d9; }
.booking-widget ul { list-style: none; margin-bottom: 2rem; }
.booking-widget li { display: flex; justify-content: space-between; margin-bottom: 1rem; padding-bottom: 0.5rem; border-bottom: 1px solid rgba(255,255,255,0.2); }
.booking-widget .info-label { font-weight: bold; }

/* Booking Form Container - New styling */
.booking-form-container { 
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); 
    padding: 3rem 2rem; 
    margin: 3rem auto; 
    border-radius: 20px; 
    box-shadow: 0 15px 40px rgba(0,0,0,0.1); 
    max-width: 1200px;border: 1px solid rgba(230, 126, 34, 0.2);}
.booking-form-container::before {content: '';position: absolute;top: 0;left: 0;right: 0;height: 4px;background: linear-gradient(135deg, #e67e22 0%, #d35400 100%);border-radius: 20px 20px 0 0;}
.booking-form-container { position: relative; }

/* Booking Form */
.booking-form { background: white; padding: 2rem; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); }
.booking-form h3 { color: #2c3e50; margin-bottom: 2rem; text-align: center; font-size: 1.8rem; }
.form-row { display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem; }
.form-group { margin-bottom: 1rem; }
.form-group label { display: block; margin-bottom: 0.5rem; color: #2c3e50; font-weight: bold; }
.form-group input, .form-group select, .form-group textarea { width: 100%; padding: 0.8rem; border: 1px solid #ddd; border-radius: 5px; font-size: 1rem; }
.form-group input:focus, .form-group select:focus, .form-group textarea:focus { outline: none; border-color: #e67e22; }
.submit-booking { background: linear-gradient(135deg, #27ae60 0%, #2ecc71 100%); color: white; padding: 1rem 2rem; border: none; border-radius: 25px; font-size: 1.1rem; font-weight: bold; cursor: pointer; width: 100%; transition: all 0.3s ease; }
.submit-booking:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(39, 174, 96, 0.4); }

/* Updated Book Now Button */
.book-now-btn { 
    background: linear-gradient(135deg, #ffa500 0%, #ff8c00 100%); 
    color: white; 
    padding: 1rem 2rem; 
    border: none; 
    border-radius: 25px; 
    font-weight: bold; 
    cursor: pointer; 
    width: 100%; 
    font-size: 1rem; 
    transition: all 0.3s ease; 
}

.book-now-btn:hover { 
    transform: translateY(-2px); 
    box-shadow: 0 5px 15px rgba(255, 165, 0, 0.4); 
    background: linear-gradient(135deg, #ff8c00 0%, #ffa500 100%);
}

/* Includes/Excludes Section */
.includes-excludes { display: grid; grid-template-columns: 1fr 1fr; gap: 2rem; margin-top: 2rem; }
.includes, .excludes { background: #f8f9fa; padding: 1.5rem; border-radius: 8px; }
.includes h4, .excludes h4 { color: #2c3e50; margin-bottom: 1rem; font-size: 1.2rem; display: flex; align-items: center; gap: 10px; }
.includes h4 { color: #27ae60; }
.excludes h4 { color: #e74c3c; }
.includes ul, .excludes ul { list-style: none; }
.includes li, .excludes li { margin-bottom: 0.5rem; padding-left: 1.5rem; position: relative; line-height: 1.4; }
.includes li::before { content: "✓"; position: absolute; left: 0; color: #27ae60; font-weight: bold; }
.excludes li::before { content: "✗"; position: absolute; left: 0; color: #e74c3c; font-weight: bold; }

/* Gallery */
.destination-gallery { max-width: 1200px; margin: 3rem auto 0; padding: 0 2rem; }
.destination-gallery h2 { color: #2c3e50; margin-bottom: 2rem; font-size: 2rem; text-align: center; }
.gallery-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; }
.gallery-image { width: 100%; height: 200px; object-fit: cover; border-radius: 8px; transition: transform 0.3s; cursor: pointer; }
.gallery-image:hover { transform: scale(1.05); }

/* Lightbox */
.lightbox { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.9); display: none; align-items: center; justify-content: center; z-index: 9999; cursor: pointer; }
.lightbox.active { display: flex; }
.lightbox img, .lightbox video { max-width: 90%; max-height: 90%; object-fit: contain; }
.lightbox-close { position: absolute; top: 20px; right: 20px; color: white; font-size: 2rem; cursor: pointer; }

/* Lightbox Carousel */
.lightbox-carousel {position: relative;max-width: 90vw;max-height: 90vh;}
.carousel-item {display: none;text-align: center;}
.carousel-item.active {display: block;}
.carousel-item img { max-width: 100%;max-height: 80vh;object-fit: contain;}
.carousel-control {position: absolute;top: 50%;transform: translateY(-50%);background: rgba(0,0,0,0.5);color: white;border: none;padding: 15px;cursor: pointer;font-size: 24px;z-index: 10;}
.carousel-control.prev {left: 10px;}
.carousel-control.next { right: 10px;}
.carousel-indicators {position: absolute;bottom: 15px;left: 0;right: 0;display: flex;justify-content: center;gap: 8px;}
.carousel-indicators .indicator {width: 12px;height: 12px;border-radius: 50%;background: rgba(255,255,255,0.5);cursor: pointer;}
.carousel-indicators .indicator.active {background: white;}

/* Responsive adjustments */
@media (max-width: 768px) {
    .parallax-hero { height: 400px; }
    .hero-title { font-size: 2.2rem; }
    .hero-excerpt { font-size: 1rem; }
    .parallax-bg { background-attachment: scroll; }
    .trip-meta { flex-direction: column; gap: 0.5rem; align-items: center; }
    .destination-container { grid-template-columns: 1fr; padding: 1rem; gap: 2rem; }
    .includes-excludes { grid-template-columns: 1fr; }
    .form-row { grid-template-columns: 1fr; }
    .budget-cards { grid-template-columns: 1fr; }
    .package-highlights { grid-template-columns: 1fr; }
    .day-images { flex-direction: column; }
    .day-image { width: 100%; height: 200px; }
    .booking-form-container { padding: 2rem 1rem; margin: 2rem 1rem; }
}

@media (max-width: 480px) {
    .parallax-hero { height: 350px; }
    .hero-title { font-size: 1.8rem; }
    .hero-excerpt { font-size: 0.9rem; }
}

/* Animation styles */
.fade-up { opacity: 0; transform: translateY(50px); animation: fadeUp 1.2s ease-out forwards; }
.fade-up.delay-1 { animation-delay: 0.3s; }
.fade-up.delay-2 { animation-delay: 0.6s; }

@keyframes fadeUp {
    0% { opacity: 0; transform: translateY(50px); }
    100% { opacity: 1; transform: translateY(0); }
}
</style>

<div class="<?php echo esc_attr($post_type); ?>">
    <!-- Hero Section -->
    <section class="parallax-hero">
        <div class="parallax-bg" style="background-image: url('<?php echo $featured_image ? esc_url($featured_image) : 'https://via.placeholder.com/1200x350/2c3e50/ffffff?text=' . urlencode(get_the_title()); ?>');"></div>
        <div class="hero-overlay"></div>
        <div class="hero-line"></div>
        
        <div class="hero-content">
            <h1 class="hero-title fade-up"><?php the_title(); ?></h1>
            <?php if($brief_description): ?>
                <p class="hero-excerpt fade-up delay-1"><?php echo esc_html($brief_description); ?></p>
            <?php endif; ?>
            
            <div class="trip-meta fade-up delay-2">
                <?php if($trip_duration): ?><span>⏱️ <?php echo esc_html($trip_duration); ?></span><?php endif; ?>
                <?php if($best_season): ?><span>🌅 <?php echo esc_html($best_season); ?></span><?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Enhanced Package Info Box -->
    <div class="package-info-box">
        <?php if($package_overview): ?>
        <div class="package-overview-short">
            <?php echo wp_kses_post(wpautop($package_overview)); ?>
        </div>
        <?php endif; ?>
        
        <div class="package-highlights">
            <?php if($budget_tier): ?>
            <div class="highlight-item">
                <h4>Budget Tier</h4>
                <div class="highlight-value"><?php echo esc_html($budget_tier); ?></div>
            </div>
            <?php endif; ?>
            
            <?php if($starting_price): ?>
            <div class="highlight-item">
                <h4>Starting At</h4>
                <div class="highlight-value">$<?php echo esc_html($starting_price); ?></div>
            </div>
            <?php endif; ?>
            
            <?php if($trip_duration && $duration_nights): ?>
            <div class="highlight-item">
                <h4>Duration</h4>
                <div class="highlight-value"><?php echo esc_html($trip_duration); ?>/<?php echo esc_html($duration_nights); ?> Nights</div>
            </div>
            <?php endif; ?>
            
            <div class="highlight-item">
                <h4>Group Size</h4>
                <div class="highlight-value"><?php echo esc_html($default_adults); ?> Adult<?php echo $default_adults != '1' ? 's' : ''; ?><?php if($default_children > 0): ?>/<?php echo esc_html($default_children); ?> Child<?php echo $default_children != '1' ? 'ren' : ''; ?><?php endif; ?></div>
            </div>
        </div>
        
        <button class="view-details-btn" onclick="showDetails()">VIEW DETAILS</button>
    </div>

    <!-- Detailed Content (Initially Hidden) -->
    <div id="detailed-content" style="display: none;">
        
        <!-- Budget Cards Section -->
        <div class="budget-cards-section">
            <h2>Choose Your Experience Level</h2>
            <div class="budget-cards">
                <div class="budget-card" data-tier="BUDGET">
                    <h3>Budget</h3>
                    <div class="budget-price">From $<?php echo esc_html($starting_price ?: '500'); ?></div>
                    <ul class="budget-features">
                        <li>Standard accommodation</li>
                        <li>Group transportation</li>
                        <li>Essential activities</li>
                        <li>Local guide</li>
                    </ul>
                </div>
                
                <div class="budget-card" data-tier="STANDARD">
                    <h3>Standard</h3>
                    <div class="budget-price">From $<?php echo esc_html($starting_price ? ($starting_price * 1.3) : '650'); ?></div>
                    <ul class="budget-features">
                        <li>Mid-range accommodation</li>
                        <li>Comfortable transportation</li>
                        <li>Enhanced activities</li>
                        <li>Experienced guide</li>
                        <li>Some meals included</li>
                    </ul>
                </div>
                
                <div class="budget-card active" data-tier="PREMIUM">
                    <h3>Premium</h3>
                    <div class="budget-price">From $<?php echo esc_html($starting_price ? ($starting_price * 1.6) : '800'); ?></div>
                    <ul class="budget-features">
                        <li>Premium accommodation</li>
                        <li>Private transportation</li>
                        <li>Exclusive activities</li>
                        <li>Expert private guide</li>
                        <li>Most meals included</li>
                        <li>Special experiences</li>
                    </ul>
                </div>
                
                <div class="budget-card" data-tier="LUXURY">
                    <h3>Luxury</h3>
                    <div class="budget-price">From $<?php echo esc_html($starting_price ? ($starting_price * 2) : '1000'); ?></div>
                    <ul class="budget-features">
                        <li>Luxury accommodation</li>
                        <li>Premium private transport</li>
                        <li>VIP activities</li>
                        <li>Personal concierge</li>
                        <li>All meals included</li>
                        <li>Exclusive experiences</li>
                        <li>24/7 support</li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="destination-container">
            <div class="destination-content">
                <!-- Itinerary with Enhanced Images -->
                <?php if(!empty($itinerary_days) && is_array($itinerary_days)): ?>
                <section class="itinerary-section">
                    <h2>DETAILED ITINERARY</h2>
                    <?php foreach($itinerary_days as $index => $day): ?>
                        <?php if(isset($day['day_title']) && isset($day['day_description'])): ?>
                        <div class="itinerary-day">
                            <div class="day-header" onclick="toggleDay(<?php echo $index; ?>)">
                                <?php 
                                // Check if day has images
                                $day_images = isset($day['day_images']) ? $day['day_images'] : [];
                                if (!empty($day_images) && is_array($day_images) && !empty($day_images[0])):
                                    $first_image = wp_get_attachment_image_url($day_images[0], 'thumbnail');
                                    if ($first_image):
                                ?>
                                <img src="<?php echo esc_url($first_image); ?>" alt="Day <?php echo ($index + 1); ?>" class="day-image-thumb">
                                <?php endif; endif; ?>
                                
                                <div class="day-title">
                                    Day <?php echo ($index + 1); ?>: <?php echo esc_html($day['day_title']); ?>
                                </div>
                                <span class="toggle-icon" id="icon-<?php echo $index; ?>">▼</span>
                            </div>
                            
                            <div class="day-content" id="content-<?php echo $index; ?>">
                                <?php if (!empty($day_images) && is_array($day_images)): ?>
                                <div class="day-images">
                                    <?php foreach($day_images as $image_id): ?>
                                        <?php 
                                        $image_url = wp_get_attachment_image_url($image_id, 'medium');
                                        $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                                        if ($image_url):
                                        ?>
                                        <img src="<?php echo esc_url($image_url); ?>" 
                                             alt="<?php echo esc_attr($image_alt ?: $day['day_title']); ?>" 
                                             class="day-image"
                                             onclick="openLightbox('<?php echo esc_url(wp_get_attachment_image_url($image_id, 'full')); ?>', 'image')">
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </div>
                                <?php endif; ?>
                                
                                <?php echo wp_kses_post(wpautop($day['day_description'])); ?>
                            </div>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </section>
                <?php endif; ?>

                <!-- Price Includes/Excludes -->
                <?php if(!empty($price_includes) || !empty($price_excludes)): ?>
                <section class="includes-excludes">
                    <?php if(!empty($price_includes) && is_array($price_includes)): ?>
                    <div class="includes">
                        <h4>✅ Price Includes</h4>
                        <ul>
                            <?php foreach($price_includes as $include): ?>
                                <?php if(!empty($include)): ?>
                                    <li><?php echo esc_html($include); ?></li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <?php endif; ?>

                    <?php if(!empty($price_excludes) && is_array($price_excludes)): ?>
                    <div class="excludes">
                        <h4>❌ Price Excludes</h4>
                        <ul>
                            <?php foreach($price_excludes as $exclude): ?>
                                <?php if(!empty($exclude)): ?>
                                    <li><?php echo esc_html($exclude); ?></li>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </section>
                <?php endif; ?>
            </div>

            <!-- Enhanced Sidebar -->
            <aside class="destination-sidebar">
                <div class="booking-widget">
                    <h3>PACKAGE DETAILS</h3>
                    <ul>
                        <?php if($trip_price): ?>
                        <li>
                            <span class="info-label">Price (USD):</span>
                            <span><?php echo esc_html($trip_price); ?></span>
                        </li>
                        <?php endif; ?>
                        
                        <?php if($price_ugx): ?>
                        <li>
                            <span class="info-label">Price (UGX):</span>
                            <span><?php echo esc_html($price_ugx); ?></span>
                        </li>
                        <?php endif; ?>
                        
                        <?php if($trip_duration && $duration_nights): ?>
                        <li>
                            <span class="info-label">Duration:</span>
                            <span><?php echo esc_html($trip_duration); ?>/<?php echo esc_html($duration_nights); ?> Nights</span>
                        </li>
                        <?php endif; ?>
                        
                        <?php if($best_season): ?>
                        <li>
                            <span class="info-label">Best Season:</span>
                            <span><?php echo esc_html($best_season); ?></span>
                        </li>
                        <?php endif; ?>
                        
                        <?php if($accommodation): ?>
                        <li>
                            <span class="info-label">Accommodation:</span>
                            <span><?php echo esc_html($accommodation); ?></span>
                        </li>
                        <?php endif; ?>
                        
                        <?php if(!empty($destination)): ?>
                        <li>
                            <span class="info-label">Destination:</span>
                            <span><?php echo esc_html($destination); ?></span>
                        </li>
                        <?php endif; ?>
                        
                        <!-- Group Size Info -->
                        <li>
                            <span class="info-label">Group Size:</span>
                            <span><?php echo esc_html($default_adults); ?> Adult<?php echo $default_adults != '1' ? 's' : ''; ?><?php if($default_children > 0): ?>/<?php echo esc_html($default_children); ?> Child<?php echo $default_children != '1' ? 'ren' : ''; ?><?php endif; ?></span>
                        </li>
                        
                        <!-- Show reviews for romantic packages -->
                        <?php if($post_type === 'romantic_package' && !empty($reviews)): ?>
                        <li>
                            <span class="info-label">Reviews:</span>
                            <span><?php echo intval($reviews); ?> reviews</span>
                        </li>
                        <?php endif; ?>
                    </ul>
                    
                    <button onclick="scrollToBookingForm()" class="book-now-btn">
                        BOOK NOW
                    </button>
                </div>
            </aside>
        </div>

        <!-- Gallery Section -->
        <?php if(!empty($gallery_images) && is_array($gallery_images)): ?>
        <section class="destination-gallery">
            <h2>GALLERY</h2>
            <div class="gallery-grid">
                <?php foreach($gallery_images as $image_id): ?>
                    <?php 
                    $image_url = wp_get_attachment_image_url($image_id, 'medium');
                    $image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
                    ?>
                    <?php if($image_url): ?>
                    <img src="<?php echo esc_url($image_url); ?>" 
                         alt="<?php echo esc_attr($image_alt ?: get_the_title()); ?>" 
                         class="gallery-image"
                         onclick="openLightbox('<?php echo esc_url(wp_get_attachment_image_url($image_id, 'full')); ?>', 'image')">
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </section>
        <?php endif; ?>
    </div>

    <!-- Booking Form Container - Always Visible Below Details -->
    <div class="booking-form-container" id="booking-form-container">
        <div class="booking-form" id="booking-form">
            <h3>Complete Your Booking</h3>
            <form id="package-booking-form" method="post">
                <input type="hidden" name="action" value="submit_package_booking">
                <input type="hidden" name="package_id" value="<?php echo $post_id; ?>">
                <input type="hidden" name="package_name" value="<?php echo esc_attr(get_the_title()); ?>">
                <?php wp_nonce_field('package_booking_nonce', 'booking_nonce'); ?>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="customer_name">Full Name *</label>
                        <input type="text" id="customer_name" name="customer_name" required>
                    </div>
                    <div class="form-group">
                        <label for="customer_email">Email Address *</label>
                        <input type="email" id="customer_email" name="customer_email" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="customer_phone">Telephone Number *</label>
                        <input type="tel" id="customer_phone" name="customer_phone" required>
                    </div>
                    <div class="form-group">
                        <label for="customer_dob">Date of Birth *</label>
                        <input type="date" id="customer_dob" name="customer_dob" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="num_adults">Number of Adults *</label>
                        <select id="num_adults" name="num_adults" required>
                            <?php for($i = 1; $i <= 20; $i++): ?>
                            <option value="<?php echo $i; ?>" <?php selected($i, $default_adults); ?>><?php echo $i; ?> Adult<?php echo $i > 1 ? 's' : ''; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="num_children">Number of Children (Under 12)</label>
                        <select id="num_children" name="num_children">
                            <?php for($i = 0; $i <= 15; $i++): ?>
                            <option value="<?php echo $i; ?>" <?php selected($i, $default_children); ?>><?php echo $i; ?> Child<?php echo $i != 1 ? 'ren' : ''; ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="departure_date">Preferred Departure Date *</label>
                        <input type="date" id="departure_date" name="departure_date" required min="<?php echo date('Y-m-d', strtotime('+1 week')); ?>">
                    </div>
                    <div class="form-group">
                        <label for="budget_preference">Budget Preference *</label>
                        <select id="budget_preference" name="budget_preference" required>
                            <option value="">Select Budget Level</option>
                            <option value="BUDGET">Budget</option>
                            <option value="STANDARD">Standard</option>
                            <option value="PREMIUM" selected>Premium</option>
                            <option value="LUXURY">Luxury</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label for="special_requests">Special Requests / Additional Information</label>
                    <textarea id="special_requests" name="special_requests" rows="4" placeholder="Any dietary requirements, accessibility needs, or special occasions..."></textarea>
                </div>
                
                <div style="display: flex; gap: 1rem; justify-content: center;">
                    <button type="submit" class="submit-booking">SUBMIT BOOKING</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Lightbox -->
<div id="lightbox" class="lightbox">
    <span class="lightbox-close" onclick="closeLightbox()">&times;</span>
    <div id="lightbox-content"></div>
</div>

<script>
// Show detailed content
function showDetails() {
    document.getElementById('detailed-content').style.display = 'block';
    document.querySelector('.view-details-btn').style.display = 'none';
    
    // Smooth scroll to detailed content
    document.getElementById('detailed-content').scrollIntoView({ 
        behavior: 'smooth', 
        block: 'start' 
    });
}

// Scroll to booking form (replaces the old showBookingForm function)
function scrollToBookingForm() {
    document.getElementById('booking-form-container').scrollIntoView({ 
        behavior: 'smooth', 
        block: 'start' 
    });
}

// Budget card selection
document.addEventListener('DOMContentLoaded', function() {
    const budgetCards = document.querySelectorAll('.budget-card');
    budgetCards.forEach(card => {
        card.addEventListener('click', function() {
            budgetCards.forEach(c => c.classList.remove('active'));
            this.classList.add('active');
            
            // Update the budget preference in the form
            const budgetSelect = document.getElementById('budget_preference');
            if (budgetSelect) {
                budgetSelect.value = this.getAttribute('data-tier');
            }
        });
    });
});

// Toggle itinerary day
function toggleDay(index) {
    const content = document.getElementById('content-' + index);
    const icon = document.getElementById('icon-' + index);
    
    if (content.classList.contains('active')) {
        content.classList.remove('active');
        icon.classList.remove('rotated');
    } else {
        // Close all other days
        document.querySelectorAll('.day-content').forEach(el => el.classList.remove('active'));
        document.querySelectorAll('.toggle-icon').forEach(el => el.classList.remove('rotated'));
        
        // Open clicked day
        content.classList.add('active');
        icon.classList.add('rotated');
    }
}

// Lightbox functionality
function openLightbox(url, type) {
    const lightbox = document.getElementById('lightbox');
    const content = document.getElementById('lightbox-content');
    
    if (type === 'image') {
        content.innerHTML = '<img src="' + url + '" alt="Gallery Image">';
    } else if (type === 'video') {
        content.innerHTML = '<video controls><source src="' + url + '" type="video/mp4"></video>';
    }
    
    lightbox.classList.add('active');
    document.body.style.overflow = 'hidden';
}

function closeLightbox() {
    document.getElementById('lightbox').classList.remove('active');
    document.body.style.overflow = 'auto';
}

// Close lightbox on background click
document.getElementById('lightbox').addEventListener('click', function(e) {
    if (e.target === this) {
        closeLightbox();
    }
});

// Form submission
document.getElementById('package-booking-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const submitBtn = this.querySelector('.submit-booking');
    const originalText = submitBtn.textContent;
    
    submitBtn.textContent = 'SUBMITTING...';
    submitBtn.disabled = true;
    
    // Add error handling for the fetch call
    fetch('<?php echo admin_url("admin-ajax.php"); ?>', {
        method: 'POST',
        body: formData
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then(data => {
        if (data.success) {
            alert('Booking submitted successfully! We will contact you soon.');
            this.reset();
        } else {
            alert('Error submitting booking: ' + (data.data || 'Please try again.'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error submitting booking. Please check your connection and try again.');
    })
    .finally(() => {
        submitBtn.textContent = originalText;
        submitBtn.disabled = false;
    });
});
</script>

<?php
endwhile; // End of the loop



function add_bookings_admin_menu() {
    add_menu_page(
        'Bookings',
        'Bookings',
        'manage_options',
        'package-bookings',
        'display_bookings_page',
        'dashicons-calendar-alt',
        6
    );
}

function display_bookings_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'package_bookings';
    
    // Handle status updates
    if (isset($_POST['update_status']) && isset($_POST['booking_id']) && isset($_POST['new_status'])) {
        $booking_id = intval($_POST['booking_id']);
        $new_status = sanitize_text_field($_POST['new_status']);
        
        $wpdb->update(
            $table_name,
            array('status' => $new_status),
            array('id' => $booking_id),
            array('%s'),
            array('%d')
        );
        
        echo '<div class="notice notice-success"><p>Booking status updated successfully.</p></div>';
    }
    
    // Get all bookings
    $bookings = $wpdb->get_results("SELECT * FROM $table_name ORDER BY booking_date DESC");
    
    ?>
    <div class="wrap">
        <h1>Package Bookings</h1>
        
        <?php if (empty($bookings)): ?>
            <p>No bookings found.</p>
        <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Package</th>
                    <th>Customer</th>
                    <th>Contact</th>
                    <th>Group Size</th>
                    <th>Departure</th>
                    <th>Budget</th>
                    <th>Status</th>
                    <th>Booking Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($bookings as $booking): ?>
                <tr>
                    <td><?php echo $booking->id; ?></td>
                    <td><strong><?php echo esc_html($booking->package_name); ?></strong></td>
                    <td><?php echo esc_html($booking->customer_name); ?><br><small>DOB: <?php echo esc_html($booking->customer_dob); ?></small></td>
                    <td>
                        <a href="mailto:<?php echo esc_attr($booking->customer_email); ?>"><?php echo esc_html($booking->customer_email); ?></a><br>
                        <a href="tel:<?php echo esc_attr($booking->customer_phone); ?>"><?php echo esc_html($booking->customer_phone); ?></a>
                    </td>
                    <td><?php echo $booking->num_adults; ?> Adults<?php if($booking->num_children > 0): ?><br><?php echo $booking->num_children; ?> Children<?php endif; ?></td>
                    <td><?php echo esc_html($booking->departure_date); ?></td>
                    <td><span class="budget-<?php echo strtolower($booking->budget_preference); ?>"><?php echo esc_html($booking->budget_preference); ?></span></td>
                    <td>
                        <span class="status-<?php echo $booking->status; ?>">
                            <?php echo ucfirst($booking->status); ?>
                        </span>
                    </td>
                    <td><?php echo date('M j, Y', strtotime($booking->booking_date)); ?></td>
                    <td>
                        <form method="post" style="display:inline;">
                            <input type="hidden" name="booking_id" value="<?php echo $booking->id; ?>">
                            <select name="new_status" onchange="this.form.submit()">
                                <option value="pending" <?php selected($booking->status, 'pending'); ?>>Pending</option>
                                <option value="confirmed" <?php selected($booking->status, 'confirmed'); ?>>Confirmed</option>
                                <option value="cancelled" <?php selected($booking->status, 'cancelled'); ?>>Cancelled</option>
                                <option value="completed" <?php selected($booking->status, 'completed'); ?>>Completed</option>
                            </select>
                            <input type="hidden" name="update_status" value="1">
                        </form>
                        <?php if (!empty($booking->special_requests)): ?>
                        <br><small><strong>Requests:</strong> <?php echo esc_html(wp_trim_words($booking->special_requests, 10)); ?></small>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php endif; ?>
    </div>
    
    <style>
    .status-pending { color: #f56565; }
    .status-confirmed { color: #48bb78; }
    .status-cancelled { color: #a0aec0; }
    .status-completed { color: #4299e1; }
    .budget-budget { background: #e2e8f0; padding: 2px 8px; border-radius: 4px; }
    .budget-standard { background: #bee3f8; padding: 2px 8px; border-radius: 4px; }
    .budget-premium { background: #d6f5d6; padding: 2px 8px; border-radius: 4px; }
    .budget-luxury { background: #fed7d7; padding: 2px 8px; border-radius: 4px; }
    </style>
    <?php
}

get_footer();
?>