<?php
/* Template Name: Destinations Template */
get_header();
include get_template_directory() . '/inc/menus/menu.php';

// Get the current destination post
global $post;
$destination_id = $post->ID;
$featured_image_url = get_the_post_thumbnail_url($destination_id, 'full');
$destination_slug = $post->post_name;

// Get meta data
$map_image = get_post_meta($destination_id, '_map_image', true);
$overview_text = get_post_meta($destination_id, '_overview_text', true);
$places_activities = get_post_meta($destination_id, '_places_activities', true);
$show_packages = get_post_meta($destination_id, '_show_packages', true);
$packages_title = get_post_meta($destination_id, '_packages_title', true);

if (!is_array($places_activities)) $places_activities = array();

// Get useful information
$useful_info_items = array(
    'before_travel' => 'Before You Travel',
    'visa_requirements' => 'Visa and Entry Requirements', 
    'what_to_pack' => 'What to Pack',
    'weather' => 'Weather',
    'cultural_etiquette' => 'Cultural Etiquette',
    'religion' => 'Religion',
    'currency_payments' => 'Currency and Payments',
    'communication_internet' => 'Communication and Internet',
    'getting_around' => 'Getting Around',
    'health_safety' => 'Health and Safety'
);
?>

<style>
.destination-hero{height:350px;background-attachment:fixed;background-position:center;background-repeat:no-repeat;background-size:cover;position:relative;display:flex;align-items:center;justify-content:center;text-align:center;color:white;overflow:hidden}
.destination-hero::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:linear-gradient(to bottom,rgba(0,0,0,0.3),rgba(0,0,0,0.7))}
.hero-content{position:relative;z-index:2;max-width:800px;padding:0 20px}
.hero-title{font-size:3.5rem;font-weight:700;margin-bottom:15px;text-shadow:2px 2px 8px rgba(0,0,0,0.7)}
.hero-subtitle{font-size:1.5rem;font-weight:400;margin-bottom:25px;text-shadow:1px 1px 4px rgba(0,0,0,0.7)}
.destination-tabs{background:linear-gradient(135deg,#003366 0%,#0077CC 100%);border-bottom:none;margin-bottom:0;padding:20px 0;position:sticky;top:0;z-index:100;box-shadow:0 4px 20px rgba(0,0,0,0.15)}
.nav-tabs{border-bottom:none;justify-content:center;gap:15px}
.nav-tabs .nav-link{border:none;background:rgba(255,255,255,0.1);color:white;font-weight:600;padding:18px 35px;margin:0;border-radius:50px;position:relative;transition:all 0.4s ease;font-size:1.1em;text-transform:uppercase;letter-spacing:0.5px;backdrop-filter:blur(10px);border:2px solid rgba(255,255,255,0.2);min-width:180px;text-align:center}
.nav-tabs .nav-link:hover{background:rgba(255,255,255,0.2);color:white;transform:translateY(-3px);box-shadow:0 8px 25px rgba(0,0,0,0.2)}
.nav-tabs .nav-link.active{background:white;color:#003366;transform:translateY(-3px);box-shadow:0 8px 25px rgba(0,0,0,0.3)}
.destination-map-section{background:#fff;padding:60px 0 40px 0}
.map-container{position:relative;background:#f8f9fa;border-radius:16px;overflow:hidden;box-shadow:0 8px 30px rgba(0,0,0,0.1);margin-bottom:30px}
.interactive-map{width:100%;height:450px;border:none;border-radius:16px}
.map-placeholder{height:450px;background:linear-gradient(135deg,#003366 0%,#0077CC 100%);display:flex;align-items:center;justify-content:center;color:white;font-size:1.3em;text-align:center;border-radius:16px}
.map-info{background:white;padding:30px;border-radius:16px;box-shadow:0 8px 30px rgba(0,0,0,0.1);height:fit-content}
.map-info h3{color:#333;margin-bottom:20px;font-size:1.5em;font-weight:600}
.map-info p{color:#666;line-height:1.7;margin-bottom:15px}
.content-section{padding:60px 0;border-bottom:1px solid #f0f0f0}
.content-section:last-child{border-bottom:none}
.section-title{text-align:center;font-size:2.5em;font-weight:700;color:#333;margin-bottom:50px;position:relative}
.section-title::after{content:'';position:absolute;bottom:-15px;left:50%;transform:translateX(-50%);width:80px;height:4px;background:linear-gradient(45deg,#003366,#0077CC);border-radius:2px}
#places{background:#f8f9fb}
.places-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(350px,1fr));gap:30px;margin-top:40px}
.place-item{background:#fff;border-radius:20px;overflow:hidden;box-shadow:0 10px 40px rgba(0,0,0,0.1);transition:all 0.4s ease;position:relative}
.place-item:hover{transform:translateY(-10px);box-shadow:0 20px 60px rgba(0,0,0,0.15)}
.place-image{height:250px;background-size:cover;background-position:center;position:relative;overflow:hidden}
.place-image::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:linear-gradient(45deg,rgba(0,51,102,0.3),rgba(0,119,204,0.3));opacity:0;transition:opacity 0.3s ease}
.place-item:hover .place-image::before{opacity:1}
.place-content{padding:30px}
.place-title{font-size:1.4em;font-weight:700;margin-bottom:15px;color:#333}
.place-description{color:#666;line-height:1.7;font-size:1.05em}
.packages-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(380px,1fr));gap:35px;margin-top:50px}
.package-card{background:#fff;border-radius:20px;overflow:hidden;box-shadow:0 15px 50px rgba(0,0,0,0.08);transition:all 0.4s ease;position:relative;border:1px solid rgba(0,0,0,0.05)}
.package-card:hover{transform:translateY(-12px);box-shadow:0 25px 70px rgba(0,0,0,0.15)}
.package-image{height:280px;background-size:cover;background-position:center;position:relative;overflow:hidden}
.package-image::before{content:'';position:absolute;top:0;left:0;right:0;bottom:0;background:linear-gradient(0deg,rgba(0,0,0,0.4) 0%,rgba(0,0,0,0.1) 50%,transparent 100%)}
.package-price{position:absolute;top:20px;right:20px;background:rgba(255,255,255,0.95);color:#003366;padding:12px 20px;border-radius:25px;font-weight:700;font-size:1.1em;backdrop-filter:blur(10px);box-shadow:0 8px 25px rgba(0,0,0,0.15)}
.package-badge{position:absolute;top:20px;left:20px;background:linear-gradient(45deg,#FF3D00,#D40000);color:white;padding:8px 16px;border-radius:20px;font-size:0.85em;font-weight:600;text-transform:uppercase}
.package-content{padding:35px}
.package-title{font-size:1.5em;font-weight:700;margin-bottom:12px;color:#333;line-height:1.3}
.package-duration{color:#003366;font-size:1em;margin-bottom:18px;font-weight:600;display:flex;align-items:center;gap:8px}
.package-duration::before{content:"🕒";font-size:1.2em}
.package-description{color:#666;line-height:1.7;margin-bottom:25px;font-size:1.05em}
.package-features{list-style:none;padding:0;margin-bottom:30px}
.package-features li{padding:8px 0;color:#555;position:relative;padding-left:30px;font-size:1.05em;line-height:1.5}
.package-features li:before{content:"✓";color:#28a745;font-weight:bold;font-size:1.2em;position:absolute;left:0;top:8px}
.package-footer{display:flex;justify-content:space-between;align-items:center;margin-top:25px;padding-top:25px;border-top:1px solid #f0f0f0}
.package-btn{background:linear-gradient(45deg,#003366,#0077CC);color:white;border:none;padding:15px 30px;border-radius:30px;font-weight:600;text-decoration:none;transition:all 0.3s ease;font-size:1.05em;text-transform:uppercase;letter-spacing:0.5px;position:relative;overflow:hidden}
.package-btn:hover{transform:translateY(-2px);color:white;text-decoration:none;box-shadow:0 10px 30px rgba(0,51,102,0.4)}
.package-btn::before{content:'';position:absolute;top:0;left:-100%;width:100%;height:100%;background:linear-gradient(90deg,transparent,rgba(255,255,255,0.2),transparent);transition:left 0.5s ease}
.package-btn:hover::before{left:100%}
#useful-info{background:#f8f9fb}
.useful-info-accordion{margin-top:40px;max-width:900px;margin-left:auto;margin-right:auto}
.accordion-item{border:1px solid #e9ecef;border-radius:15px;margin-bottom:20px;overflow:hidden;box-shadow:0 5px 20px rgba(0,0,0,0.05)}
.accordion-header:hover{background:linear-gradient(135deg,#002244 0%,#0066BB 100%)}
.accordion-header::after{position:absolute;right:30px;font-size:1.8em;font-weight:300;transition:transform 0.3s ease}
.accordion-header.active::after{transform:rotate(45deg)}
.accordion-content{padding:0;max-height:0;overflow:hidden;transition:all 0.4s ease;background:white}
.accordion-content.active{padding:30px;max-height:1000px}
.accordion-text{color:#666;line-height:1.7;font-size:1.05em}
html{scroll-behavior:smooth}
.destination-detail-panel{max-width:1200px;margin:2rem auto;background:white;border-radius:12px;box-shadow:0 8px 30px rgba(0,0,0,0.1);overflow:hidden}
.destination-tabs{display:flex;background:linear-gradient(135deg,#003366 0%,#0077CC 100%);border-bottom:1px solid rgba(255,255,255,0.1)}
.tab-item{flex:1;color:rgba(255,255,255,0.8);padding:1.5rem 1rem;display:flex;align-items:center;justify-content:center;cursor:pointer;transition:all 0.3s ease;border-right:1px solid rgba(255,255,255,0.1);position:relative;overflow:hidden}
.tab-item:last-child{border-right:none}
.tab-item::before{content:'';position:absolute;bottom:0;left:0;width:100%;height:3px;background:#ff6b6b;transform:translateX(-100%);transition:transform 0.3s ease}
.tab-item:hover{color:white;background:rgba(255,255,255,0.1)}
.tab-item.active{color:white;background:rgba(255,255,255,0.15)}
.tab-item.active::before{transform:translateX(0)}
.tab-item i{margin-right:0.75rem;font-size:1.1rem}
.tab-item span{font-weight:500;font-size:0.95rem}
.tab-content{min-height:500px}
.tab-pane{display:none;padding:3rem;animation:fadeIn 0.5s ease-in-out}
.tab-pane.active{display:block}
@keyframes fadeIn{from{opacity:0;transform:translateY(20px)}to{opacity:1;transform:translateY(0)}}
.places-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(350px,1fr));gap:2rem}
.place-card{background:white;border-radius:12px;overflow:hidden;box-shadow:0 4px 20px rgba(0,0,0,0.08);transition:all 0.3s ease}
.place-card:hover{transform:translateY(-5px);box-shadow:0 8px 30px rgba(0,0,0,0.15)}
.place-image{height:200px;overflow:hidden}
.place-image img{width:100%;height:100%;object-fit:cover;transition:transform 0.3s ease}
.place-card:hover .place-image img{transform:scale(1.05)}
.place-content{padding:1.5rem}
.place-content h3{margin:0 0 1rem;color:#333;font-size:1.25rem;font-weight:600}
.place-content p{color:#666;line-height:1.6;margin:0}
.package-card-enhanced{background:white;border-radius:15px;overflow:hidden;box-shadow:0 5px 20px rgba(0,0,0,0.1);transition:all 0.3s ease}
.package-card-enhanced:hover{transform:translateY(-8px);box-shadow:0 15px 40px rgba(0,0,0,0.2)}
.package-image-enhanced{height:220px;background-size:cover;background-position:center;position:relative}
.package-badge{position:absolute;top:15px;left:15px;background:#ff6b6b;color:white;padding:6px 12px;border-radius:20px;font-size:0.8rem;font-weight:600;text-transform:uppercase}
.package-price{position:absolute;top:15px;right:15px;display:flex;flex-direction:column;align-items:flex-end}
.price-usd{background:#ff6b6b;color:white;padding:8px 12px;border-radius:6px;font-weight:bold;margin-bottom:5px}
.price-ugx{background:rgba(0,0,0,0.7);color:white;padding:4px 8px;border-radius:4px;font-size:0.85rem}
.package-info-enhanced{padding:1.5rem}
.package-info-enhanced h3{margin:0 0 1rem;font-size:1.3rem;color:#333;font-weight:600}
.destination-info{color:#666;font-size:0.9rem;margin-bottom:1rem;display:flex;align-items:center}
.destination-info i{color:#ff6b6b;margin-right:0.5rem}
.package-excerpt{color:#555;line-height:1.6;margin-bottom:1.5rem}
.package-footer{display:flex;justify-content:space-between;align-items:center;border-top:1px solid #f0f0f0;padding-top:1rem}
.rating{display:flex;align-items:center;font-size:0.9rem}
.stars{color:#ffa500;margin-right:0.5rem}
.review-count{color:#666}
.view-package-btn{background:linear-gradient(45deg,#003366,#0077CC);color:white;padding:10px 20px;border-radius:25px;text-decoration:none;font-weight:500;transition:all 0.3s ease;text-transform:uppercase;font-size:0.85rem}
.view-package-btn:hover{background:linear-gradient(45deg,#002244,#0066BB);transform:translateY(-2px);box-shadow:0 5px 15px rgba(0,0,0,0.2)}
.accordion{max-width:800px;margin:0 auto}
.accordion-item{border:1px solid #e2e8f0;border-radius:8px;margin-bottom:1rem;overflow:hidden;background:white}
.accordion-header{background:linear-gradient(135deg,#f7fafc 0%,#edf2f7 100%);padding:1.25rem 1.5rem;cursor:pointer;display:flex;justify-content:space-between;align-items:center;transition:all 0.3s ease;border-bottom:1px solid transparent}
.accordion-header:hover{background:linear-gradient(135deg,#edf2f7 0%,#e2e8f0 100%)}
.accordion-header.active{background:linear-gradient(135deg,#003366 0%,#0077CC 100%);color:white;border-bottom:1px solid rgba(255,255,255,0.2)}
.accordion-header h3{margin:0;font-size:1.1rem;font-weight:600}
.accordion-header i{font-size:1rem;transition:transform 0.3s ease}
.accordion-header.active i{transform:rotate(180deg)}
.accordion-content{max-height:0;overflow:hidden;transition:max-height 0.3s ease}
.accordion-content.active{max-height:1000px}
.accordion-body{padding:1.5rem;line-height:1.7;color:#4a5568;background:#f8fafc}
.no-content{text-align:center;padding:4rem 2rem;color:#666}
.no-content i{display:block;margin-bottom:1rem;color:#ccc}
.no-content p{font-size:1.1rem;margin:0}
@media (max-width:768px){.nav-tabs{flex-wrap:wrap;gap:10px}.nav-tabs .nav-link{padding:14px 20px;font-size:0.95em;min-width:140px}.section-title{font-size:2em}.packages-grid,.places-grid{grid-template-columns:1fr;gap:25px}.map-container{margin-bottom:30px}.interactive-map,.map-placeholder{height:300px}.package-content,.place-content{padding:25px}.hero-title{font-size:2.5rem}.hero-subtitle{font-size:1.2rem}.destination-tabs{flex-wrap:wrap}.tab-item{flex:1 1 50%;min-width:200px}.tab-pane{padding:2rem}.places-grid{grid-template-columns:1fr}.packages-grid{grid-template-columns:repeat(auto-fit,minmax(280px,1fr))!important}}
@media (max-width:480px){.nav-tabs .nav-link{padding:12px 16px;font-size:0.9em;min-width:120px}.section-title{font-size:1.8em;margin-bottom:40px}.destination-detail-panel{margin:1rem;border-radius:8px}.tab-item{padding:1rem 0.5rem;flex-direction:column;text-align:center}.tab-item i{margin-right:0;margin-bottom:0.5rem}.tab-item span{font-size:0.8rem}.tab-pane{padding:1.5rem}.packages-grid{grid-template-columns:1fr!important}.tab-item{flex:1 1 100%;border-right:none;border-bottom:1px solid rgba(255,255,255,0.1)}.tab-item:last-child{border-bottom:none}.hero-title{font-size:2rem}.hero-subtitle{font-size:1rem}}

</style>

<!-- Hero Section with Parallax Background -->
<div class="destination-hero" style="background-image: url('<?php echo esc_url($featured_image_url ? $featured_image_url : 'https://via.placeholder.com/1920x350/003366/ffffff?text=' . urlencode(get_the_title())); ?>');">
    <div class="hero-content">
        <h1 class="hero-title"><?php the_title(); ?></h1>
        <p class="hero-subtitle">Discover the beauty and adventure that awaits</p>
    </div>
</div>

<div class="destination-detail-panel">
    <!-- Tab Navigation -->
    <div class="destination-tabs">
        <div class="tab-item active" data-tab="overview">
            <i class="fas fa-globe-americas"></i>
            <span>Overview</span>
        </div>
        <div class="tab-item" data-tab="places">
            <i class="fas fa-camera"></i>
            <span>Places & Activities</span>
        </div>
        <div class="tab-item" data-tab="packages">
            <i class="fas fa-suitcase"></i>
            <span>Popular <?php echo esc_html(get_the_title()); ?> Packages</span>
        </div>
        <div class="tab-item" data-tab="useful-info">
            <i class="fas fa-info-circle"></i>
            <span>Useful Info</span>
        </div>
    </div>

    <!-- Tab Content -->
    <div class="tab-content">
        <!-- Overview Tab -->
        <div id="overview" class="tab-pane active">
            <div class="overview-content">
                <?php if ($map_image) : ?>
                    <div class="map-container" style="text-align: center; margin-bottom: 30px;">
                        <img src="<?php echo esc_url($map_image); ?>" alt="<?php echo esc_attr(get_the_title()); ?> Map" style="max-width: 100%; height: auto; border-radius: 8px; box-shadow: 0 4px 15px rgba(0,0,0,0.1);">
                    </div>
                <?php endif; ?>
                
                <?php if ($overview_text) : ?>
                    <div class="overview-text" style="font-size: 1.1rem; line-height: 1.7; color: #444;">
                        <?php echo nl2br(esc_html($overview_text)); ?>
                    </div>
                <?php else : ?>
                    <p style="text-align: center; color: #666; font-style: italic;">No overview information available.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Places & Activities Tab -->
        <div id="places" class="tab-pane">
            <?php if (!empty($places_activities)) : ?>
                <div class="places-grid">
                    <?php foreach ($places_activities as $place) : ?>
                        <div class="place-card">
                            <?php if (!empty($place['image'])) : ?>
                                <div class="place-image">
                                    <img src="<?php echo esc_url($place['image']); ?>" alt="<?php echo esc_attr($place['name']); ?>">
                                </div>
                            <?php endif; ?>
                            <div class="place-content">
                                <h3><?php echo esc_html($place['name']); ?></h3>
                                <p><?php echo nl2br(esc_html($place['description'])); ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else : ?>
                <div class="no-content">
                    <i class="fas fa-camera" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.3;"></i>
                    <p>No places or activities information available.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Popular Packages Tab -->
        <div id="packages" class="tab-pane">
            <?php if ($show_packages === '1') : ?>
                <div class="packages-section">
                    <h2 style="text-align: center; margin-bottom: 30px; color: #333;">
                        <?php echo esc_html($packages_title ?: 'Popular ' . get_the_title() . ' Packages'); ?>
                    </h2>
                    
                    <div class="packages-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 25px;">
                        <?php
                        // Get travel packages related to this destination
                        $packages_query = new WP_Query(array(
                            'post_type' => 'travel_package',
                            'posts_per_page' => -1,
                            'meta_query' => array(
                                array(
                                    'key' => '_destination',
                                    'value' => get_the_title(),
                                    'compare' => 'LIKE'
                                )
                            )
                        ));

                        if ($packages_query->have_posts()) :
                            while ($packages_query->have_posts()) : $packages_query->the_post();
                                $price_usd = get_post_meta(get_the_ID(), '_price_usd', true);
                                $price_ugx = get_post_meta(get_the_ID(), '_price_ugx', true);
                                $package_destination = get_post_meta(get_the_ID(), '_destination', true);
                                $reviews = get_post_meta(get_the_ID(), '_reviews', true);
                                $badge = get_post_meta(get_the_ID(), '_badge', true);
                                
                                $image_id = get_post_thumbnail_id(get_the_ID());
                                if ($image_id) {
                                    $image = wp_get_attachment_image_url($image_id, 'medium_large');
                                } else {
                                    $image = 'https://via.placeholder.com/400x250/f0f0f0/999999?text=No+Image';
                                }
                                ?>
                                <div class="package-card-enhanced">
                                    <div class="package-image-enhanced" style="background-image: url('<?php echo esc_url($image); ?>');">
                                        <?php if ($badge) : ?>
                                            <div class="package-badge"><?php echo esc_html($badge); ?></div>
                                        <?php endif; ?>
                                        <div class="package-price">
                                            <?php if ($price_usd) : ?>
                                                <span class="price-usd"><?php echo esc_html($price_usd); ?></span>
                                            <?php endif; ?>
                                            <?php if ($price_ugx) : ?>
                                                <span class="price-ugx"><?php echo esc_html($price_ugx); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    
                                    <div class="package-info-enhanced">
                                        <h3><?php the_title(); ?></h3>
                                        <?php if ($package_destination) : ?>
                                            <div class="destination-info">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <?php echo esc_html($package_destination); ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="package-excerpt">
                                            <?php 
                                            if (has_excerpt()) {
                                                echo wp_trim_words(get_the_excerpt(), 15, '...');
                                            } else {
                                                echo wp_trim_words(get_the_content(), 15, '...');
                                            }
                                            ?>
                                        </div>
                                        
                                        <div class="package-footer">
                                            <?php if ($reviews && $reviews > 0) : ?>
                                                <div class="rating">
                                                    <span class="stars">â˜…â˜…â˜…â˜…â˜…</span>
                                                    <span class="review-count">(<?php echo intval($reviews); ?>)</span>
                                                </div>
                                            <?php endif; ?>
                                            <a href="<?php the_permalink(); ?>" class="view-package-btn">View Package</a>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile;
                            wp_reset_postdata();
                        else : ?>
                            <div class="no-content" style="grid-column: 1/-1;">
                                <i class="fas fa-suitcase" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.3;"></i>
                                <p>No packages found for this destination.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php else : ?>
                <div class="no-content">
                    <i class="fas fa-suitcase" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.3;"></i>
                    <p>Package display is disabled for this destination.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Useful Info Tab -->
        <div id="useful-info" class="tab-pane">
            <div class="accordion">
                <?php 
                $has_content = false;
                foreach ($useful_info_items as $key => $label) :
                    $content = get_post_meta($destination_id, '_useful_info_' . $key, true);
                    if ($content) :
                        $has_content = true;
                ?>
                    <div class="accordion-item">
                        <div class="accordion-header" data-target="<?php echo esc_attr($key); ?>">
                            <h3><?php echo esc_html($label); ?></h3>
                            <i class="fas fa-chevron-down"></i>
                        </div>
                        <div class="accordion-content" id="<?php echo esc_attr($key); ?>">
                            <div class="accordion-body">
                                <?php echo nl2br(esc_html($content)); ?>
                            </div>
                        </div>
                    </div>
                <?php 
                    endif;
                endforeach; 
                
                if (!$has_content) :
                ?>
                    <div class="no-content">
                        <i class="fas fa-info-circle" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.3;"></i>
                        <p>No useful information available.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
    jQuery(document).ready(function($) {
        // Function to update URL with hash
        function updateUrlHash(tabId) {
            if (history.pushState) {
                // Update URL without reloading the page
                var newUrl = window.location.protocol + "//" + window.location.host + window.location.pathname + '#' + tabId;
                window.history.pushState({path: newUrl}, '', newUrl);
            } else {
                // Fallback for older browsers
                window.location.hash = '#' + tabId;
            }
        }
        
        // Function to get hash from URL
        function getHashFromUrl() {
            return window.location.hash.substring(1);
        }
        
        // Function to activate tab based on hash
        function activateTabFromHash() {
            var hash = getHashFromUrl();
            if (hash) {
                // Remove active class from all tabs and panes
                $('.tab-item').removeClass('active');
                $('.tab-pane').removeClass('active');
                
                // Add active class to the tab and pane corresponding to the hash
                $('.tab-item[data-tab="' + hash + '"]').addClass('active');
                $('#' + hash).addClass('active');
            }
        }
        
        // Activate tab based on URL hash when page loads
        activateTabFromHash();
        
        // Tab switching
        $('.tab-item').on('click', function() {
            var tabId = $(this).data('tab');
            
            // Update URL with hash
            updateUrlHash(tabId);
            
            // Switch tabs
            $('.tab-item').removeClass('active');
            $(this).addClass('active');
            $('.tab-pane').removeClass('active');
            $('#' + tabId).addClass('active');
        });

        // Handle browser back/forward button
        $(window).on('popstate', function() {
            activateTabFromHash();
        });

        // Accordion functionality
        $('.accordion-header').on('click', function() {
            var $header = $(this);
            var $content = $header.next('.accordion-content');
            var $item = $header.closest('.accordion-item');

            // Toggle active state
            $header.toggleClass('active');
            $content.toggleClass('active');

            // Close other accordion items (optional - remove if you want multiple open)
            $('.accordion-header').not($header).removeClass('active');
            $('.accordion-content').not($content).removeClass('active');
        });
    });
</script>

<?php get_footer(); ?>