<?php get_header();
    include get_template_directory() . '/inc/menus/menu.php'; 
?>

<style>
.parallax-hero { position: relative; height: 350px; overflow: hidden; display: flex; align-items: center; justify-content: center; }
.parallax-bg { position: absolute; top: -20%; left: 0; width: 100%; height: 120%; background-attachment: fixed; background-position: center center; background-repeat: no-repeat; background-size: cover; will-change: transform; z-index: 1; animation: zoomIn 20s ease-out infinite alternate; }
@keyframes zoomIn { 0% { transform: scale(1); } 100% { transform: scale(1.1); } }
.hero-overlay { position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: linear-gradient(135deg, rgba(0,0,0,0.4) 0%, rgba(0,0,0,0.2) 100%); z-index: 2; }
.hero-content { position: relative; z-index: 3; text-align: center; color: white; padding: 2rem; max-width: 800px; margin: 0 auto; }
.hero-title { font-size: 3rem; font-weight: 700; margin-bottom: 1rem; text-shadow: 2px 2px 4px rgba(0,0,0,0.5); line-height: 1.2; }
.hero-excerpt { font-size: 1.1rem; line-height: 1.6; margin-bottom: 1.5rem; text-shadow: 1px 1px 2px rgba(0,0,0,0.5); opacity: 0.9; }
.hero-line { position: absolute; bottom: 0; left: 0; width: 100%; height: 1px; background-color: white; z-index: 4; }

/* Responsive adjustments */
@media (max-width: 768px) {
    .parallax-hero { height: 400px; }
    .hero-title { font-size: 2.2rem; }
    .hero-excerpt { font-size: 1rem; }
    .parallax-bg { background-attachment: scroll; }
}

@media (max-width: 480px) {
    .parallax-hero { height: 350px; }
    .hero-title { font-size: 1.8rem; }
    .hero-excerpt { font-size: 0.9rem; }
}

/* Animation styles */
.fade-up { opacity: 0; transform: translateY(50px); animation: fadeUp 1.2s ease-out forwards; }
.fade-up.delay-1 { animation-delay: 0.3s; }
.fade-up.delay-2 { animation-delay: 0.6s; }
@keyframes fadeUp { 0% { opacity: 0; transform: translateY(50px); } 100% { opacity: 1; transform: translateY(0); } }

/* Additional text animation */
.hero-title { animation-duration: 1.5s; }
.hero-excerpt { opacity: 0; animation-duration: 1.3s; }
</style>


<main role="main">
    <?php 
    // Store the original post data
    $original_post = $post;
    
    // Get the background image safely
    $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($original_post->ID), 'full'); 
    
    // Get excerpt or trimmed content
    $excerpt = $original_post->post_excerpt;
    if (empty($excerpt)) {
        $excerpt = wp_trim_words($original_post->post_content, 30, '...');
    }
    ?>
    
    <section class="parallax-hero">
        <div class="parallax-bg" style="background-image: url('<?php echo $backgroundImg[0] ? $backgroundImg[0] : get_template_directory_uri() . '/assets/images/default-hero.jpg'; ?>');" id="parallax-bg"></div>
        
        <div class="hero-overlay"></div>
        
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="hero-content">
                        <h1 class="hero-title fade-up"><?php echo esc_html($original_post->post_title); ?></h1>
                        
                        <?php if (!empty($excerpt)): ?>
                            <div class="hero-excerpt fade-up delay-1"><?php echo esc_html($excerpt); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="hero-line"></div>
    </section>

    <!-- Rest of your content -->
    <?php 
    // Reset to original post
    $post = $original_post;
    setup_postdata($post);
    
    if (have_posts()): while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php the_content(); ?>
        </article>
    <?php endwhile; ?>
    <?php else: ?>
        <article>
            <h2><?php _e('Sorry, nothing to display.', 'kipya'); ?></h2>
        </article>
    <?php endif; ?>

    <?php edit_post_link(); ?>
</main>

<script>
// Enhanced parallax effect with zoom
window.addEventListener('scroll', function() {
    const scrolled = window.pageYOffset;
    const parallaxBg = document.getElementById('parallax-bg');
    const rate = scrolled * -0.5;
    const zoom = 1 + (scrolled * 0.0005); // Subtle zoom on scroll
    
    if (parallaxBg) {
        parallaxBg.style.transform = `translate3d(0, ${rate}px, 0) scale(${Math.min(zoom, 1.2)})`;
    }
});

// Trigger fade-up animations immediately for hero content
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        document.querySelectorAll('.fade-up').forEach((el, index) => {
            setTimeout(() => {
                el.style.animationPlayState = 'running';
                el.classList.add('animate');
            }, index * 200); // Stagger the animations
        });
    }, 500); // Start after page load
});

// Additional smooth scroll effect for better performance
let ticking = false;
function updateParallax() {
    const scrolled = window.pageYOffset;
    const parallaxBg = document.getElementById('parallax-bg');
    const rate = scrolled * -0.3;
    
    if (parallaxBg) {
        parallaxBg.style.transform = `translate3d(0, ${rate}px, 0)`;
    }
    ticking = false;
}

function requestTick() {
    if (!ticking) {
        requestAnimationFrame(updateParallax);
        ticking = true;
    }
}

window.addEventListener('scroll', requestTick);
</script>

<?php get_footer(); ?>