<?php


function visa_support_services_shortcode() {
    $options = get_option('visa_services_options');
    ob_start(); ?>
    <style>
        .visa-services-panel {display: flex; max-height: 500px;}
        .visa-sidebar {flex-shrink: 0;}
        .visa-content {flex: 1; overflow-y: auto; max-height: 500px; padding-right: 10px;}
        .visa-content::-webkit-scrollbar {width: 8px;}
        .visa-content::-webkit-scrollbar-track {background: #f1f1f1; border-radius: 4px;}
        .visa-content::-webkit-scrollbar-thumb {background: #c1c1c1;border-radius: 4px;}
        .visa-content::-webkit-scrollbar-thumb:hover {background: #a8a8a8;}

        /* Content Styling - These styles will be applied to all content added through WordPress editor */
        .visa-content .content-item h1,
        .visa-content .content-item h2,
        .visa-content .content-item h3,
        .visa-content .content-item h4,
        .visa-content .content-item h5,
        .visa-content .content-item h6 { color: #1e3a8a; font-weight: 600; line-height: 1.4; margin: 20px 0 15px 0; border-bottom: 2px solid #e5e7eb; padding-bottom: 8px; }

        .visa-content .content-item h1 { font-size: 24px; }
        .visa-content .content-item h2 { font-size: 22px; }
        .visa-content .content-item h3 { font-size: 20px; }
        .visa-content .content-item h4 { font-size: 18px; }
        .visa-content .content-item h5 { font-size: 16px; }
        .visa-content .content-item h6 { font-size: 14px; }

        /* Paragraph styling */
        .visa-content .content-item p { line-height: 1.8; margin: 0 0 16px 0; color: #374151;
            font-size: 14px;
            text-align: justify;
            word-spacing: 0.1em;
        }

        /* List styling with stars instead of dots */
        .visa-content .content-item ul {margin: 16px 0;padding-left: 0;list-style: none;}

        .visa-content .content-item ul li {
            position: relative;
            padding-left: 25px;
            margin-bottom: 8px;
            line-height: 1.6;
            color: #374151;
            font-size: 14px;
        }

        .visa-content .content-item ul li::before {
            content: "★";
            color: #fbbf24;
            font-size: 14px;
            position: absolute;
            left: 0;
            top: 0;
        }

        /* Ordered list styling */
        .visa-content .content-item ol {
            margin: 16px 0;
            padding-left: 20px;
            counter-reset: item;
        }

        .visa-content .content-item ol li {
            display: block;
            margin-bottom: 8px;
            padding-left: 15px;
            line-height: 1.6;
            color: #374151;
            font-size: 14px;
            position: relative;
            counter-increment: item;
        }

        .visa-content .content-item ol li::before {
            content: counter(item) ".";
            color: #1e3a8a;
            font-weight: bold;
            position: absolute;
            left: -15px;
            top: 0;
        }

        /* Nested list styling */
        .visa-content .content-item ul ul li::before {
            content: "☆";
            color: #94a3b8;
        }

        /* Strong/Bold text styling */
        .visa-content .content-item strong,
        .visa-content .content-item b {
            color: #1e3a8a;
            font-weight: 600;
        }

        /* Italic text styling */
        .visa-content .content-item em,
        .visa-content .content-item i {
            color: #6b7280;
            font-style: italic;
        }

        /* Link styling */
        .visa-content .content-item a {
            color: #2563eb;
            text-decoration: none;
            border-bottom: 1px solid transparent;
            transition: all 0.2s ease;
        }

        .visa-content .content-item a:hover {
            color: #1d4ed8;
            border-bottom-color: #1d4ed8;
        }

        /* Blockquote styling */
        .visa-content .content-item blockquote {
            border-left: 4px solid #1e3a8a;
            margin: 20px 0;
            padding: 15px 20px;
            background: #f8fafc;
            font-style: italic;
            color: #4b5563;
            border-radius: 0 4px 4px 0;
        }

        /* Table styling (if tables are used) */
        .visa-content .content-item table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 14px;
        }

        .visa-content .content-item table th,
        .visa-content .content-item table td {
            border: 1px solid #e5e7eb;
            padding: 10px;
            text-align: left;
        }

        .visa-content .content-item table th {
            background-color: #1e3a8a;
            color: white;
            font-weight: 600;
        }

        .visa-content .content-item table tr:nth-child(even) {
            background-color: #f9fafb;
        }

        /* Code styling */
        .visa-content .content-item code {
            background-color: #f3f4f6;
            color: #dc2626;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
        }

        /* Pre formatting for code blocks */
        .visa-content .content-item pre {
            background-color: #1f2937;
            color: #f9fafb;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            margin: 20px 0;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4;
        }

        /* Image styling */
        .visa-content .content-item img {
            max-width: 100%;
            height: auto;
            border-radius: 5px;
            margin: 10px 0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        /* HR styling */
        .visa-content .content-item hr {
            border: none;
            height: 2px;
            background: linear-gradient(90deg, #1e3a8a, transparent);
            margin: 25px 0;
        }

        /* Caption styling */
        .visa-content .content-item .wp-caption-text {
            font-size: 12px;
            color: #6b7280;
            font-style: italic;
            text-align: center;
            margin-top: 5px;
        }
    </style>
    <div class="visa-services-panel">
        <div class="visa-sidebar">
            <?php
            $categories = [
                'usa' => ['icon' => 'fas fa-flag-usa', 'label' => 'USA'],
                'canada' => ['icon' => 'fas fa-maple-leaf', 'label' => 'Canada'],
                'uk' => ['icon' => 'fas fa-university', 'label' => 'UK'],
                'schengen' => ['icon' => 'fas fa-globe-europe', 'label' => 'Schengen'],
                'south_africa' => ['icon' => 'fas fa-globe-africa', 'label' => 'South Africa'],
                'india' => ['icon' => 'fas fa-om', 'label' => 'India'],
                'thailand' => ['icon' => 'fas fa-spa', 'label' => 'Thailand'],
                'china' => ['icon' => 'fas fa-dragon', 'label' => 'China'],
            ];

            $first = true;
            foreach ($categories as $key => $cat) {
                echo '<div class="sidebar-item ' . ($first ? 'active' : '') . '" data-tab="' . esc_attr($key) . '">
                        <i class="' . esc_attr($cat['icon']) . '"></i>
                        <span>' . esc_html($cat['label']) . '</span>
                    </div>';
                $first = false;
            }
            ?>
        </div>
        <div class="visa-content">
            <?php
            $first = true;
            foreach ($categories as $key => $cat) {
                $title = $options[$key . '_title'] ?? $cat['label'];
                $content = $options[$key . '_content'] ?? 'Details coming soon...';
                echo '<div id="' . esc_attr($key) . '" class="content-item ' . ($first ? 'active' : '') . '">
                        <a href="https://lwegatech.net/beaute-sauvage-safaris/get-in-touch/" target="_blank" style="display: inline-block; margin-bottom: 15px; padding: 10px 20px; background-color: #1e3a8a; color: white; text-decoration: none; border-radius: 5px; font-weight: bold;">Get in touch with Consultant</a>
                        <h3>' . esc_html($title) . '</h3>
                        ' . wpautop(wp_kses_post($content)) . '
                      </div>';
                $first = false;
            }
            ?>
        </div>
    </div>


    <script>
        jQuery(document).ready(function($) {
            $('.sidebar-item').click(function() {
                $('.sidebar-item').removeClass('active');
                $(this).addClass('active');
                var tab = $(this).data('tab');
                $('.content-item').removeClass('active');
                $('#' + tab).addClass('active');
            });
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('visa_support_services', 'visa_support_services_shortcode');


function visa_services_admin_menu() {
    add_options_page(
        'Visa Support Settings',
        'Visa Services',
        'manage_options',
        'visa-support-settings',
        'visa_services_admin_page'
    );
}
add_action('admin_menu', 'visa_services_admin_menu');

function visa_services_admin_page() {
    ?>
    <div class="wrap">
        <h1>Visa Support Services Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('visa_services_options');
            do_settings_sections('visa-support-settings');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function visa_services_settings_init() {
    register_setting('visa_services_options', 'visa_services_options', 'visa_services_sanitize');

    $categories = [
        'usa' => 'USA',
        'canada' => 'Canada',
        'uk' => 'UK',
        'schengen' => 'Schengen',
        'south_africa' => 'South Africa',
        'india' => 'India',
        'thailand' => 'Thailand',
        'china' => 'China',
    ];

    foreach ($categories as $key => $label) {
        add_settings_section("visa_services_{$key}", $label, null, 'visa-support-settings');

        add_settings_field(
            "{$key}_title",
            'Title',
            'visa_services_text_field',
            'visa-support-settings',
            "visa_services_{$key}",
            ['name' => "{$key}_title", 'default' => $label]
        );

        add_settings_field(
            "{$key}_content",
            'Content',
            'visa_services_editor_field',
            'visa-support-settings',
            "visa_services_{$key}",
            ['name' => "{$key}_content"]
        );
    }
}
add_action('admin_init', 'visa_services_settings_init');

function visa_services_text_field($args) {
    $options = get_option('visa_services_options');
    $value = $options[$args['name']] ?? $args['default'] ?? '';
    echo '<input type="text" class="regular-text" name="visa_services_options[' . $args['name'] . ']" value="' . esc_attr($value) . '">';
}

function visa_services_editor_field($args) {
    $options = get_option('visa_services_options');
    $content = $options[$args['name']] ?? '';
    wp_editor(
        wp_kses_post($content),
        'visa_services_' . $args['name'],
        [
            'textarea_name' => 'visa_services_options[' . $args['name'] . ']',
            'textarea_rows' => 8,
            'media_buttons' => false,
            'teeny' => true
        ]
    );
}

function visa_services_sanitize($input) {
    $sanitized = [];
    foreach ($input as $key => $value) {
        $sanitized[$key] = (strpos($key, 'content') !== false) ? wp_kses_post($value) : sanitize_text_field($value);
    }
    return $sanitized;
}

function visa_support_enqueue_assets() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css');
}
add_action('wp_enqueue_scripts', 'visa_support_enqueue_assets');