<?php
function visa_shortcode() {
    ob_start(); // Start output buffering
    ?>
    
<link rel="stylesheet" href="assets/css/custom.css">
<section class="visa-section" id="visa-countries">
    <div class="visa-container">
        <h2 class="visa-section-title visa-animate">Countries We Cover</h2>
        <div class="visa-countries-grid">
            <div class="visa-country-card"><div class="visa-country-flag">🇺🇸</div><h3 class="visa-country-name">USA</h3><p class="visa-country-desc">Business/Tourist</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇨🇦</div><h3 class="visa-country-name">Canada</h3><p class="visa-country-desc">Visitor/Business</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇬🇧</div><h3 class="visa-country-name">UK</h3><p class="visa-country-desc">Visitor Visa</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇪🇺</div><h3 class="visa-country-name">Schengen</h3><p class="visa-country-desc">26 Countries</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇿🇦</div><h3 class="visa-country-name">S. Africa</h3><p class="visa-country-desc">Business/Tourist</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇮🇳</div><h3 class="visa-country-name">India</h3><p class="visa-country-desc">e-Visas</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇹🇭</div><h3 class="visa-country-name">Thailand</h3><p class="visa-country-desc">Tourist Visa</p></div>
            <div class="visa-country-card"><div class="visa-country-flag">🇨🇳</div><h3 class="visa-country-name">China</h3><p class="visa-country-desc">Business Visa</p></div>
        </div>
    </div>
</section>

    <!-- Services Section -->
  <section class="visa-section" id="visa-services">
    <div class="visa-container">
        <h2 class="visa-section-title visa-animate">Our Visa Services</h2>
        
        <div class="visa-services-grid">
            <!-- Row 1 -->
            <div class="visa-service-card">
                <div class="visa-service-icon">🎯</div>
                <h3 class="visa-service-title">Visa Consultation</h3>
                <div class="visa-service-desc">
                    <p>We evaluate your travel purpose, documents, and destination requirements to identify the optimal visa type for your specific needs.</p>
                </div>
            </div>
            
            <div class="visa-service-card">
                <div class="visa-service-icon">📋</div>
                <h3 class="visa-service-title">Document Review</h3>
                <div class="visa-service-desc">
                    <p>Tailored checklist for each embassy with thorough document review to ensure compliance with all requirements.</p>
                </div>
            </div>
            
            <div class="visa-service-card">
                <div class="visa-service-icon">📝</div>
                <h3 class="visa-service-title">Form Guidance</h3>
                <div class="visa-service-desc">
                    <p>Expert assistance in completing visa forms accurately based on your specific itinerary and travel profile.</p>
                </div>
            </div>
            
            <!-- Row 2 -->
            <div class="visa-service-card">
                <div class="visa-service-icon">📅</div>
                <h3 class="visa-service-title">Appointments</h3>
                <div class="visa-service-desc">
                    <p>We handle embassy appointments, biometric submissions, and visa center visits with optimal scheduling.</p>
                </div>
            </div>
            
            <div class="visa-service-card">
                <div class="visa-service-icon">💬</div>
                <h3 class="visa-service-title">Interview Prep</h3>
                <div class="visa-service-desc">
                    <p>Comprehensive training with sample questions and strategies for US, UK, and other interview-required visas.</p>
                </div>
            </div>
            
            <div class="visa-service-card">
                <div class="visa-service-icon">📊</div>
                <h3 class="visa-service-title">Application Tracking</h3>
                <div class="visa-service-desc">
                    <p>Regular status updates and notification when your passport is ready for collection after processing.</p>
                </div>
            </div>
        </div>
    </div>
</section>

    <script>
        // JavaScript for Visa Sections
        document.addEventListener('DOMContentLoaded', function() {
            // Animation trigger
            const animateElements = document.querySelectorAll('.visa-animate');
            
            const animateOnScroll = function() {
                animateElements.forEach(element => {
                    const elementPosition = element.getBoundingClientRect().top;
                    const windowHeight = window.innerHeight;
                    
                    if (elementPosition < windowHeight - 100) {
                        element.classList.add('visa-animated');
                    }
                });
            };
            
            // Initial check
            animateOnScroll();
            
            // Check on scroll
            window.addEventListener('scroll', animateOnScroll);
            
            // Contact button interaction
            window.handleVisaContact = function() {
                // You can replace this with a modal or form submission
                alert('Thank you for your interest in our visa services!\n\n📧 Email: visas@travelportal.com\n📞 Phone: +256-XXX-XXXXXX\n\nOur visa specialists will contact you within 24 hours to discuss your requirements.');
            };
            
            // Add any other visa-specific JavaScript here
        });
    </script>
    <style>
      .visa-services-panel{display:flex;max-width:1300px;margin:40px auto;background:white;box-shadow:0 10px 40px rgba(0,0,0,0.08);overflow:hidden;}
.visa-sidebar{width:300px;background:linear-gradient(135deg,#1775bb 0%,#084092 100%);padding:100px 0;}
.sidebar-item{color:rgba(255,255,255,0.85);padding:18px 28px;display:flex;align-items:center;cursor:pointer;transition:all 0.3s ease;border-left:5px solid transparent;font-size:17px;margin:4px 0;}
.sidebar-item:hover{background:rgba(255,255,255,0.12);color:white;}
.sidebar-item.active{background:rgba(255,255,255,0.2);color:white;font-weight:bold;border-left:5px solid #e82a2a;}
.sidebar-item i{margin-right:12px;font-size:20px;width:25px;text-align:center;}
.visa-content{flex:1;padding:40px;background:#fff;}
.content-item{display:none;animation:fadeIn 0.5s ease;}
.content-item.active{display:block;}
.content-item h3{color:#1a2e6f;font-size:26px;margin-bottom:20px;}
.content-item p{font-size:16px;color:#444;line-height:1.7;padding-top:15px;}
@keyframes fadeIn{from{opacity:0;transform:translateY(10px);}to{opacity:1;transform:translateY(0);}}
@media(max-width:992px){.visa-services-panel{flex-direction:column;}.visa-sidebar{width:100%;display:flex;flex-wrap:wrap;padding:15px 0;}.sidebar-item{flex:1 1 150px;justify-content:center;border-left:none;border-bottom:4px solid transparent;margin:0;}.sidebar-item.active{border-bottom:4px solid #1a2e6f;}}




/** =========================================================
Visa Content Styles
===============================================================**/

:root{--primary-blue:#1A56B4;--medium-blue:#3B82F6;--light-blue:#93C5FD;--dark-blue:#1E3A8A;--pale-blue:#EFF6FF;--primary-red:#DC2626;--light-red:#FCA5A5;--dark-red:#B91C1C;--text-dark:#1F2937;--text-medium:#4B5563;--text-light:#6B7280;--white:#FFFFFF;--shadow:0 4px 6px rgba(30,58,138,0.1);--shadow-hover:0 6px 12px rgba(30,58,138,0.15);--blue-gradient:linear-gradient(135deg,#1A56B4,#3B82F6);--radius-lg:16px;--radius-md:12px;--radius-sm:8px}
.visa-section{padding:30px 0;position:relative;overflow:hidden;}
.visa-section:nth-child(even){background-color:var(--light-bg);}
.visa-container{max-width:1200px;margin:0 auto;padding:0 20px;position:relative;z-index:2;}
.visa-section-title{font-size:2.5rem;text-align:center;margin-bottom:3rem;color:var(--text-dark);position:relative;font-weight:700;}
.visa-section-title:after{content:'';position:absolute;bottom:-15px;left:50%;transform:translateX(-50%);width:80px;height:4px;background:var(--orange-gradient);border-radius:2px;}
.visa-section-subtitle{text-align:center;color:var(--text-medium);max-width:700px;margin:0 auto 3rem;font-size:1.1rem;line-height:1.6;}
.visa-countries-grid{display:flex;flex-wrap:nowrap;gap:10px;padding:10px 0;justify-content:space-between;width:100%;overflow:hidden;}
.visa-country-card{flex:1;min-width:120px;padding:12px;background:var(--white);border-radius:var(--radius-md);box-shadow:var(--shadow);text-align:center;border:1px solid rgba(255,107,53,0.1);}
.visa-country-flag{font-size:1.8rem;margin-bottom:8px;}
.visa-country-name{font-size:1rem;margin-bottom:4px;color:var(--primary-orange);white-space:nowrap;overflow:hidden;text-overflow:ellipsis;}
.visa-country-desc{font-size:0.7rem;color:var(--text-medium);white-space:nowrap;overflow:hidden;text-overflow:ellipsis;}
@media(max-width:1200px){.visa-country-card{min-width:110px;}}
@media(max-width:992px){.visa-countries-grid{flex-wrap:wrap;justify-content:center;}.visa-country-card{flex:0 0 calc(25% - 10px);margin-bottom:10px;}}
@media(max-width:768px){.visa-country-card{flex:0 0 calc(33.333% - 10px);}}
@media(max-width:576px){.visa-country-card{flex:0 0 calc(50% - 10px);}}


.visa-services-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px; margin: 2.5rem 0; }
.visa-service-card { background: white; padding: 28px 20px; border-radius: 12px; box-shadow: 0 4px 14px rgba(0,0,0,0.08); transition: all 0.4s cubic-bezier(0.25, 0.8, 0.25, 1); text-align: center; position: relative; overflow: hidden; height: 160px; }
.visa-service-icon { font-size: 2.4rem; margin-bottom: 14px; transition: all 0.3s ease; color: #1A56B4; }
.visa-service-title { font-size: 1.2rem; margin: 0 0 8px 0; color: #222; font-weight: 600; transition: all 0.3s ease; }
.visa-service-desc { position: absolute; top: 0; left: 0; width: 100%; height: 100%; padding: 28px 20px; box-sizing: border-box; transition: all 0.4s ease; opacity: 0; display: flex; align-items: center; text-align: center; font-size: 0.95rem; line-height: 1.6; color: #333; background: rgba(234, 242, 253, 0); transform: translateY(10px); }
.visa-service-card:hover { transform: translateY(-6px); box-shadow: 0 12px 24px rgba(0,0,0,0.12); }
.visa-service-card:hover .visa-service-desc { opacity: 1; background: rgba(234, 242, 253, 0.95); transform: translateY(0); }
.visa-service-card:hover .visa-service-icon, .visa-service-card:hover .visa-service-title { opacity: 0; transform: translateY(-15px); }
@media (max-width: 992px) { .visa-services-grid { grid-template-columns: repeat(2, 1fr); } }
@media (max-width: 600px) { .visa-services-grid { grid-template-columns: 1fr; } .visa-service-card { height: 150px; } }



.visa-feature-item{background:var(--white);padding:25px 20px;border-radius:var(--radius-md);box-shadow:var(--shadow);transition:all 0.3s ease;text-align:center;border-top:3px solid transparent;}
.visa-feature-item:hover{transform:translateY(-5px);box-shadow:var(--shadow-hover);border-top-color:var(--primary-orange);}
.visa-feature-icon{font-size:2rem;margin-bottom:1rem;color:var(--primary-orange);}
.visa-feature-title{font-size:1.2rem;margin-bottom:0.5rem;color:var(--text-dark);font-weight:600;}
.visa-feature-desc{color:var(--text-medium);font-size:0.95rem;line-height:1.6;}
.visa-features-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:25px;margin:3rem 0;}
.visa-feature-card{background:var(--white);padding:30px;border-radius:var(--radius-md);box-shadow:var(--shadow);transition:all 0.3s ease;display:flex;align-items:flex-start;gap:20px;border:1px solid rgba(255,107,53,0.1);}
.visa-feature-card:hover{transform:translateY(-5px);box-shadow:var(--shadow-hover);border-color:rgba(255,107,53,0.3);}
.visa-feature-card-icon{color:var(--primary-orange);font-size:2rem;min-width:50px;height:50px;background:rgba(255,107,53,0.1);border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0;}
.visa-feature-card-content h4{font-size:1.3rem;margin-bottom:0.5rem;color:var(--text-dark);}
.visa-feature-card-content p{color:var(--text-medium);line-height:1.6;font-size:0.95rem;}
@keyframes fadeInUp{from{opacity:0;transform:translateY(30px);}to{opacity:1;transform:translateY(0);}}
.visa-animate{opacity:0;animation-fill-mode:forwards;}
.visa-animated{animation:fadeInUp 0.8s ease forwards;}
@media(max-width:992px){.visa-section{padding:60px 0;}.visa-section-title{font-size:2.2rem;}.visa-services-grid{grid-template-columns:repeat(2,1fr);}}
@media(max-width:768px){.visa-section{padding:50px 0;}.visa-section-title{font-size:2rem;margin-bottom:2rem;}.visa-countries-grid,.visa-services-grid,.visa-corporate-features,.visa-features-grid{grid-template-columns:1fr;gap:20px;}.visa-important-note{padding:30px 20px;}.visa-cta-section{padding:70px 0;}.visa-cta-title{font-size:2rem;}}
@media(max-width:480px){.visa-section{padding:40px 0;}.visa-section-title{font-size:1.8rem;}.visa-cta-button{padding:15px 30px;font-size:1.1rem;}}
    </style>

    <?php
    return ob_get_clean(); // Return the buffered content
}
add_shortcode('visa', 'visa_shortcode');

// shortcode for "Why Choose Travel Portal" section
function why_choose_travel_portal_shortcode() {
    ob_start(); // Start output buffering
    ?>
    
    <!-- Features Section -->
    <section class="visa-section">
        <div class="visa-container">
            <h2 class="visa-section-title visa-animate">Why Choose Travel Portal?</h2>
            <p class="visa-section-subtitle visa-animate">Our expertise and personalized approach make the visa process smoother and less stressful</p>
            
            <div class="visa-features-grid">
                <div class="visa-feature-card visa-animate">
                    <div class="visa-feature-card-icon">⭐</div>
                    <div class="visa-feature-card-content">
                        <h4>13+ Years Experience</h4>
                        <p>Over a decade of proven success supporting business and tourist travelers with complex visa requirements.</p>
                    </div>
                </div>
                
                <div class="visa-feature-card visa-animate">
                    <div class="visa-feature-card-icon">🎯</div>
                    <div class="visa-feature-card-content">
                        <h4>Personalized Attention</h4>
                        <p>Country-specific expertise and dedicated support throughout your entire visa application journey.</p>
                    </div>
                </div>
                
                <div class="visa-feature-card visa-animate">
                    <div class="visa-feature-card-icon">💬</div>
                    <div class="visa-feature-card-content">
                        <h4>24/7 Support</h4>
                        <p>Available to answer urgent questions throughout the process with reliable, professional service.</p>
                    </div>
                </div>
                
                <div class="visa-feature-card visa-animate">
                    <div class="visa-feature-card-icon">🔒</div>
                    <div class="visa-feature-card-content">
                        <h4>Confidential Service</h4>
                        <p>Secure handling of all personal and business documents with strict confidentiality protocols.</p>
                    </div>
                </div>
                
                <div class="visa-feature-card visa-animate">
                    <div class="visa-feature-card-icon">📈</div>
                    <div class="visa-feature-card-content">
                        <h4>High Success Rate</h4>
                        <p>Proven track record of successful applications through meticulous preparation.</p>
                    </div>
                </div>
                
                <div class="visa-feature-card visa-animate">
                    <div class="visa-feature-card-icon">⏱️</div>
                    <div class="visa-feature-card-content">
                        <h4>Fast Turnaround</h4>
                        <p>Expedited processing options available for urgent travel requirements.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        // JavaScript for Why Choose Travel Portal section
        document.addEventListener('DOMContentLoaded', function() {
            // Animation trigger
            const animateElements = document.querySelectorAll('.visa-animate');
            
            const animateOnScroll = function() {
                animateElements.forEach(element => {
                    const elementPosition = element.getBoundingClientRect().top;
                    const windowHeight = window.innerHeight;
                    
                    if (elementPosition < windowHeight - 100) {
                        element.classList.add('visa-animated');
                    }
                });
            };
            
            // Initial check
            animateOnScroll();
            
            // Check on scroll
            window.addEventListener('scroll', animateOnScroll);
        });
    </script>
    
    <style>
        /** =========================================================
        Why Choose Travel Portal Styles
        ===============================================================**/

        :root{--primary-blue:#1A56B4;--medium-blue:#3B82F6;--light-blue:#93C5FD;--dark-blue:#1E3A8A;--pale-blue:#EFF6FF;--primary-red:#DC2626;--light-red:#FCA5A5;--dark-red:#B91C1C;--text-dark:#1F2937;--text-medium:#4B5563;--text-light:#6B7280;--white:#FFFFFF;--shadow:0 4px 6px rgba(30,58,138,0.1);--shadow-hover:0 6px 12px rgba(30,58,138,0.15);--blue-gradient:linear-gradient(135deg,#1A56B4,#3B82F6);--radius-lg:16px;--radius-md:12px;--radius-sm:8px}
        .visa-section{padding:30px 0;position:relative;overflow:hidden;}
        .visa-section:nth-child(even){background-color:var(--light-bg);}
        .visa-container{max-width:1200px;margin:0 auto;padding:0 20px;position:relative;z-index:2;}
        .visa-section-title{font-size:2.5rem;text-align:center;margin-bottom:3rem;color:var(--text-dark);position:relative;font-weight:700;}
        .visa-section-title:after{content:'';position:absolute;bottom:-15px;left:50%;transform:translateX(-50%);width:80px;height:4px;background:var(--orange-gradient);border-radius:2px;}
        .visa-section-subtitle{text-align:center;color:var(--text-medium);max-width:700px;margin:0 auto 3rem;font-size:1.1rem;line-height:1.6;}
        .visa-features-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(300px,1fr));gap:25px;margin:3rem 0;}
        .visa-feature-card{background:var(--white);padding:30px;border-radius:var(--radius-md);box-shadow:var(--shadow);transition:all 0.3s ease;display:flex;align-items:flex-start;gap:20px;border:1px solid rgba(255,107,53,0.1);}
        .visa-feature-card:hover{transform:translateY(-5px);box-shadow:var(--shadow-hover);border-color:rgba(255,107,53,0.3);}
        .visa-feature-card-icon{color:var(--primary-orange);font-size:2rem;min-width:50px;height:50px;background:rgba(255,107,53,0.1);border-radius:50%;display:flex;align-items:center;justify-content:center;flex-shrink:0;}
        .visa-feature-card-content h4{font-size:1.3rem;margin-bottom:0.5rem;color:var(--text-dark);}
        .visa-feature-card-content p{color:var(--text-medium);line-height:1.6;font-size:0.95rem;}
        @keyframes fadeInUp{from{opacity:0;transform:translateY(30px);}to{opacity:1;transform:translateY(0);}}
        .visa-animate{opacity:0;animation-fill-mode:forwards;}
        .visa-animated{animation:fadeInUp 0.8s ease forwards;}
        @media(max-width:992px){.visa-section{padding:60px 0;}.visa-section-title{font-size:2.2rem;}}
        @media(max-width:768px){.visa-section{padding:50px 0;}.visa-section-title{font-size:2rem;margin-bottom:2rem;}.visa-features-grid{grid-template-columns:1fr;gap:20px;}}
        @media(max-width:480px){.visa-section{padding:40px 0;}.visa-section-title{font-size:1.8rem;}}
    </style>

    <?php
    return ob_get_clean(); // Return the buffered content
}
add_shortcode('why_choose_travel_portal', 'why_choose_travel_portal_shortcode');
?>