<?php
// Register Testimonial Taxonomy
function register_testimonial_taxonomy() {
    $labels = array(
        'name' => 'Testimonial Categories',
        'singular_name' => 'Testimonial Category',
        'search_items' => 'Search Categories',
        'all_items' => 'All Categories',
        'parent_item' => 'Parent Category',
        'parent_item_colon' => 'Parent Category:',
        'edit_item' => 'Edit Category',
        'update_item' => 'Update Category',
        'add_new_item' => 'Add New Category',
        'new_item_name' => 'New Category Name',
        'menu_name' => 'Categories',
    );

    register_taxonomy('testimonial_category', array('testimonial'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'testimonial-category'),
    ));
}
add_action('init', 'register_testimonial_taxonomy');

// Register Testimonial Custom Post Type
function register_testimonial_post_type() {
    $args = array(
        'public' => true,
        'label'  => 'Testimonials',
        'menu_icon' => 'dashicons-testimonial',
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt'),
        'has_archive' => true,
        'taxonomies' => array('testimonial_category'),
    );
    register_post_type('testimonial', $args);
}
add_action('init', 'register_testimonial_post_type');



// Testimonials Shortcode
function testimonials_shortcode($atts) {
    $atts = shortcode_atts(array(
        'category' => '',
        'limit' => -1,
        'interval' => 3000,
        'show_rating' => false,
        'randomize' => false
    ), $atts);
    
    $args = array(
        'post_type' => 'testimonial',
        'posts_per_page' => $atts['limit'],
        'orderby' => $atts['randomize'] ? 'rand' : 'date'
    );

    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'testimonial_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $testimonials = new WP_Query($args);
    $testimonials_count = $testimonials->post_count;

    ob_start();
    
    if ($testimonials->have_posts()) :
        echo '<div class="testimonial-carousel" data-interval="' . $atts['interval'] . '">
            <div class="testimonial-title">
                <h2>Traveler Insights</h2>
            </div>
            <div class="testimonial-container">';
        $index = 0;
        while ($testimonials->have_posts()) : $testimonials->the_post();
            $author = get_the_title();
            $content = get_the_content();
            $thumbnail = get_the_post_thumbnail(get_the_ID(), 'large');
            $rating = $atts['show_rating'] ? get_post_meta(get_the_ID(), 'testimonial_rating', true) : 0;
            $position = get_post_meta(get_the_ID(), 'testimonial_position', true);
            $company = get_post_meta(get_the_ID(), 'testimonial_company', true);
            ?>
            <div class="testimonial-slide <?php echo $index === 0 ? 'active' : ''; ?>" data-index="<?php echo $index; ?>">
                <div class="testimonial-image-col">
                    <?php if ($thumbnail) : ?>
                        <div class="testimonial-image">
                            <?php echo $thumbnail; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="testimonial-content-col">
                    <div class="testimonial-content">
                        <?php echo wpautop($content); ?>
                    </div>
                    
                    <?php if ($rating && $atts['show_rating']) : ?>
                        <div class="testimonial-rating">
                            <?php for ($i = 1; $i <= 5; $i++) : ?>
                                <span class="testimonial-star <?php echo $i <= $rating ? 'filled' : ''; ?>">★</span>
                            <?php endfor; ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="testimonial-author"><?php echo esc_html($author); ?></div>
                    
                    <?php if ($position || $company) : ?>
                        <div class="testimonial-position">
                            <?php echo esc_html($position); ?>
                            <?php if ($position && $company) echo ', '; ?>
                            <?php if ($company) echo esc_html($company); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php
            $index++;
        endwhile;
        echo '</div></div>';
        
        // JavaScript for carousel functionality
        echo '<script>
        (function() {
            function initCarousel() {
                const carousel = document.querySelector(".testimonial-carousel");
                if (!carousel) return;
                
                const slides = carousel.querySelectorAll(".testimonial-slide");
                const interval = parseInt(carousel.dataset.interval) || 3000;
                let currentIndex = 0;
                let carouselInterval;
                
                if (slides.length <= 1) return;
                
                function showSlide(index) {
                    // Hide all slides
                    slides.forEach(slide => slide.classList.remove("active"));
                    
                    // Show target slide
                    slides[index].classList.add("active");
                    currentIndex = index;
                }
                
                function showNextSlide() {
                    const nextIndex = (currentIndex + 1) % slides.length;
                    showSlide(nextIndex);
                }
                
                function startCarousel() {
                    if (carouselInterval) clearInterval(carouselInterval);
                    carouselInterval = setInterval(showNextSlide, interval);
                }
                
                function stopCarousel() {
                    if (carouselInterval) {
                        clearInterval(carouselInterval);
                        carouselInterval = null;
                    }
                }
                
                // Touch support
                let touchStartX = 0;
                let touchEndX = 0;
                
                carousel.addEventListener("touchstart", function(e) {
                    touchStartX = e.touches[0].clientX;
                    stopCarousel();
                }, { passive: true });
                
                carousel.addEventListener("touchend", function(e) {
                    touchEndX = e.changedTouches[0].clientX;
                    const swipeDistance = touchEndX - touchStartX;
                    
                    if (Math.abs(swipeDistance) > 50) {
                        if (swipeDistance > 0) {
                            const prevIndex = (currentIndex - 1 + slides.length) % slides.length;
                            showSlide(prevIndex);
                        } else {
                            showNextSlide();
                        }
                    }
                    
                    setTimeout(startCarousel, 2000);
                }, { passive: true });
                
                // Pause on hover
                carousel.addEventListener("mouseenter", stopCarousel);
                carousel.addEventListener("mouseleave", startCarousel);
                
                // Start immediately
                startCarousel();
            }
            
            // Initialize immediately if DOM is ready
            if (document.readyState === "loading") {
                document.addEventListener("DOMContentLoaded", initCarousel);
            } else {
                initCarousel();
            }
        })();
        </script>';
    else:
        echo '<p class="no-testimonials">No testimonials found.</p>';
    endif;

    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('testimonial_carousel', 'testimonials_shortcode');
?>