<?php
// Get current page for active menu highlighting
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Menu configuration
$desktop_menu_items = array(
    'about-us' => array(
        'title' => 'About Us',
        'url' => '#', // Changed to # to make non-clickable
        'children' => array(
            'overview' => array('title' => 'Overview', 'url' => home_url('/about-us/overview')),
            'affiliations' => array('title' => 'Affiliations', 'url' => home_url('/about-us/affiliations'))
        )
    ),
    'destinations' => array(
        'title' => 'DESTINATIONS',
        'url' => '#', // Changed to # to make non-clickable
        'children' => array(
            'uganda' => array('title' => 'Uganda', 'url' => home_url('/destinations/uganda')),
            'dubai' => array('title' => 'Dubai', 'url' => home_url('/destinations/dubai'))
        )
    ),
    'packages' => array('title' => 'PACKAGES', 'url' => home_url('/packages')),
    'honeymoon' => array('title' => 'HONEYMOON PACKAGES', 'url' => home_url('/honeymoon-packages')),
    'travel' => array('title' => 'TRAVEL MANAGEMENT', 'url' => home_url('/travel-management')),
    'visa' => array('title' => 'VISA SUPPORT', 'url' => home_url('/visa-support')),
    'contact' => array('title' => 'GET IN TOUCH', 'url' => home_url('/contact'))
);

$mobile_menu_items = array_merge(
    array('home' => array('title' => 'HOME', 'url' => home_url('/'))),
    $desktop_menu_items
);
?>

<!-- Top Info Bar -->
<div class="top-header d-none d-md-block">
    <div class="top-info-container">
        <!-- Left - Contact Info -->
        <div class="top-left-contact">
            <a href="tel:+256770506083" class="top-contact-item">
                <i class="bi bi-telephone-fill"></i>
                <span>+256 770506083</span>
            </a>
            <a href="mailto:info@bss.com" class="top-contact-item">
                <i class="bi bi-envelope-fill"></i>
                <span>info@bss.com</span>
            </a>
            <a href="https://wa.me/256705143550" class="top-contact-item">
                <i class="bi bi-whatsapp"></i>
                <span>+256 705143550</span>
            </a>
        </div>

        <!-- Right - Social Links -->
        <div class="top-right-social">
            <span class="social-text">Our Socials</span>
            <div class="top-social-links">
                <a href="#" class="top-social-link" title="Facebook">
                    <i class="bi bi-facebook"></i>
                </a>
                <a href="#" class="top-social-link" title="Twitter">
                    <i class="bi bi-twitter"></i>
                </a>
                <a href="#" class="top-social-link" title="YouTube">
                    <i class="bi bi-youtube"></i>
                </a>
                <a href="#" class="top-social-link" title="Instagram">
                    <i class="bi bi-instagram"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Main Header -->
<div class="main-header">
    <div class="header-container">
        <!-- Logo Section - Left -->
        <div class="logo-section">
            <?php
                $custom_logo_id = get_theme_mod('custom_logo');
                $logo_url = wp_get_attachment_image_src($custom_logo_id, 'full');
                if ($logo_url) {
                    echo '<a href="' . esc_url(home_url('/')) . '"><img src="' . esc_url($logo_url[0]) . '" class="img-fluid logo" alt="' . get_bloginfo('name') . '"></a>';
                } else {
                    echo '<a href="' . esc_url(home_url('/')) . '"><h1>' . get_bloginfo('name') . '</h1></a>';
                }
            ?>
        </div>

        <!-- Navigation Section - Center -->
        <div class="navigation-section d-none d-lg-block">
            <nav class="main-nav">
                <?php if (has_nav_menu('main-menu')): ?>
                    <?php wp_nav_menu(array(
                        'theme_location' => 'main-menu',
                        'container' => false,
                        'menu_class' => 'navbar-nav',
                        'fallback_cb' => false,
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        'depth' => 2,
                        'walker' => new Desktop_Menu_Walker()
                    )); ?>
                <?php else: ?>
                    <ul class="navbar-nav">
                        <?php foreach ($desktop_menu_items as $key => $item): ?>
                            <li class="nav-item <?php echo !empty($item['children']) ? 'custom-dropdown' : ''; ?>">
                                <a class="nav-link <?php echo !empty($item['children']) ? 'dropdown-parent' : ''; ?>" href="<?php echo esc_url($item['url']); ?>" <?php echo !empty($item['children']) ? 'onclick="return false;"' : ''; ?>>
                                    <?php echo esc_html($item['title']); ?>
                                    <?php if (!empty($item['children'])): ?>
                                        <i class="bi bi-chevron-down dropdown-arrow"></i>
                                    <?php endif; ?>
                                </a>
                                <?php if (!empty($item['children'])): ?>
                                    <ul class="custom-dropdown-menu">
                                        <?php foreach ($item['children'] as $child_key => $child): ?>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo esc_url($child['url']); ?>">
                                                    <?php echo esc_html($child['title']); ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </nav>
        </div>

        <!-- Mobile Menu Toggle -->
        <button class="mobile-menu-toggle d-lg-none" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960" fill="currentColor">
                <path d="M120-240v-80h720v80H120Zm0-200v-80h720v80H120Zm0-200v-80h720v80H120Z"/>
            </svg>
        </button>
    </div>
</div>

<!-- Mobile Offcanvas Menu -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="offcanvasNavbarLabel">Menu</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <nav class="mobile-nav">
            <?php if (has_nav_menu('main-menu')): ?>
                <?php wp_nav_menu(array(
                    'theme_location' => 'main-menu',
                    'container' => false,
                    'menu_class' => '',
                    'fallback_cb' => false,
                    'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                    'depth' => 2,
                    'walker' => new Mobile_Menu_Walker()
                )); ?>
            <?php else: ?>
                <ul class="navbar-nav flex-column">
                    <?php foreach ($mobile_menu_items as $key => $item): ?>
                        <li class="nav-item <?php echo !empty($item['children']) ? 'dropdown mobile-dropdown menu-item-has-children' : ''; ?>">
                            <a class="nav-link <?php echo !empty($item['children']) ? 'mobile-dropdown-toggle' : ''; ?>" href="<?php echo esc_url($item['url']); ?>">
                                <?php echo esc_html($item['title']); ?>
                                <?php if (!empty($item['children'])): ?>
                                    <i class="bi bi-chevron-down mobile-dropdown-arrow"></i>
                                <?php endif; ?>
                            </a>
                            <?php if (!empty($item['children'])): ?>
                                <ul class="dropdown-menu mobile-dropdown-menu">
                                    <?php foreach ($item['children'] as $child_key => $child): ?>
                                        <li>
                                            <a class="dropdown-item" href="<?php echo esc_url($child['url']); ?>">
                                                <?php echo esc_html($child['title']); ?>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </nav>
        
        <!-- Mobile Book Now Button -->
        <div class="mobile-book-now">
            <a href="<?php echo esc_url(home_url('https://lwegatech.net/beaute-sauvage-safaris/get-in-touch/')); ?>" class="btn btn-book-now">
                BOOK YOUR TRIP
            </a>
        </div>
    </div>
</div>

<?php
// Desktop Menu Walker to ensure proper classes
class Desktop_Menu_Walker extends Walker_Nav_Menu {
    function start_lvl(&$output, $depth = 0, $args = null) {
        $output .= '<ul class="dropdown-menu">';
    }

    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = 'nav-item';
        
        if (in_array('menu-item-has-children', $classes)) {
            $classes[] = 'dropdown';
            $classes[] = 'hover-dropdown';
        }
        
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
        
        $output .= '<li' . $class_names . '>';
        
        $attributes = '';
        $attributes .= !empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) . '"' : '';
        $attributes .= !empty($item->target) ? ' target="' . esc_attr($item->target) . '"' : '';
        $attributes .= !empty($item->xfn) ? ' rel="' . esc_attr($item->xfn) . '"' : '';
        $attributes .= !empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
        
        $item_output = $args->before ?? '';
        $link_class = 'nav-link';
        $onclick_attr = '';
        
        // Check if item has children to make it non-clickable and add arrow
        if (in_array('menu-item-has-children', $classes)) {
            $link_class .= ' dropdown-parent';
            $onclick_attr = ' onclick="return false;"';
            $attributes = str_replace($item->url, '#', $attributes); // Replace URL with #
        }
        
        $item_output .= '<a class="' . $link_class . '"' . $attributes . $onclick_attr . '>';
        $item_output .= ($args->link_before ?? '') . apply_filters('the_title', $item->title, $item->ID) . ($args->link_after ?? '');
        
        // Add dropdown arrow for items with children
        if (in_array('menu-item-has-children', $classes)) {
            $item_output .= '<i class="bi bi-chevron-down dropdown-arrow"></i>';
        }
        
        $item_output .= '</a>';
        $item_output .= $args->after ?? '';
        
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
}

// Mobile Menu Walker (keeps mobile functionality)
class Mobile_Menu_Walker extends Walker_Nav_Menu {
    function start_lvl(&$output, $depth = 0, $args = null) {
        $output .= '<ul class="dropdown-menu mobile-dropdown-menu" style="display: none;">';
    }

    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = 'nav-item';
        
        if (in_array('menu-item-has-children', $classes)) {
            $classes[] = 'dropdown';
            $classes[] = 'mobile-dropdown';
        }
        
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
        
        $output .= '<li' . $class_names . '>';
        
        $attributes = '';
        $attributes .= !empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) . '"' : '';
        $attributes .= !empty($item->target) ? ' target="' . esc_attr($item->target) . '"' : '';
        $attributes .= !empty($item->xfn) ? ' rel="' . esc_attr($item->xfn) . '"' : '';
        $attributes .= !empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
        
        $item_output = $args->before ?? '';
        // Add mobile-dropdown-toggle class for items with children
        $link_class = 'nav-link' . (in_array('menu-item-has-children', $classes) ? ' mobile-dropdown-toggle' : '');
        $item_output .= '<a class="' . $link_class . '"' . $attributes . '>';
        $item_output .= ($args->link_before ?? '') . apply_filters('the_title', $item->title, $item->ID) . ($args->link_after ?? '');
        
        // Add dropdown arrow for items with children in mobile
        if (in_array('menu-item-has-children', $classes)) {
            $item_output .= '<i class="bi bi-chevron-down mobile-dropdown-arrow"></i>';
        }
        
        $item_output .= '</a>';
        $item_output .= $args->after ?? '';
        
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
}

?>



















<style>
    /* ================== MOBILE MENU STYLES ================== */

/* Unique Animated Hamburger Menu - Circular Design */
.mobile-menu-toggle { background: #1e3a8a !important; color: #fff !important; border: 2px solid #1e3a8a !important; border-radius: 50%; padding: 12px; font-size: 18px; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; position: relative; overflow: hidden; box-shadow: 0 4px 12px rgba(30, 58, 138, 0.3); }

.mobile-menu-toggle:hover { background: #1e40af !important; border-color: #1e40af !important; transform: scale(1.1) rotate(180deg); box-shadow: 0 6px 20px rgba(30, 58, 138, 0.4); }

.mobile-menu-toggle:focus { outline: none; box-shadow: 0 0 0 3px rgba(30, 58, 138, 0.3), 0 4px 12px rgba(30, 58, 138, 0.3); }

.mobile-menu-toggle svg { width: 22px; height: 22px; transition: all 0.3s ease; }

.mobile-menu-toggle:hover svg { transform: rotate(-180deg); }

.mobile-menu-toggle.active { transform: scale(1.1) rotate(360deg); background: #dc2626 !important; border-color: #dc2626 !important; }

.mobile-menu-toggle.active svg { transform: rotate(180deg) scale(0.8); }

/* Bootstrap Offcanvas Customization */
.offcanvas { background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); border: none; box-shadow: -10px 0 30px rgba(0, 0, 0, 0.15); }

.offcanvas-header { background: #1e3a8a; color: #fff; padding: 20px 25px; border-bottom: 3px solid #fbbf24; position: relative; }

.offcanvas-header::after { content: ''; position: absolute; bottom: -3px; left: 0; width: 100%; height: 3px; background: linear-gradient(90deg, #fbbf24, #f59e0b, #fbbf24); }

.offcanvas-title { font-size: 20px; font-weight: 600; color: #fff; margin: 0; }

.btn-close { background: transparent; border: none; color: #fff; font-size: 18px; padding: 8px; border-radius: 50%; transition: all 0.3s ease; opacity: 1; }

.btn-close:hover { background: rgba(255, 255, 255, 0.2); transform: rotate(90deg); }

.offcanvas-body { padding: 25px; }

/* Mobile Navigation Styling */
.mobile-nav .navbar-nav { display: flex !important; flex-direction: column !important; gap: 0; padding: 0; margin: 0; list-style: none; }

.mobile-nav .nav-item { border-bottom: 1px solid rgba(30, 58, 138, 0.1); margin: 0; transition: all 0.3s ease; }

.mobile-nav .nav-item:last-child { border-bottom: none; }

.mobile-nav .nav-item:hover { background: rgba(30, 58, 138, 0.05); border-radius: 8px; margin: 2px 0; }

.mobile-nav .nav-link { color: #1e3a8a !important; text-decoration: none; font-weight: 500; font-size: 16px; padding: 18px 15px; display: block; width: 100%; border-radius: 8px; margin: 0; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); position: relative; }

.mobile-nav .nav-link::before { content: ''; position: absolute; left: 0; top: 50%; transform: translateY(-50%); width: 4px; height: 0; background: #fbbf24; transition: height 0.3s ease; border-radius: 2px; }

.mobile-nav .nav-link:hover { color: #fff !important; background: linear-gradient(135deg, #1e3a8a, #1e40af) !important; padding: 18px 15px 18px 25px !important; transform: translateX(5px); box-shadow: 0 4px 15px rgba(30, 58, 138, 0.3); }

.mobile-nav .nav-link:hover::before { height: 60%; }

/* Mobile Dropdown Styles */
.mobile-nav .dropdown { position: relative; }

.mobile-nav .mobile-dropdown-toggle::after { content: '▼'; float: right; font-size: 12px; color: #64748b; transition: all 0.3s ease; }

.mobile-nav .dropdown.active .mobile-dropdown-toggle::after { transform: rotate(180deg); color: #fbbf24; }

.mobile-nav .dropdown-menu { position: static; display: none; width: 100%; background: rgba(248, 250, 252, 0.8); box-shadow: inset 0 2px 10px rgba(30, 58, 138, 0.1); border: none; border-radius: 8px; padding: 10px 0; margin: 8px 0 8px 20px; opacity: 1; visibility: visible; transform: none; backdrop-filter: blur(10px); }

.mobile-nav .dropdown.active .dropdown-menu { display: block; animation: slideDown 0.4s cubic-bezier(0.4, 0, 0.2, 1) forwards; }

.mobile-nav .dropdown-item { color: #475569 !important; padding: 12px 20px; font-size: 14px; border-bottom: none; width: 100%; margin: 0; border-radius: 6px; transition: all 0.3s ease; position: relative; }

.mobile-nav .dropdown-item::before { content: '→'; position: absolute; left: 8px; opacity: 0; transition: all 0.3s ease; color: #fbbf24; }

.mobile-nav .dropdown-item:hover { color: #fff !important; background: linear-gradient(135deg, #fbbf24, #f59e0b) !important; margin: 2px 8px; transform: translateX(5px); padding-left: 28px !important; }

.mobile-nav .dropdown-item:hover::before { opacity: 1; left: 12px; }

/* Mobile Book Now Button */
.mobile-book-now { padding: 25px 0 15px; border-top: 2px solid rgba(30, 58, 138, 0.1); margin-top: 25px; }

.btn-book-now { background: linear-gradient(135deg, #fbbf24, #f59e0b); border: none; color: #1e3a8a; font-weight: 600; font-size: 16px; padding: 15px 30px; border-radius: 25px; width: 100%; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); text-transform: uppercase; letter-spacing: 1px; box-shadow: 0 4px 15px rgba(251, 191, 36, 0.3); }

.btn-book-now:hover { background: linear-gradient(135deg, #f59e0b, #fbbf24); color: #1e3a8a; transform: translateY(-3px); box-shadow: 0 8px 25px rgba(251, 191, 36, 0.4); }

/* Animation for dropdown */
@keyframes slideDown { from { opacity: 0; transform: translateY(-10px) scaleY(0.8); } to { opacity: 1; transform: translateY(0) scaleY(1); } }

/* Animation for menu opening */
@keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }

.offcanvas.show .mobile-nav .nav-item { animation: fadeInUp 0.5s ease forwards; }
.offcanvas.show .mobile-nav .nav-item:nth-child(1) { animation-delay: 0.1s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(2) { animation-delay: 0.15s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(3) { animation-delay: 0.2s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(4) { animation-delay: 0.25s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(5) { animation-delay: 0.3s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(6) { animation-delay: 0.35s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(7) { animation-delay: 0.4s; }
.offcanvas.show .mobile-nav .nav-item:nth-child(8) { animation-delay: 0.45s; }
</style>


<script>
// Sticky header effect
let lastScrollTop = 0;
window.addEventListener('scroll', function() {
    const currentScroll = window.pageYOffset || document.documentElement.scrollTop;
    const header = document.querySelector('.main-header').parentElement;
    
    if (currentScroll > 50) {
        header.classList.add('header-sticky');
    } else {
        header.classList.remove('header-sticky');
    }
    
    lastScrollTop = currentScroll <= 0 ? 0 : currentScroll;
}, false);

// Active menu item highlighting
document.addEventListener('DOMContentLoaded', function() {
    const currentUrl = window.location.pathname;
    const menuItems = document.querySelectorAll('.navbar-nav .nav-link, .mobile-nav .nav-link');
    
    menuItems.forEach(item => {
        const href = item.getAttribute('href');
        if (href) {
            if (href === currentUrl || 
                (href !== '/' && currentUrl.includes(href.replace(/^.*\//, ''))) ||
                (href === home_url && (currentUrl === '/' || currentUrl === ''))) {
                item.classList.add('active');
            }
        }
    });
});

// Enhanced dropdown functionality - SIMPLIFIED AND FIXED
document.addEventListener('DOMContentLoaded', function() {
    // Remove Bootstrap dropdown interference completely
    document.querySelectorAll('[data-bs-toggle="dropdown"]').forEach(element => {
        element.removeAttribute('data-bs-toggle');
        element.removeAttribute('data-bs-auto-close');
        element.removeAttribute('role');
        element.removeAttribute('aria-expanded');
        element.classList.remove('dropdown-toggle');
    });
    
    // Ensure all dropdown items have the right classes
    document.querySelectorAll('.navbar-nav .nav-item').forEach(item => {
        const link = item.querySelector('.nav-link');
        const hasChildren = item.classList.contains('menu-item-has-children') || 
                           item.classList.contains('dropdown') ||
                           item.querySelector('.dropdown-menu, .sub-menu');
        
        if (hasChildren) {
            item.classList.add('dropdown', 'hover-dropdown');
            const subMenu = item.querySelector('.sub-menu');
            if (subMenu) {
                subMenu.classList.add('dropdown-menu');
            }
        }
    });
    
    // Force show dropdowns on hover with JavaScript backup
    document.querySelectorAll('.navbar-nav .dropdown, .navbar-nav .hover-dropdown').forEach(item => {
        const dropdown = item.querySelector('.dropdown-menu');
        
        if (dropdown) {
            item.addEventListener('mouseenter', function() {
                dropdown.style.opacity = '1';
                dropdown.style.visibility = 'visible';
                dropdown.style.transform = 'translateY(0) translateX(-50%)';
                dropdown.style.display = 'block';
            });
            
            item.addEventListener('mouseleave', function() {
                dropdown.style.opacity = '0';
                dropdown.style.visibility = 'hidden';
                dropdown.style.transform = 'translateY(10px) translateX(-50%)';
                setTimeout(() => {
                    if (dropdown.style.opacity === '0') {
                        dropdown.style.display = 'none';
                    }
                }, 300);
            });
        }
    });
});

// Mobile dropdown toggle functionality
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.mobile-dropdown-toggle').forEach(toggle => {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            const parent = this.parentElement;
            const menu = parent.querySelector('.mobile-dropdown-menu');
            
            if (menu) {
                const isVisible = menu.style.display === 'block';
                
                // Hide all other open dropdowns
                document.querySelectorAll('.mobile-dropdown-menu').forEach(m => {
                    m.style.display = 'none';
                    m.parentElement.classList.remove('active');
                });
                
                // Toggle current dropdown
                if (!isVisible) {
                    menu.style.display = 'block';
                    parent.classList.add('active');
                } else {
                    menu.style.display = 'none';
                    parent.classList.remove('active');
                }
            }
        });
    });
});

// Close mobile menu when clicking a link (not dropdown toggle)
document.querySelectorAll('.mobile-nav a:not(.mobile-dropdown-toggle)').forEach(link => {
    link.addEventListener('click', function(e) {
        const offcanvas = document.querySelector('#offcanvasNavbar');
        if (typeof bootstrap !== 'undefined') {
            const bsOffcanvas = bootstrap.Offcanvas.getInstance(offcanvas);
            if (bsOffcanvas) {
                bsOffcanvas.hide();
            }
        }
    });
});
</script>