<?php
/**
 * Custom Post Types and Taxonomies
 */

add_action('init', 'travel_register_post_types');

function travel_register_post_types() {
    // Destinations Post Type
    register_post_type('destination', [
        'labels' => [
            'name' => 'Destinations',
            'singular_name' => 'Destination'
        ],
        'public' => true,
        'has_archive' => true,
        'rewrite' => ['slug' => 'destinations'],
        'supports' => ['title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'],
        'menu_icon' => 'dashicons-location-alt',
        'show_in_rest' => true,
    ]);

    // Packages Post Type
    register_post_type('package', [
        'labels' => [
            'name' => 'Packages',
            'singular_name' => 'Package'
        ],
        'public' => true,
        'has_archive' => true,
        'rewrite' => ['slug' => 'packages'],
        'supports' => ['title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'],
        'menu_icon' => 'dashicons-palmtree',
        'show_in_rest' => true,
    ]);

    // Register Taxonomies
    register_taxonomy('destination_country', 'destination', [
        'label' => 'Countries',
        'hierarchical' => true,
        'rewrite' => ['slug' => 'destination-country'],
        'show_in_rest' => true,
    ]);

    register_taxonomy('package_type', 'package', [
        'label' => 'Package Types',
        'hierarchical' => true,
        'rewrite' => ['slug' => 'package-type'],
        'show_in_rest' => true,
    ]);

    register_taxonomy('activity', ['destination', 'package'], [
        'label' => 'Activities',
        'hierarchical' => false,
        'rewrite' => ['slug' => 'activity'],
        'show_in_rest' => true,
    ]);

    register_taxonomy('package_size', 'package', [
        'label' => 'Package Sizes',
        'hierarchical' => true,
        'show_in_rest' => true,
    ]);
}