<?php

/**
 * Shortcode to display Contact Form for Beaut Sauvage Safaris
 */

function contact_inquiry_form_shortcode() {
    ob_start();
    
    // Get current page data for hero section
    $title = get_the_title();
    $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
    $subtitle = get_the_excerpt();
    ?>

    <!-- Hero Section from page.php -->
    <section class="parallax-hero full-width">
        <div class="parallax-bg" style="background-image: url('<?php echo $backgroundImg[0] ? $backgroundImg[0] : get_template_directory_uri() . '/assets/images/default-hero.jpg'; ?>');" id="contact-parallax-bg"></div>
        
        <div class="hero-overlay"></div>
        
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="hero-content">
                        <h1 class="hero-title fade-up"><?php echo esc_html($title); ?></h1>
                        
                        <?php if (!empty($subtitle)): ?>
                            <p class="hero-subtitle fade-up delay-1"><?php echo esc_html($subtitle); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="hero-curve">
            <svg viewBox="0 0 1440 80" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
                <path fill="white" d="M0,80 C240,0 480,80 720,40 C960,0 1200,80 1440,20 L1440,80 L0,80 Z"></path>
            </svg>
        </div>
    </section>

    <?php
    // Honeypot Field (hidden from real users)
    $honeypot = '<input type="text" name="company_name" style="display:none">';

    // Handle Form Submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['contact_inquiry_submit'])) {
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $form_time = $_POST['form_time'] ?? time();
        $current_time = time();

        // Simple rate limit: 1 submission per 60 seconds
        if (($current_time - intval($form_time)) < 60) {
            echo '<div class="safari-alert safari-alert-danger">Please wait before submitting again.</div>';
        } elseif (!empty($_POST['company_name'])) {
            echo '<div class="safari-alert safari-alert-danger">Spam detected.</div>';
        } else {
            $full_name = sanitize_text_field($_POST['full_name']);
            $inquiry_type = sanitize_text_field($_POST['inquiry_type']);
            $phone = sanitize_text_field($_POST['phone']);
            $email = sanitize_email($_POST['email']);
            $address = sanitize_text_field($_POST['address']);
            $message = sanitize_text_field($_POST['message']);

            // Save submission as a custom post type
            $post_id = wp_insert_post([
                'post_title' => $full_name . ' - ' . $inquiry_type,
                'post_type' => 'contact_inquiry',
                'post_status' => 'publish',
                'meta_input' => compact('full_name', 'inquiry_type', 'phone', 'email', 'address', 'message')
            ]);

            // Send Email Notification
            $to = 'info@beautesauvagesafaris.com';
            $subject = 'New Safari Inquiry - Beaut Sauvage Safaris';
            $message = "New Safari Inquiry received:\n\nName: $full_name\nInquiry Type: $inquiry_type\nPhone: $phone\nEmail: $email\nAddress: $address\n\nMessage:\n $message";
            wp_mail($to, $subject, $message);

            echo '<div class="safari-alert safari-alert-success">Thank you for your inquiry! We\'ll get back to you within 24 hours to plan your perfect safari adventure.</div>';
        }
    }
    ?> 
    
    <!--Contact Section - Modified to be full width -->
    <div class="grace-contact-wrapper" style="max-width: 100%;">
        <div class="grace-contact-container" style="max-width: 100%; margin: 0;">
            
            <!-- Left Side - Contact Info -->
            <div class="grace-contact-left">
                <div class="grace-contact-header">
                    <h1 class="grace-contact-title">Contact Us</h1>
                    <p class="grace-contact-description">
                        Ready to embark on your dream safari adventure? Get in touch with us today to start planning your unforgettable journey through Uganda's magnificent wilderness.
                    </p>
                </div>
                
                <div class="grace-contact-details">
                    <div class="grace-contact-item">
                        <div class="grace-contact-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="12" cy="10" r="3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="grace-contact-info">
                            <h4>Office</h4>
                            <p>Plot 1900, Ntinda Kisakye Shopping Center,<br>
                            Office F1, Ground Floor,<br>
                            Kampala, Uganda.</p>
                        </div>
                    </div>
                    
                    <div class="grace-contact-item">
                        <div class="grace-contact-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="grace-contact-info">
                            <h4>Phone</h4>
                            <p>+256 771 456146</p>
                        </div>
                    </div>
                    
                    <div class="grace-contact-item">
                        <div class="grace-contact-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <polyline points="22,6 12,13 2,6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="grace-contact-info">
                            <h4>Email</h4>
                            <p>info@beautesauvagesafaris.com</p>
                        </div>
                    </div>
                </div>
                
                <div class="grace-social-links">
                    <h4>Follow me</h4>
                    <div class="grace-social-icons">
                        <a href="#" class="grace-social-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                            </svg>
                        </a>
                        <a href="#" class="grace-social-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M22.46 6c-.77.35-1.6.58-2.46.69.88-.53 1.56-1.37 1.88-2.38-.83.5-1.75.85-2.72 1.05C18.37 4.5 17.26 4 16 4c-2.35 0-4.27 1.92-4.27 4.29 0 .34.04.67.11.98C8.28 9.09 5.11 7.38 3 4.79c-.37.63-.58 1.37-.58 2.15 0 1.49.75 2.81 1.91 3.56-.71 0-1.37-.2-1.95-.5v.03c0 2.08 1.48 3.82 3.44 4.21a4.22 4.22 0 0 1-1.93.07 4.28 4.28 0 0 0 4 2.98 8.521 8.521 0 0 1-5.33 1.84c-.34 0-.68-.02-1.02-.06C3.44 20.29 5.7 21 8.12 21 16 21 20.33 14.46 20.33 8.79c0-.19 0-.37-.01-.56.84-.6 1.56-1.36 2.14-2.23z"/>
                            </svg>
                        </a>
                        <a href="#" class="grace-social-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        <a href="#" class="grace-social-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zM12 0C8.741 0 8.333.014 7.053.072 2.695.272.273 2.69.073 7.052.014 8.333 0 8.741 0 12c0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98C15.668.014 15.259 0 12 0zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zM12 16c-2.209 0-4-1.79-4-4s1.791-4 4-4 4 1.791 4 4-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Right Side - Contact Form with Background -->
            <div class="grace-contact-right">
                <div class="grace-form-background"></div>
                <div class="grace-form-container">
                    <div class="grace-form-header">
                        <h2>Send a message</h2>
                    </div>
                    
                    <form method="post" class="grace-contact-form">
                        <?php echo $honeypot; ?>
                        <input type="hidden" name="form_time" value="<?php echo time(); ?>">
                        
                        <div class="grace-form-group grace-form-row">
                            <div class="grace-input-group">
                                <label for="full_name">Name</label>
                                <input type="text" id="full_name" name="full_name" placeholder="First" required>
                            </div>
                            <div class="grace-input-group">
                                <label for="last_name" style="opacity: 0;">Last</label>
                                <input type="text" id="last_name" name="last_name" placeholder="Last">
                            </div>
                        </div>
                        
                        <div class="grace-form-group">
                            <label for="email">Email</label>
                            <input type="email" id="email" name="email" required>
                        </div>
                        
                        <div class="grace-form-group">
                            <label for="inquiry_type">Subject *</label>
                            <select name="inquiry_type" id="inquiry_type" required>
                                <option value="">Select your inquiry type</option>
                                <option value="General Inquiry - New Booking">General Inquiry - New Booking</option>
                                <option value="General Inquiry - Existing Booking">General Inquiry - Existing Booking</option>
                                <option value="Changes to an Existing Booking">Changes to an Existing Booking</option>
                                <option value="Cancel My Booking">Cancel My Booking</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        
                        <div class="grace-form-group" style="display: none;">
                            <label for="phone">Phone Number</label>
                            <input type="text" id="phone" name="phone" value="+256 771 456146" required>
                        </div>
                        
                        <div class="grace-form-group" style="display: none;">
                            <label for="address">Country/City</label>
                            <input type="text" id="address" name="address" value="Kampala, Uganda">
                        </div>
                        
                        <div class="grace-form-group">
                            <label for="message">Comment or Message *</label>
                            <textarea id="message" name="message" rows="6" required></textarea>
                        </div>
                        
                        <div class="grace-form-submit">
                            <button type="submit" name="contact_inquiry_submit" class="grace-submit-btn">
                                Send Message
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Quote Section -->
    <div class="grace-quote-section" style="max-width: 100%;">
        <div class="grace-quote-container">
            <div class="grace-quote-mark">"</div>
            <blockquote class="grace-quote-text">
                Every safari tells a story of wonder and discovery. Let us craft yours with the passion and expertise that only comes from truly knowing Africa's heart.
            </blockquote>
            <div class="grace-quote-signature">
                <div class="grace-signature-line"></div>
                <p class="grace-signature-name">Beaut Sauvage Safaris</p>
            </div>
        </div>
    </div>
    
    <!-- Newsletter Section -->
    <div class="grace-newsletter-section" style="max-width: 100%;">
        <div class="grace-newsletter-container">
            <h3>Get all the latest news and info sent to your inbox.</h3>
            <div class="grace-newsletter-form">
                <input type="email" placeholder="Email address">
                <button type="button">Subscribe</button>
            </div>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('contact_inquiry_form', 'contact_inquiry_form_shortcode');

// Register Custom Post Type for admin viewing
function contact_inquiry_cpt() {
    register_post_type('contact_inquiry', [
        'label' => 'Contact Inquiries',
        'public' => false,
        'show_ui' => true,
        'capability_type' => 'post',
        'supports' => ['title', 'custom-fields'],
        'menu_icon' => 'dashicons-forms',
    ]);
}
add_action('init', 'contact_inquiry_cpt');