<?php
// Function to display dynamic breadcrumb with navigation history
function custom_breadcrumb() {
    ?>
    <div class="breadcrumb mx-auto" data-aos="fade-up" id="breadcrumb-container">
        <!-- Breadcrumb items will be populated by JavaScript -->
    </div>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize breadcrumb system
        initializeBreadcrumb();
    });
    
    function initializeBreadcrumb() {
        const homeUrl = '<?php echo home_url(); ?>';
        const currentUrl = window.location.href;
        const currentTitle = getCurrentPageTitle();
        
        // Get existing breadcrumb trail from sessionStorage
        let breadcrumbTrail = getBreadcrumbTrail();
        
        // Check if current page is already in the trail
        const currentPageIndex = breadcrumbTrail.findIndex(item => item.url === currentUrl);
        
        if (currentPageIndex !== -1) {
            // If current page exists in trail, remove everything after it
            // This handles cases where user goes back and then navigates to a new page
            breadcrumbTrail = breadcrumbTrail.slice(0, currentPageIndex + 1);
        } else {
            // Add current page to the trail
            breadcrumbTrail.push({
                title: currentTitle,
                url: currentUrl
            });
        }
        
        // Limit breadcrumb trail to prevent it from getting too long
        const maxBreadcrumbLength = 10;
        if (breadcrumbTrail.length > maxBreadcrumbLength) {
            breadcrumbTrail = breadcrumbTrail.slice(-maxBreadcrumbLength);
        }
        
        // Save updated trail
        saveBreadcrumbTrail(breadcrumbTrail);
        
        // Display breadcrumb
        displayBreadcrumb(breadcrumbTrail, homeUrl);
    }
    
    function getCurrentPageTitle() {
        // Get current page title based on page type
        <?php if (is_single() || is_page()): ?>
            return '<?php echo esc_js(get_the_title()); ?>';
        <?php elseif (is_category()): ?>
            <?php $category = get_queried_object(); ?>
            return '<?php echo esc_js($category->name); ?>';
        <?php elseif (is_tag()): ?>
            <?php $tag = get_queried_object(); ?>
            return '<?php echo esc_js($tag->name); ?>';
        <?php elseif (is_author()): ?>
            <?php $author = get_queried_object(); ?>
            return '<?php echo esc_js($author->display_name); ?>';
        <?php elseif (is_search()): ?>
            return 'Search results for "<?php echo esc_js(get_search_query()); ?>"';
        <?php elseif (is_404()): ?>
            return '404 Page Not Found';
        <?php else: ?>
            return document.title || 'Current Page';
        <?php endif; ?>
    }
    
    function getBreadcrumbTrail() {
        const stored = sessionStorage.getItem('breadcrumbTrail');
        if (stored) {
            try {
                return JSON.parse(stored);
            } catch (e) {
                console.warn('Error parsing breadcrumb trail:', e);
            }
        }
        return [];
    }
    
    function saveBreadcrumbTrail(trail) {
        try {
            sessionStorage.setItem('breadcrumbTrail', JSON.stringify(trail));
        } catch (e) {
            console.warn('Error saving breadcrumb trail:', e);
        }
    }
    
    function displayBreadcrumb(trail, homeUrl) {
        const container = document.getElementById('breadcrumb-container');
        if (!container) return;
        
        let breadcrumbHtml = '';
        
        // Always start with Home
        breadcrumbHtml += `<a href="${homeUrl}" class="breadcrumb-item" data-breadcrumb-home="true">Home</a>`;
        
        // Add trail items (skip if the first item is already home)
        trail.forEach((item, index) => {
            // Skip if this item is the home page
            if (item.url === homeUrl || item.url === homeUrl + '/') {
                return;
            }
            
            breadcrumbHtml += ' <span class="separator">/</span> ';
            
            // Make all items except the last one clickable
            if (index < trail.length - 1) {
                breadcrumbHtml += `<a href="${item.url}" class="breadcrumb-item">${item.title}</a>`;
            } else {
                breadcrumbHtml += `<span class="breadcrumb-current">${item.title}</span>`;
            }
        });
        
        container.innerHTML = breadcrumbHtml;
    }
    
    // Function to clear breadcrumb history (useful for testing or if needed)
    function clearBreadcrumbHistory() {
        sessionStorage.removeItem('breadcrumbTrail');
        location.reload();
    }
    
    // Optional: Add this function to your theme if you want a "Clear History" button
    window.clearBreadcrumbHistory = clearBreadcrumbHistory;
    </script>
    <?php
}

// Optional: Function to reset breadcrumb trail (call this on specific pages if needed)
function reset_breadcrumb_trail() {
    ?>
    <script>
    if (typeof Storage !== "undefined") {
        sessionStorage.removeItem('breadcrumbTrail');
    }
    </script>
    <?php
}

// Optional: Shortcode to display breadcrumb anywhere
function breadcrumb_shortcode($atts) {
    ob_start();
    custom_breadcrumb();
    return ob_get_clean();
}
add_shortcode('dynamic_breadcrumb', 'breadcrumb_shortcode');
?>