<?php
/**
 * Travel Portal Affiliations Shortcode
 */
ob_start();

function travel_portal_affiliations_shortcode($atts) {
    $atts = shortcode_atts(array(
        'show_logos' => 'true',
    ), $atts, 'travel_portal_affiliations');

    // Affiliations data with logo URL provision
    $affiliations = array(
        array(
            'name' => 'Uganda Tourism Board (UTB)',
            'description' => 'Recognized for upholding national tourism standards and promoting Uganda\'s rich destinations.',
            'logo_url' => 'https://lwegatech.net/beaute-sauvage-safaris/wp-content/uploads/2025/07/uganda-tourism-board-logo-25518EC15B-seeklogo.com_.png', 
            'website' => 'https://utb.go.ug/',
            'color' => '#1e3a8a'
        ),
        array(
            'name' => 'Ugandan Association of Travel Agents (TUGATA)',
            'description' => 'Committed to ethical practices and professionalism in Uganda\'s travel industry.',
            'logo_url' => 'https://lwegatech.net/beaute-sauvage-safaris/wp-content/uploads/2025/07/Tugata.png',
            'website' => 'https://www.tugata.com/',
            'color' => '#3b82f6'
        ),
        array(
            'name' => 'Association of Uganda Tour Operators (AUTO)',
            'description' => 'Dedicated to excellence in delivering exceptional travel experiences across Uganda.',
            'logo_url' => 'https://lwegatech.net/beaute-sauvage-safaris/wp-content/uploads/2025/07/AUTO-logo.png',
            'website' => 'https://ugandatouroperators.org/',
            'color' => '#fbbf24'
        ),
        array(
            'name' => 'International Air Transport Association (IATA)',
            'description' => 'Global network of trusted travel providers ensuring worldwide service excellence.',
            'logo_url' => 'https://lwegatech.net/beaute-sauvage-safaris/wp-content/uploads/2025/07/IATAlogo.svg.png',
            'website' => 'https://www.iata.org/',
            'color' => '#1e3a8a'
        ),
        array(
            'name' => 'Jubilee Life Insurance Company Uganda',
            'description' => 'Agents for Uganda\'s premier insurance provider, prioritizing your safety and peace of mind.',
            'logo_url' => 'https://lwegatech.net/beaute-sauvage-safaris/wp-content/uploads/2025/07/jubilee_insurance_LOGO.webp',
            'website' => '#',
            'color' => '#3b82f6'
        ),
    );

    ob_start();
    ?>
    
    <div class="affiliations-section">
        <div class="affiliations-container">
            <div class="affiliations-header">
                <h2>Trusted Partnerships & Certifications</h2>
                <p>At the heart of every memorable travel experience is the assurance that you are in safe and capable hands. That's why we have aligned ourselves with the most reputable organizations in the travel and tourism industry.</p>
                <div class="affiliations-trust-badge">
                    Certified Excellence Since 2010
                </div>
            </div>
            
            <div class="affiliations-grid">
                <?php foreach ($affiliations as $index => $affiliation): ?>
                    <div class="affiliations-card" style="--card-color: <?php echo $affiliation['color']; ?>">
                        <div class="affiliations-logo-container">
                            <?php if (!empty($affiliation['logo_url'])): ?>
                                <img src="<?php echo esc_url($affiliation['logo_url']); ?>" 
                                     alt="<?php echo esc_attr($affiliation['name']); ?>" 
                                     class="affiliations-logo-image">
                            <?php else: ?>
                                <div class="affiliations-logo-placeholder">
                                    <?php echo strtoupper(substr($affiliation['name'], 0, 1)); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="affiliations-content">
                            <h3><?php echo esc_html($affiliation['name']); ?></h3>
                            <p><?php echo esc_html($affiliation['description']); ?></p>
                            <a href="<?php echo esc_url($affiliation['website']); ?>" class="affiliations-learn-more">
                                Learn More
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="affiliations-cta">
                <div class="affiliations-cta-content">
                    <h3>Travel with Complete Confidence</h3>
                    <p>These trusted partnerships are a testament to our integrity, reliability, and passion for delivering world-class travel services. When you choose Travel Portal, you're choosing peace of mind.</p>
                    <a href="#contact" class="affiliations-cta-button">Start Your Journey Today</a>
                </div>
            </div>
        </div>
    </div>

    <?php
    return ob_get_clean();
}

add_shortcode('travel_portal_affiliations', 'travel_portal_affiliations_shortcode');
?>