<?php
// Travel Portal Homepage Shortcode
function travel_portal_homepage_shortcode($atts) {
    $atts = shortcode_atts(array(
        'show_destinations' => 'true',
        'show_packages' => 'true'
    ), $atts);
    
    ob_start();
    ?>

    <div class="tp-homepage">
    
<!-- Hero Section -->
<section class="tp-hero-section">
    <div class="tp-container">
        <div class="tp-hero-content">
            <div class="tp-hero-text">
                <h1 class="tp-hero-title">
                    We take <span class="tp-highlight">care of your travel preparations,</span><br>
                    so you can focus <span class="tp-highlight">on your goals.</span>
                </h1>
                <p class="tp-hero-description">
                    Travel Portal provides comprehensive, seamless travel solutions for business and leisure. Our services include air ticketing, hotel bookings, airport transfers, and long-stay accommodations. We offer strategic planning and custom itineraries for corporate clients, along with 24/7 support and emergency assistance.By choosing 
                    <span class="tp-brand-highlight">Travel Portal</span>, For your travel management, you're assured of our expert team ensuring every trip is efficient, safe, and stress-free, handling all details with precision.
                </p>
            </div>
            <div class="tp-hero-visual">
                <div class="tp-mobile-phones">
                    <div class="tp-mobile-container tp-mobile-left">
                        <div class="tp-mobile-phone">
                            <div class="tp-mobile-screen">
                                <div class="tp-mobile-header">
                                    <div class="tp-status-bar">
                                        <span class="tp-time">9:41</span>
                                        <div class="tp-indicators">
                                            <span class="tp-signal"></span>
                                            <span class="tp-wifi"></span>
                                            <span class="tp-battery"></span>
                                        </div>
                                    </div>
                                    <div class="tp-app-header">
                                        <h4>Travel Portal</h4>
                                    </div>
                                </div>
                                <div class="tp-mobile-content">
                                    <div class="tp-booking-card">
                                        <div class="tp-destination">
                                            <span class="tp-from">NYC</span>
                                            <span class="tp-arrow">→</span>
                                            <span class="tp-to">LON</span>
                                        </div>
                                        <div class="tp-date">Dec 15, 2024</div>
                                        <div class="tp-price">$1,240</div>
                                    </div>
                                    <div class="tp-booking-options">
                                        <div class="tp-option">✈️ Flight</div>
                                        <div class="tp-option">🏨 Hotel</div>
                                        <div class="tp-option">🚗 Car</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tp-mobile-container tp-mobile-right">
                        <div class="tp-mobile-phone">
                            <div class="tp-mobile-screen">
                                <div class="tp-mobile-header">
                                    <div class="tp-status-bar">
                                        <span class="tp-time">9:41</span>
                                        <div class="tp-indicators">
                                            <span class="tp-signal"></span>
                                            <span class="tp-wifi"></span>
                                            <span class="tp-battery"></span>
                                        </div>
                                    </div>
                                    <div class="tp-app-header">
                                        <h4>Travel Portal</h4>
                                    </div>
                                </div>
                                <div class="tp-mobile-content">
                                    <div class="tp-booking-progress">
                                        <div class="tp-step tp-step-active">1. Select</div>
                                        <div class="tp-step tp-step-active">2. Book</div>
                                        <div class="tp-step">3. Confirm</div>
                                    </div>
                                    <div class="tp-confirmation">
                                        <div class="tp-check">✓</div>
                                        <div class="tp-message">Booking Confirmed!</div>
                                        <div class="tp-details">Flight AA123 to London</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</section>

<!-- Services Section with Dark Blue Background -->
<section class="tp-services-section">
    <div class="tp-container">
        <div class="tp-services-grid">
            <div class="tp-service-card">
                <div class="tp-service-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                        <polyline points="7.5,4.21 12,6.81 16.5,4.21"></polyline>
                        <polyline points="7.5,19.79 7.5,14.6 3,12"></polyline>
                        <polyline points="21,12 16.5,14.6 16.5,19.79"></polyline>
                    </svg>
                </div>
                <h3>We look after the travellers</h3>
                <p>You may be out on the road every week or simply need to move around every now and then. Whatever the case, we'll book and manage your transport and accommodation – all you have to do is enjoy the ride.</p>
                <a href="#" class="tp-service-cta">Experience stress-free travel</a>
            </div>
            
            <div class="tp-service-card">
                <div class="tp-service-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                        <circle cx="9" cy="7" r="4"></circle>
                        <path d="m19 8 2 2-2 2"></path>
                        <path d="m17 12h4"></path>
                    </svg>
                </div>
                <h3>We partner the travel booker</h3>
                <p>Getting the best travel deals can be very hard work and requires a lot of time and focus. By choosing <span class="tp-brand-highlight">Travel Portal Management</span> as your business travel partner, we'll help you to reduce your travel costs and get more for your money.</p>
                <a href="#" class="tp-service-cta">Let's make your life easier</a>
            </div>
            
            <div class="tp-service-card">
                <div class="tp-service-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="22,12 18,12 15,21 9,3 6,12 2,12"></polyline>
                    </svg>
                </div>
                <h3>We delight the finance teams</h3>
                <p>Whether you're a department manager, administrator or personal assistant, we're ready to take a huge weight off your shoulders by planning and overseeing the entirety of your corporate travel requirements.</p>
                <a href="#" class="tp-service-cta">Reduce your travel costs</a>
            </div>
        </div>
    </div>
</section>



        
        <!-- Testimonial Section -->
        <section class="tp-testimonial-section">
            <div class="tp-container">
                <div class="tp-testimonial-content">
                    <div class="tp-testimonial-quote">
                        <div class="tp-quote-marks">"</div>
                        <blockquote>Travel Portal's comprehensive approach to our corporate travel needs has transformed how we manage employee movements. Their platform provides exactly what we need without unnecessary complexity.</blockquote>
                        <cite>Sarah Johnson, Travel Manager<br>Global Tech Solutions</cite>
                    </div>
                </div>
                <div class="tp-testimonial-indicators">
                    <span class="tp-indicator active"></span>
                    <span class="tp-indicator"></span>
                    <span class="tp-indicator"></span>
                </div>
            </div>
        </section>

        <!-- Travel Solutions Gallery - No spacing between images -->
        <section class="tp-solutions-gallery">
            <div class="tp-gallery-grid">
                <div class="tp-gallery-item">
                    <img src="https://images.unsplash.com/photo-1436491865332-7a61a109cc05?w=400&auto=format&fit=crop&q=60" alt="Airport Services" class="tp-gallery-image">
                    <div class="tp-gallery-overlay">
                        <h4>Airport Services</h4>
                        <p>Premium lounges & fast-track</p>
                    </div>
                </div>
                <div class="tp-gallery-item">
                    <img src="https://images.unsplash.com/photo-1551601651-2a8555f1a136?w=400&auto=format&fit=crop&q=60" alt="Meeting Venues" class="tp-gallery-image">
                    <div class="tp-gallery-overlay">
                        <h4>Meeting Venues</h4>
                        <p>Conference & event spaces</p>
                    </div>
                </div>
                <div class="tp-gallery-item">
                    <img src="https://images.unsplash.com/photo-1566073771259-6a8506099945?w=400&auto=format&fit=crop&q=60" alt="Premium Hotels" class="tp-gallery-image">
                    <div class="tp-gallery-overlay">
                        <h4>Premium Hotels</h4>
                        <p>Corporate accommodation</p>
                    </div>
                </div>
                <div class="tp-gallery-item">
                    <img src="https://images.unsplash.com/photo-1544620347-c4fd4a3d5957?w=400&auto=format&fit=crop&q=60" alt="Ground Transport" class="tp-gallery-image">
                    <div class="tp-gallery-overlay">
                        <h4>Ground Transport</h4>
                        <p>Cars, transfers & chauffeurs</p>
                    </div>
                </div>
            </div>
        </section>

        <?php if ($atts['show_packages'] === 'true'): ?>
        <!-- Exclusive Packages Section -->
        <section class="tp-packages-section">
        <div class="tp-container">
            <div class="tp-section-header">
                <h2 class="tp-section-title">Our Exclusive Packages</h2>
                <p class="tp-section-subtitle">Discover extraordinary destinations with our carefully curated travel experiences</p>
            </div>
            
            <div class="tp-packages-grid">
                <!-- Dubai Family Joy Package -->
                <div class="tp-package-card">
                    <div class="tp-package-image">
                        <img src="https://images.unsplash.com/photo-1512632578888-169bbbc64f33?w=400&auto=format&fit=crop&q=80" alt="Dubai Family Joy Package" loading="lazy">
                        <div class="tp-package-price">
                            <div class="tp-price-main">$2,850</div>
                            <div class="tp-price-ugx">UGX 10,545,000</div>
                            <div class="tp-price-desc">per person</div>
                        </div>
                    </div>
                    <div class="tp-package-details">
                        <div class="tp-package-meta">
                            <span><i class="fas fa-map-marker-alt"></i> Dubai, UAE</span>
                            <span><i class="far fa-clock"></i> 7 Days</span>
                        </div>
                        <h3>Dubai Family Joy</h3>
                        <p>Experience the magic of Dubai with your family. Luxury accommodations, desert safaris, theme parks, and unforgettable memories await.</p>
                        <div class="tp-package-features">
                            <span><i class="fas fa-star"></i> 5-Star Resort</span>
                            <span><i class="fas fa-plane"></i> Round-trip Flights</span>
                            <span><i class="fas fa-camera"></i> Desert Safari</span>
                            <span><i class="fas fa-swimming-pool"></i> Pool Access</span>
                        </div>
                        <a href="#" class="tp-view-details-button">View Details</a>
                    </div>
                </div>

                <!-- Bwindi Impenetrable Forest Package -->
                <!--<div class="tp-package-card">-->
                <!--    <div class="tp-package-image">-->
                <!--        <img src="https://images.unsplash.com/photo-1516026672322-bc52d61a55d5?w=400&auto=format&fit=crop&q=80" alt="Bwindi Impenetrable Forest Package" loading="lazy">-->
                <!--        <div class="tp-package-price">-->
                <!--            <div class="tp-price-main">$1,750</div>-->
                <!--            <div class="tp-price-ugx">UGX 6,475,000</div>-->
                <!--            <div class="tp-price-desc">per person</div>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--    <div class="tp-package-details">-->
                <!--        <div class="tp-package-meta">-->
                <!--            <span><i class="fas fa-map-marker-alt"></i> Bwindi, Uganda</span>-->
                <!--            <span><i class="far fa-clock"></i> 5 Days</span>-->
                <!--        </div>-->
                <!--        <h3>Bwindi Impenetrable Forest</h3>-->
                <!--        <p>Journey into Uganda's pristine wilderness for an incredible gorilla trekking adventure in one of Africa's most biodiverse forests.</p>-->
                <!--        <div class="tp-package-features">-->
                <!--            <span><i class="fas fa-tree"></i> Gorilla Trekking</span>-->
                <!--            <span><i class="fas fa-home"></i> Eco Lodge</span>-->
                <!--            <span><i class="fas fa-hiking"></i> Nature Walks</span>-->
                <!--            <span><i class="fas fa-binoculars"></i> Wildlife Viewing</span>-->
                <!--        </div>-->
                <!--        <a href="#" class="tp-view-details-button">View Details</a>-->
                <!--    </div>-->
                <!--</div>-->

                <!-- Dubai Marina Mall Experience -->
            <!--    <div class="tp-package-card">-->
            <!--        <div class="tp-package-image">-->
            <!--            <img src="https://images.unsplash.com/photo-1580587771525-78b9dba3b914?w=400&auto=format&fit=crop&q=80" alt="Dubai Marina Mall Experience" loading="lazy">-->
            <!--            <div class="tp-package-price">-->
            <!--                <div class="tp-price-main">$2,200</div>-->
            <!--                <div class="tp-price-ugx">UGX 8,140,000</div>-->
            <!--                <div class="tp-price-desc">per person</div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="tp-package-details">-->
            <!--            <div class="tp-package-meta">-->
            <!--                <span><i class="fas fa-map-marker-alt"></i> Dubai Marina</span>-->
            <!--                <span><i class="far fa-clock"></i> 6 Days</span>-->
            <!--            </div>-->
            <!--            <h3>Dubai Marina Mall Experience</h3>-->
            <!--            <p>Immerse yourself in luxury shopping, world-class dining, and stunning waterfront views in Dubai's most glamorous district.</p>-->
            <!--            <div class="tp-package-features">-->
            <!--                <span><i class="fas fa-building"></i> Marina Hotel</span>-->
            <!--                <span><i class="fas fa-shopping-bag"></i> Shopping Tours</span>-->
            <!--                <span><i class="fas fa-ship"></i> Yacht Experience</span>-->
            <!--                <span><i class="fas fa-utensils"></i> Fine Dining</span>-->
            <!--            </div>-->
            <!--            <a href="#" class="tp-view-details-button">View Details</a>-->
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
            
            <div class="tp-packages-cta">
                <p>Looking for custom solutions? We specialize in tailored travel packages.</p>
                <a href="https://lwegatech.net/beaute-sauvage-safaris/packages" class="tp-primary-button">View All Packages</a>
            </div>
        </div>
    </section>
        <?php endif; ?>
        
        
        <!-- FAQ Section -->
    <section class="faq-section">
        <div class="container">
            <div class="faq-header">
                <h2 class="faq-title">Frequently Asked Questions</h2>
                <div class="faq-intro">
                    <div class="faq-visual">
                        <div class="faq-circle">
                            <img src="https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=400&auto=format&fit=crop&q=60&ixlib=rb-4.0.3" alt="Professional woman" class="faq-person">
                            <div class="faq-decorations">
                                <div class="faq-float"></div>
                                <div class="faq-float"></div>
                            </div>
                        </div>
                    </div>
                    <div class="faq-container">
                        <div class="faq-text">
                            <p>"Check out the answers to some of our most frequently asked questions below. Feel free to get in touch with our team directly and we'd be happy to answer any queries you have."</p>
                            <div class="quote-author">- Customer Support Team</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="faq-accordion">
                <div class="faq-item active">
                    <button class="faq-question">
                        1. What exactly is a Travel Management Company (TMC)?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>While online booking sites and traditional agencies focus on point-to-point bookings (flights, hotels, cars), we as a TMC deliver end-to-end travel management:</p>
                            <ul>
                                <li>Traveler tracking and monitoring</li>
                                <li>Comprehensive risk management</li>
                                <li>Duty of care compliance</li>
                                <li>Travel insurance solutions</li>
                                <li>Cost optimization strategies</li>
                            </ul>
                        <p>With a TMC, you don't just buy a ticket; you gain strategic oversight, security and efficiency across your travel program.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        2. How does a TMC differ from an online booking site or regular agency?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>While online booking sites and traditional agencies focus on point-to-point bookings (flights, hotels, cars), we as a TMC deliver end-to-end travel management:</p>
                                <ul>
                                    <li>Traveler tracking and monitoring</li>
                                    <li>Comprehensive risk management</li>
                                    <li>Duty of care compliance</li>
                                    <li>Travel insurance solutions</li>
                                    <li>Cost optimization strategies</li>
                                </ul>
                                <p>With a TMC, you don't just buy a ticket; you gain strategic oversight, security and efficiency across your travel program.</p>

                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        3. What services do we as a TMC provide?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>We offer a comprehensive suite of services, including:</p>
                            <ul>
                                <li><strong>Air Ticketing & Hotel Reservations</strong> – competitive global fares and negotiated corporate rates</li>
                                <li><strong>Visa & Documentation Support</strong> – guidance on visa validity, requirements and renewals</li>
                                <li><strong>Travel Planning & Coordination</strong> – from simple trips to complex group itineraries and corporate events</li>
                                <li><strong>Leisure Travel Management</strong> – holidays, honeymoons, retreats and customized experiences</li>
                                <li><strong>Traveler Profiling</strong> – detailed records of preferences, travel history, loyalty memberships and compliance needs</li>
                                <li><strong>Duty of Care & Risk Management</strong> – traveler tracking, safety alerts and emergency assistance</li>
                                <li><strong>Travel Insurance Solutions</strong> – medical, cancellation, baggage loss and evacuation coverage</li>
                                <li><strong>24/7 Support</strong> – real-time guidance in case of disruptions or emergencies</li>
                            </ul>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        4. Why is travel planning and coordination so important?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>Travel planning goes beyond reservations — it ensures that itineraries are optimized for cost, time and convenience. Our coordination covers:</p>
                        <ul>
                            <li>Multi-sector and group logistics</li>
                            <li>Aligning trips with organizational policies</li>
                            <li>Handling last-minute changes and disruptions</li>
                            <li>Ensuring compliance with visa timelines and validity</li>
                        </ul>
                        <p>This saves travelers stress while saving organizations time and money.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        5. What is traveler profiling and how does it benefit me?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>Traveler profiling is the process of maintaining detailed traveler records — including passport details, loyalty programs, dietary preferences, seat choices, medical needs and travel history.</p>
                    <p>Benefits include:</p>
                    <ul>
                        <li>Faster, error-free bookings</li>
                        <li>Consistent travel experiences tailored to your needs</li>
                        <li>Proactive reminders (e.g., passport/visa expiry)</li>
                        <li>Data for audits, visa renewals and compliance checks</li>
                    </ul>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        6. What does “Duty of Care” mean in travel management?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>Duty of Care refers to the responsibility organizations have to keep their travelers safe. Our TMC ensures this by:</p>
                    <ul>
                        <li><strong>Traveler Tracking:</strong> Monitoring flights during travel</li>
                        <li><strong>Risk Intelligence:</strong> Alerts for strikes, natural disasters, unrest, or weather disruptions</li>
                        <li><strong>Emergency Response:</strong> Rebooking, medical assistance, or evacuation when required</li>
                    </ul>
                    <p>This ensures peace of mind for both travelers and the organizations that send them.</p>
                    </div>
                </div>

                <div class="faq-item">
                    <button class="faq-question">
                        7. Why is travel insurance critical?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>Travel insurance is not optional — it's a safety net. It covers:</p>
                            <ul>
                                <li>Emergency medical treatment abroad</li>
                                <li>Evacuation from remote or high-risk areas</li>
                                <li>Trip cancellations, missed connections, or delays</li>
                                <li>Baggage loss, theft, or damage</li>
                            </ul>
                            <p>By arranging coverage through trusted providers, our TMC ensures that travelers are protected against the unexpected.</p>
                    </div>
                </div>
                
                
                <div class="faq-item">
                    <button class="faq-question">
                        8. How does a TMC help reduce travel costs?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>We reduce costs by:</p>
                        <ul>
                            <li>Accessing consolidator fares and negotiated airline/hotel rates</li>
                            <li>Preventing errors that lead to costly changes or penalties</li>
                            <li>Offering group booking discounts</li>
                            <li>Providing travel spend reports to identify trends and savings opportunities</li>
                        </ul>
                        <p>Over time, this adds up to significant financial benefits for both individuals and organizations.</p>
                    </div>
                </div>
                
                
                
                <div class="faq-item">
                    <button class="faq-question">
                        9. Do you manage corporate, NGO and group travel?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>Yes. We handle:</p>
                            <ul>
                                <li><strong>Corporate travel</strong> – for executives, employees and conferences</li>
                                <li><strong>NGO and humanitarian travel</strong> – including deployments to remote destinations</li>
                                <li><strong>Government and institutional travel</strong> – requiring policy compliance</li>
                                <li><strong>Group leisure trips</strong> – family holidays, weddings, or retreats</li>
                            </ul>
                            <p>Our strength lies in seamless coordination and ensuring everyone arrives safely, on time and within budget.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question">
                        10. What kind of support will I receive during travel?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>We provide 24/7 global support. Travelers can reach us any time for:</p>
                            <ul>
                                <li>Flight rebooking during cancellations or delays</li>
                                <li>Visa and document clarifications</li>
                                <li>Medical emergencies and insurance claims</li>
                                <li>Crisis management during natural disasters or unrest</li>
                            </ul>
                            <p>This guarantees peace of mind wherever you are in the world.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <button class="faq-question">
                        11. How does a TMC support sustainability in travel?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                        <p>As a TMC, we help our clients adopt practical and eco-conscious choices by:</p>
                                <ul>
                                    <li>Promoting regional airlines and direct flights where possible, reducing unnecessary connections and fuel use</li>
                                    <li>Partnering with eco-certified hotels and lodges that practice energy conservation, waste reduction and responsible tourism</li>
                                    <li>Encouraging use of reputable local ground handlers that operate fuel-efficient vehicles or hybrid vehicles</li>
                                    <li>Advising clients on combining trips (multi-purpose journeys) to cut down repeated flights</li>
                                    <li>Supporting virtual meetings for corporates to reduce avoidable travel when video conferencing is sufficient</li>
                                </ul>
                    </div>
                </div>
                
                
                <div class="faq-item">
                    <button class="faq-question">
                        12. How do I get started with your TMC?
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="faq-answer">
                         <p>Starting is simple:</p>
                            <ol>
                                <li>Call or email us to share your travel requirements (business or leisure)</li>
                                <li>A dedicated travel consultant will get in touch with you to discuss further and advise you on the options and possibilities</li>
                            </ol>
                            <p>From there, you gain a long-term travel partner focused on efficiency, safety and value.</p>
                    </div>
                </div>
                
                
            </div>
        </div>
    </section>


    <style>
    /* Color Variables */
    :root {
        --tp-primary: #1e3a8a;
        --tp-primary-light: #2d4da8;
        --tp-secondary: #f3f4f6;
        --tp-accent: #f59e0b;
        --tp-text: #1f2937;
        --tp-text-light: #6b7280;
        --tp-white: #ffffff;
    }
    
    /* Global Styles */
    .tp-homepage {color: var(--tp-text); line-height: 1.6;}
    .tp-container {max-width: 1200px; margin: 0 auto; padding: 0 20px;}
.tp-hero-section { background: linear-gradient(135deg, var(--tp-white) 0%, #f8fafc 100%); padding: 100px 0; overflow: hidden; }
.tp-container { max-width: 1200px; margin: 0 auto; padding: 0 20px; }
.tp-hero-content { display: flex; align-items: center; justify-content: space-between; gap: 60px; }
.tp-hero-text { flex: 1; max-width: 600px; }
.tp-hero-title { font-size: 2.5rem; font-weight: 300; line-height: 1.2; margin-bottom: 30px; color: var(--tp-text); }
.tp-highlight { color: var(--tp-accent); font-weight: 400; }
.tp-hero-description { font-size: 1.1rem; line-height: 1.7; color: var(--tp-text-light); margin-bottom: 0; }
.tp-brand-highlight { color: var(--tp-accent); font-weight: 500; }
.tp-hero-visual { position: relative; flex: 0 0 400px; height: 400px; }
.tp-mobile-phones { position: relative; width: 400px; height: 400px; }
.tp-mobile-container { position: absolute; }
.tp-mobile-left { top: 40px; left: 0px; transform: rotate(-15deg); z-index: 1; }
.tp-mobile-right { top: 20px; right: 0px; transform: rotate(10deg); z-index: 2; }
.tp-mobile-phone { width: 180px; height: 320px; background: #1f2937; border-radius: 25px; padding: 8px; box-shadow: 0 10px 30px rgba(0,0,0,0.3); }
.tp-mobile-screen { width: 100%; height: 100%; background: var(--tp-white); border-radius: 18px; overflow: hidden; display: flex; flex-direction: column; }
.tp-mobile-header { background: var(--tp-primary); color: var(--tp-white); padding: 8px 0; }
.tp-status-bar { display: flex; justify-content: space-between; align-items: center; padding: 0 15px; font-size: 0.7rem; margin-bottom: 8px; }
.tp-time { font-weight: 600; }
.tp-indicators { display: flex; gap: 4px; }
.tp-signal, .tp-wifi, .tp-battery { width: 12px; height: 8px; background: var(--tp-white); border-radius: 2px; }
.tp-app-header { text-align: center; padding: 0 15px; }
.tp-app-header h4 { margin: 0; font-size: 0.9rem; font-weight: 600; }
.tp-mobile-content { flex: 1; padding: 20px 15px; display: flex; flex-direction: column; justify-content: center; }
.tp-booking-card { background: #f8fafc; border-radius: 12px; padding: 20px; margin-bottom: 15px; text-align: center; }
.tp-destination { font-size: 1.2rem; font-weight: 700; color: var(--tp-primary); margin-bottom: 8px; }
.tp-from, .tp-to { color: var(--tp-primary); }
.tp-arrow { margin: 0 8px; color: var(--tp-accent); }
.tp-date { font-size: 0.8rem; color: var(--tp-text-light); margin-bottom: 8px; }
.tp-price { font-size: 1.1rem; font-weight: 600; color: var(--tp-accent); }
.tp-booking-options { display: flex; justify-content: space-between; }
.tp-option { background: var(--tp-primary); color: var(--tp-white); padding: 8px 12px; border-radius: 8px; font-size: 0.7rem; text-align: center; flex: 1; margin: 0 2px; }
.tp-booking-progress { display: flex; justify-content: space-between; margin-bottom: 20px; }
.tp-step { font-size: 0.7rem; color: var(--tp-text-light); }

.tp-step-active { color: var(--tp-primary); font-weight: 600; }

.tp-confirmation { text-align: center; background: #f0fdf4; border-radius: 12px; padding: 20px; }

.tp-check { font-size: 2rem; color: #10b981; margin-bottom: 8px; }

.tp-message { font-size: 0.9rem; font-weight: 600; color: var(--tp-primary); margin-bottom: 5px; }

.tp-details { font-size: 0.7rem; color: var(--tp-text-light); }

.tp-hero-image-link { display: block; width: 100%; height: 100%; text-decoration: none; }

.tp-hero-image { width: 100%; height: 100%; background: url('https://images.unsplash.com/photo-1594736797933-d0401ba2fe65?ixlib=rb-4.0.3&auto=format&fit=crop&w=400&h=400&q=80') center/cover; background-position: center 20%; }

.tp-quote-bubble { position: absolute; top: 80px; right: -40px; background: #e0f2fe; padding: 20px 25px; border-radius: 20px; max-width: 280px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); z-index: 10; }

.tp-quote-arrow { position: absolute; left: -15px; top: 30px; width: 0; height: 0; border-top: 15px solid transparent; border-bottom: 15px solid transparent; border-right: 15px solid #e0f2fe; }

.tp-quote-text { font-size: 1rem; font-style: italic; color: var(--tp-text); margin: 0 0 10px 0; line-height: 1.4; }

.tp-quote-author { font-size: 0.85rem; color: var(--tp-text-light); font-style: normal; font-weight: 500; }

.tp-hero-dots { position: absolute; top: 80px; right: -20px; }

.tp-dot { width: 80px; height: 80px; background: var(--tp-primary); border-radius: 50%; margin-bottom: 20px; }

.tp-hero-side-text { position: absolute; top: 200px; right: -80px; width: 300px; font-size: 0.95rem; line-height: 1.6; color: var(--tp-text-light); }

.tp-services-section { background-color: var(--tp-primary); padding: 80px 0; color: var(--tp-white); }

.tp-services-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 40px; margin-top: 60px; }

.tp-service-card { background: rgba(255, 255, 255, 0.05); padding: 40px 30px; border-radius: 12px; text-align: left; backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); }

.tp-service-icon { width: 60px; height: 60px; margin-bottom: 30px; color: #ff8e8e; }

.tp-service-icon svg { width: 100%; height: 100%; }

.tp-service-card h3 { font-size: 1.5rem; font-weight: 600; margin-bottom: 20px; color: var(--tp-white); line-height: 1.3; }

.tp-service-card p { font-size: 1rem; line-height: 1.6; color: rgba(255, 255, 255, 0.8); margin-bottom: 30px; }

.tp-service-cta { display: inline-block; background: #25D366; color: var(--tp-white); padding: 12px 24px; border-radius: 5px; text-decoration: none; font-weight: 500; font-size: 0.9rem; transition: all 0.3s ease; }

.tp-service-cta:hover { background: #00c19a; transform: translateY(-2px); }

@media (max-width: 1024px) {
    .tp-hero-content { flex-direction: column; gap: 40px; text-align: center; }
    .tp-hero-visual { flex: none; }
    .tp-services-grid { grid-template-columns: 1fr; }
    .tp-hero-title { font-size: 2.5rem; }
}

    /* Testimonial Section */
    .tp-testimonial-section {
        padding: 100px 0;
        background-color: var(--tp-secondary);
    }
    
    .tp-testimonial-content {
        display: flex;
        align-items: center;
        gap: 60px;
    }
    
    .tp-testimonial-quote {
        flex: 2;
    }
    
    .tp-quote-marks {
        font-size: 5rem;
        color: var(--tp-primary);
        line-height: 1;
        margin-bottom: 20px;
    }
    
    .tp-testimonial-quote blockquote {
        font-size: 1.5rem;
        font-weight: 500;
        margin-bottom: 24px;
        line-height: 1.4;
    }
    
    .tp-testimonial-quote cite {
        font-style: normal;
        font-weight: 600;
        color: var(--tp-primary);
    }
    
    
    .tp-testimonial-indicators {
        display: flex;
        justify-content: center;
        gap: 12px;
        margin-top: 40px;
    }
    
    .tp-indicator {
        width: 12px;
        height: 12px;
        border-radius: 50%;
        background-color: #d1d5db;
        cursor: pointer;
    }
    
    .tp-indicator.active {
        background-color: var(--tp-primary);
    }
    
    /* Solutions Gallery - No spacing between images */
    .tp-solutions-gallery {
        margin: 0;
        padding: 0;
    }
    
    .tp-gallery-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 0; /* Remove gap between images */
    }
    
    .tp-gallery-item {
        position: relative;
        overflow: hidden;
        aspect-ratio: 1/1;
    }
    
    .tp-gallery-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.5s;
        border-radius: 0; /* Remove border radius */
    }
    
    .tp-gallery-item:hover .tp-gallery-image {
        transform: scale(1.1);
    }
    
    .tp-gallery-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: linear-gradient(to top, rgba(30, 58, 138, 0.9) 0%, transparent 100%);
        color: white;
        padding: 30px 20px 20px;
        transform: translateY(100%);
        transition: transform 0.3s;
    }
    
    .tp-gallery-item:hover .tp-gallery-overlay {
        transform: translateY(0);
    }
    
    .tp-gallery-overlay h4 {
        margin-bottom: 8px;
        font-size: 1.2rem;
    }
    
    * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: var(--tp-text-dark); }
        
        .tp-container { max-width: 1200px; margin: 0 auto; padding: 0 20px; }
        
        .tp-section-header { text-align: center; margin-bottom: 60px; }
        
        .tp-section-title { font-size: 3rem; font-weight: 700; color: var(--tp-primary); margin-bottom: 20px; text-align: center; }
        
        .tp-section-subtitle { font-size: 1.3rem; color: var(--tp-text-light); max-width: 600px; margin: 0 auto; text-align: center; }
        
        .tp-primary-button { display: inline-block; background: var(--tp-primary); color: white; padding: 15px 30px; border-radius: 6px; text-decoration: none; font-weight: 600; font-size: 1.1rem; transition: all 0.3s ease; }
        
        .tp-primary-button:hover { background: var(--tp-primary-light); transform: translateY(-2px); box-shadow: 0 8px 25px rgba(37, 99, 235, 0.3); }

        /* Packages Section */
        .tp-packages-section { padding: 100px 0; background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); }
        
        .tp-packages-grid { display: grid; grid-template-columns: repeat(3, 1fr); gap: 30px; margin-bottom: 50px; }
        
        .tp-package-card { border-radius: 12px; overflow: hidden; box-shadow: 0 15px 40px rgba(0,0,0,0.1); transition: all 0.3s ease; background: white; }
        
        .tp-package-card:hover { transform: translateY(-15px); box-shadow: 0 25px 50px rgba(0,0,0,0.15); }
        
        .tp-package-image { position: relative; height: 280px; overflow: hidden; }
        
        .tp-package-image img { width: 100%; height: 100%; object-fit: cover; transition: transform 0.3s ease; }
        
        .tp-package-card:hover .tp-package-image img { transform: scale(1.05); }
        
        .tp-package-price { position: absolute; top: 20px; right: 20px; background: linear-gradient(135deg, var(--tp-primary), var(--tp-primary-light)); color: white; padding: 12px 18px; border-radius: 8px; text-align: center; box-shadow: 0 4px 15px rgba(37, 99, 235, 0.3); }
        
        .tp-price-main { font-size: 1.4rem; font-weight: 700; margin-bottom: 2px; }
        
        .tp-price-ugx { font-size: 1.1rem; font-weight: 600; opacity: 0.9; }
        
        .tp-price-desc { font-size: 0.8rem; opacity: 0.8; margin-top: 2px; }
        
        .tp-package-details { padding: 30px 25px; }
        
        .tp-package-meta { display: flex; justify-content: space-between; margin-bottom: 15px; font-size: 0.9rem; color: var(--tp-text-light); }
        
        .tp-package-details h3 { font-size: 1.4rem; margin-bottom: 12px; color: var(--tp-primary); font-weight: 700; }
        
        .tp-package-details p { margin-bottom: 20px; color: var(--tp-text-light); line-height: 1.6; }
        
        .tp-package-features { display: flex; flex-wrap: wrap; gap: 10px; margin-bottom: 25px; }
        
        .tp-package-features span { background: linear-gradient(135deg, var(--tp-secondary), #e2e8f0); padding: 8px 15px; border-radius: 25px; font-size: 0.85rem; color: var(--tp-text-light); font-weight: 500; border: 1px solid #e2e8f0; }
        
        .tp-view-details-button { display: block; text-align: center; background: linear-gradient(135deg, var(--tp-primary), var(--tp-primary-light)); color: white; padding: 14px; border-radius: 8px; text-decoration: none; font-weight: 600; transition: all 0.3s ease; }
        
        .tp-view-details-button:hover { background: linear-gradient(135deg, var(--tp-primary-light), var(--tp-primary)); transform: translateY(-2px); box-shadow: 0 8px 25px rgba(37, 99, 235, 0.3); }
        
        .tp-packages-cta { text-align: center; margin-top: 60px; }
        
        .tp-packages-cta p { margin-bottom: 25px; font-size: 1.3rem; color: var(--tp-text-light); }

        @media (max-width: 768px) {
            .tp-packages-grid { grid-template-columns: 1fr; gap: 20px; }
            .tp-section-title { font-size: 2.2rem; }
            .tp-section-subtitle { font-size: 1.1rem; }
            .tp-package-image { height: 220px; }
        }
        
        
        /* FAQ Section */
        .faq-section {
            padding: 100px 0;
            background: #f8f9fa;
        }

        .faq-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .faq-title {
            font-size: 2.5rem;
            color: #ff6b35;
            margin-bottom: 40px;
        }

        .faq-intro {
            display: grid;
            grid-template-columns: 1fr 2fr;
            gap: 60px;
            align-items: center;
            margin-bottom: 60px;
        }

        .faq-visual {
            display: flex;
            justify-content: center;
            align-items: center;
            position: relative;
        }

        .faq-circle {
            width: 300px;
            height: 300px;
            border-radius: 50%;
            overflow: hidden;
            background: #ff6b35;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .faq-person {
            width: 240px;
            height: 240px;
            border-radius: 50%;
            object-fit: cover;
            border: 8px solid white;
        }

        .faq-decorations {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
        }

        .faq-float {
            position: absolute;
            background: #2d1b69;
            border-radius: 50%;
            opacity: 0.8;
        }

        .faq-float:nth-child(1) {
            width: 40px;
            height: 40px;
            top: 20px;
            right: -10px;
        }

        .faq-float:nth-child(2) {
            width: 30px;
            height: 30px;
            bottom: 40px;
            left: -15px;
        }

        .faq-container {
    display: flex;
    justify-content: center;
    align-items: center;
    margin: 20px 0;
}

.faq-text {
    background: rgba(255, 235, 205, 0.7);
    padding: 40px 30px;
    border-radius: 10px;
    width: 60%;
    max-width: 450px;
    position: relative;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

.faq-text::before {
    content: """;
    position: absolute;
    top: 15px;
    left: 15px;
    font-size: 60px;
    color: rgba(139, 69, 19, 0.2);
    font-family: Georgia, serif;
}

.faq-text p {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #333;
    margin: 0 0 15px 0;
    font-style: italic;
    text-align: center;
}

.quote-author {
    text-align: right;
    font-weight: 600;
    color: #8B4513;
    font-style: normal;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    .faq-text {
        width: 85%;
        padding: 30px 25px;
    }
    
    .faq-text p {
        font-size: 1rem;
    }
    
    .faq-text::before {
        font-size: 50px;
    }
}

@media (max-width: 480px) {
    .faq-text {
        width: 100%;
        padding: 25px 20px;
        box-sizing: border-box; /* Add this to include padding in width calculation */
    }
    
    .faq-text p {
        font-size: 0.95rem;
    }
    
    .faq-text::before {
        font-size: 40px;
    }
}
@media (max-width: 768px) {
    .faq-visual {
        display: none;
    }
}

        .faq-accordion {
            max-width: 800px;
            margin: 0 auto;
        }

        .faq-item {
            background: white;
            margin-bottom: 10px;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .faq-question {
            width: 100%;
            background: #2d1b69;
            color: white;
            border: none;
            padding: 20px 25px;
            text-align: left;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: background 0.3s;
        }

        .faq-question:hover {
            background: #3d2b79;
        }

        .faq-question i {
            transition: transform 0.3s;
        }

        .faq-item.active .faq-question i {
            transform: rotate(180deg);
        }

        .faq-answer {
            padding: 0;
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease, padding 0.3s ease;
            background: white;
        }

        .faq-item.active .faq-answer {
            padding: 25px;
            max-height: 300px;
        }

        .faq-answer p {
            margin: 0;
            color: #666;
            line-height: 1.6;
        }

        
    /* Responsive Styles */
    @media (max-width: 992px) {
        .tp-hero-content {
            flex-direction: column;
        }
        
        .tp-services-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        
        .tp-testimonial-content {
            flex-direction: column;
        }
        
        .tp-packages-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        
        .tp-gallery-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }
    
    @media (max-width: 768px) {
        .tp-hero-title {
            font-size: 2.2rem;
        }
        
        .tp-services-grid {
            grid-template-columns: 1fr;
        }
        
        .tp-packages-grid {
            grid-template-columns: 1fr;
        }
        
        .tp-gallery-grid {
            grid-template-columns: 1fr;
        }
        
        .tp-hero-buttons, .tp-cta-buttons {
            flex-direction: column;
        }
    }
    </style>

    <script>
    jQuery(document).ready(function($) {
        // Testimonial carousel
        var testimonialIndex = 0;
        var testimonials = $('.tp-testimonial-content');
        var indicators = $('.tp-indicator');
        
        function showTestimonial(index) {
            testimonials.hide();
            $(testimonials[index]).fadeIn(500);
            indicators.removeClass('active');
            $(indicators[index]).addClass('active');
        }
        
        // Initialize first testimonial
        showTestimonial(testimonialIndex);
        
        // Click handler for indicators
        indicators.click(function() {
            testimonialIndex = $(this).index();
            showTestimonial(testimonialIndex);
        });
        
        // Auto rotate testimonials
        setInterval(function() {
            testimonialIndex = (testimonialIndex + 1) % testimonials.length;
            showTestimonial(testimonialIndex);
        }, 5000);
        
        
        
        // FAQ Accordion Functionality
        document.querySelectorAll('.faq-question').forEach(question => {
            question.addEventListener('click', () => {
                const faqItem = question.parentElement;
                const isActive = faqItem.classList.contains('active');
                
                // Close all FAQ items
                document.querySelectorAll('.faq-item').forEach(item => {
                    item.classList.remove('active');
                });
                
                // Open clicked item if it wasn't active
                if (!isActive) {
                    faqItem.classList.add('active');
                }
            });
        });
        
        // Animate elements when they come into view
        function animateOnScroll() {
            $('.tp-section-title, .tp-section-subtitle, .tp-service-card, .tp-package-card').each(function() {
                var position = $(this).offset().top;
                var scroll = $(window).scrollTop();
                var windowHeight = $(window).height();
                
                if (scroll + windowHeight > position + 100) {
                    $(this).css('opacity', '1');
                    $(this).css('transform', 'translateY(0)');
                }
            });
        }
        
        // Set initial state for animation
        $('.tp-section-title, .tp-section-subtitle, .tp-service-card, .tp-package-card').css({
            'opacity': '0',
            'transform': 'translateY(30px)',
            'transition': 'all 0.5s ease'
        });
        
        // Run on load and scroll
        animateOnScroll();
        $(window).scroll(function() {
            animateOnScroll();
        });
    });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('travel_portal_homepage', 'travel_portal_homepage_shortcode');