<?php
function travel_services_shortcode() {
    $options = get_option('travel_services_options');
    ob_start(); ?>
    
    <style>
        /* Content Styling - These styles will be applied to all content added through WordPress editor */
        .ticketing-services-content .ticketing-content-wrapper h1,
        .ticketing-services-content .ticketing-content-wrapper h2,
        .ticketing-services-content .ticketing-content-wrapper h3,
        .ticketing-services-content .ticketing-content-wrapper h4,
        .ticketing-services-content .ticketing-content-wrapper h5,
        .ticketing-services-content .ticketing-content-wrapper h6 {
            color: #1e3a8a;
            font-family: 'Arial', sans-serif;
            font-weight: 600;
            line-height: 1.4;
            margin: 20px 0 15px 0;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 8px;
        }

        .ticketing-services-content .ticketing-content-wrapper h1 { font-size: 24px; }
        .ticketing-services-content .ticketing-content-wrapper h2 { font-size: 22px; }
        .ticketing-services-content .ticketing-content-wrapper h3 { font-size: 20px; }
        .ticketing-services-content .ticketing-content-wrapper h4 { font-size: 18px; }
        .ticketing-services-content .ticketing-content-wrapper h5 { font-size: 16px; }
        .ticketing-services-content .ticketing-content-wrapper h6 { font-size: 14px; }

        /* Paragraph styling */
        .ticketing-services-content .ticketing-content-wrapper p {
            line-height: 1.8;
            margin: 0 0 16px 0;
            color: #374151;
            font-size: 14px;
            text-align: justify;
            word-spacing: 0.1em;
        }

        /* List styling with stars instead of dots */
        .ticketing-services-content .ticketing-content-wrapper ul {
            margin: 16px 0;
            padding-left: 0;
            list-style: none;
        }

        .ticketing-services-content .ticketing-content-wrapper ul li {
            position: relative;
            padding-left: 25px;
            margin-bottom: 8px;
            line-height: 1.6;
            color: #374151;
            font-size: 14px;
        }

        .ticketing-services-content .ticketing-content-wrapper ul li::before {
            content: "★";
            color: #fbbf24;
            font-size: 14px;
            position: absolute;
            left: 0;
            top: 0;
        }

        /* Ordered list styling */
        .ticketing-services-content .ticketing-content-wrapper ol {
            margin: 16px 0;
            padding-left: 20px;
            counter-reset: item;
        }

        .ticketing-services-content .ticketing-content-wrapper ol li {
            display: block;
            margin-bottom: 8px;
            padding-left: 15px;
            line-height: 1.6;
            color: #374151;
            font-size: 14px;
            position: relative;
            counter-increment: item;
        }

        .ticketing-services-content .ticketing-content-wrapper ol li::before {
            content: counter(item) ".";
            color: #1e3a8a;
            font-weight: bold;
            position: absolute;
            left: -15px;
            top: 0;
        }

        /* Nested list styling */
        .ticketing-services-content .ticketing-content-wrapper ul ul li::before {
            content: "☆";
            color: #94a3b8;
        }

        /* Strong/Bold text styling */
        .ticketing-services-content .ticketing-content-wrapper strong,
        .ticketing-services-content .ticketing-content-wrapper b {
            color: #1e3a8a;
            font-weight: 600;
        }

        /* Italic text styling */
        .ticketing-services-content .ticketing-content-wrapper em,
        .ticketing-services-content .ticketing-content-wrapper i {
            color: #6b7280;
            font-style: italic;
        }

        /* Link styling */
        .ticketing-services-content .ticketing-content-wrapper a {
            color: #2563eb;
            text-decoration: none;
            border-bottom: 1px solid transparent;
            transition: all 0.2s ease;
        }

        .ticketing-services-content .ticketing-content-wrapper a:hover {
            color: #1d4ed8;
            border-bottom-color: #1d4ed8;
        }

        /* Blockquote styling */
        .ticketing-services-content .ticketing-content-wrapper blockquote {
            border-left: 4px solid #1e3a8a;
            margin: 20px 0;
            padding: 15px 20px;
            background: #f8fafc;
            font-style: italic;
            color: #4b5563;
            border-radius: 0 4px 4px 0;
        }

        /* Table styling (if tables are used) */
        .ticketing-services-content .ticketing-content-wrapper table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 14px;
        }

        .ticketing-services-content .ticketing-content-wrapper table th,
        .ticketing-services-content .ticketing-content-wrapper table td {
            border: 1px solid #e5e7eb;
            padding: 10px;
            text-align: left;
        }

        .ticketing-services-content .ticketing-content-wrapper table th {
            background-color: #1e3a8a;
            color: white;
            font-weight: 600;
        }

        .ticketing-services-content .ticketing-content-wrapper table tr:nth-child(even) {
            background-color: #f9fafb;
        }

        /* Code styling */
        .ticketing-services-content .ticketing-content-wrapper code {
            background-color: #f3f4f6;
            color: #dc2626;
            padding: 2px 6px;
            border-radius: 3px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
        }

        /* Pre formatting for code blocks */
        .ticketing-services-content .ticketing-content-wrapper pre {
            background-color: #1f2937;
            color: #f9fafb;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            margin: 20px 0;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            line-height: 1.4;
        }

        /* Image styling */
        .ticketing-services-content .ticketing-content-wrapper img {
            max-width: 100%;
            height: auto;
            border-radius: 5px;
            margin: 10px 0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        /* HR styling */
        .ticketing-services-content .ticketing-content-wrapper hr {
            border: none;
            height: 2px;
            background: linear-gradient(90deg, #1e3a8a, transparent);
            margin: 25px 0;
        }

        /* Caption styling */
        .ticketing-services-content .ticketing-content-wrapper .wp-caption-text {
            font-size: 12px;
            color: #6b7280;
            font-style: italic;
            text-align: center;
            margin-top: 5px;
        }
    </style>
    
    <div class="ticketing-travel-services-panel">
        <div class="ticketing-services-sidebar">
            <div class="ticketing-sidebar-item ticketing-active" data-tab="air-ticketing">
                <i class="fas fa-plane-departure"></i>
                <span>Air Ticketing and Hotel Booking</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="travel-coordination">
                <i class="fas fa-suitcase-rolling"></i>
                <span>Travel Planning & Coordination</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="leisure-travel">
                <i class="fas fa-calendar-day"></i>
                <span>Leisure Travel Management</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="travel-insurance">
                <i class="fas fa-plane"></i>
                <span>Travel Insurance Arrangement</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="traveler-profiling">
                <i class="fas fa-plane"></i>
                <span>Traveler Profiling</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="support-alerting">
                <i class="fas fa-plane"></i>
                <span>24/7 Support and Alerting</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="visa-support" data-url="https://lwegatech.net/beaute-sauvage-safaris/visa-support-services/">
                <i class="fas fa-plane"></i>
                <span>Visa Support</span>
            </div>
        </div>
        
        <div class="ticketing-services-content">
            <div id="air-ticketing" class="ticketing-content-item ticketing-active">
                <h3><?php echo esc_html($options['air_ticketing_title'] ?? 'Air Ticketing and Hotel Booking'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['air_ticketing_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
            
            <div id="travel-coordination" class="ticketing-content-item">
                <h3><?php echo esc_html($options['travel_coordination_title'] ?? 'Travel Coordination'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['travel_coordination_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
            
            <div id="leisure-travel" class="ticketing-content-item">
                <h3><?php echo esc_html($options['leisure_travel_title'] ?? 'Leisure Travel Management'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['leisure_travel_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
            
            <div id="travel-insurance" class="ticketing-content-item">
                <h3><?php echo esc_html($options['travel_insurance_title'] ?? 'Travel Insurance Arrangement'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['travel_insurance_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>

            <div id="traveler-profiling" class="ticketing-content-item">
                <h3><?php echo esc_html($options['traveler_profiling_title'] ?? 'Traveler Profiling'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['traveler_profiling_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>

            <div id="support-alerting" class="ticketing-content-item">
                <h3><?php echo esc_html($options['support_alerting_title'] ?? '24/7 Support and Alerting'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['support_alerting_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
        </div>
    </div>

    
    <script>
        jQuery(document).ready(function($) {
            $('.ticketing-sidebar-item').on('click', function() {
                // Check if this item has a URL (for visa support)
                var url = $(this).data('url');
                if (url) {
                    window.location.href = url;
                    return;
                }

                $('.ticketing-sidebar-item').removeClass('ticketing-active');
                $(this).addClass('ticketing-active');
                $('.ticketing-content-item').removeClass('ticketing-active');
                var tabId = $(this).data('tab');
                $('#' + tabId).addClass('ticketing-active');
                $('.ticketing-services-content').scrollTop(0);
            });
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('travel_services', 'travel_services_shortcode');


// Admin Settings Page
function travel_services_admin_menu() {
    add_options_page(
        'Travel Services Settings',
        'Travel Services',
        'manage_options',
        'travel-services-settings',
        'travel_services_admin_page'
    );
}
add_action('admin_menu', 'travel_services_admin_menu');

function travel_services_admin_page() {
    if (!current_user_can('manage_options')) {
        return;
    }
    ?>
    <div class="wrap">
        <h1>Travel Services Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('travel_services_options');
            do_settings_sections('travel-services-settings');
            submit_button('Save Settings');
            ?>
        </form>
    </div>
    <?php
}

function travel_services_settings_init() {
    register_setting(
        'travel_services_options',
        'travel_services_options',
        [
            'sanitize_callback' => 'travel_services_sanitize_options',
            'default' => [
                'air_ticketing_title' => 'Air Ticketing and Hotel Booking',
                'travel_coordination_title' => 'Travel Coordination',
                'leisure_travel_title' => 'Leisure Travel Management',
                'travel_insurance_title' => 'Travel Insurance Arrangement',
                'traveler_profiling_title' => 'Traveler Profiling',
                'support_alerting_title' => '24/7 Support and Alerting'
            ]
        ]
    );

    // Sections
    $sections = [
        'air_ticketing' => 'Air Ticketing and Hotel Booking',
        'travel_coordination' => 'Travel Coordination',
        'leisure_travel' => 'Leisure Travel Management',
        'travel_insurance' => 'Travel Insurance Arrangement',
        'traveler_profiling' => 'Traveler Profiling',
        'support_alerting' => '24/7 Support and Alerting'
    ];

    foreach ($sections as $id => $title) {
        add_settings_section(
            "travel_services_{$id}",
            $title,
            null,
            'travel-services-settings'
        );

        add_settings_field(
            "{$id}_title",
            'Title',
            'travel_services_text_field',
            'travel-services-settings',
            "travel_services_{$id}",
            ['name' => "{$id}_title"]
        );

        add_settings_field(
            "{$id}_content",
            'Content',
            'travel_services_editor_field',
            'travel-services-settings',
            "travel_services_{$id}",
            ['name' => "{$id}_content"]
        );
    }
}
add_action('admin_init', 'travel_services_settings_init');

function travel_services_text_field($args) {
    $options = get_option('travel_services_options');
    $value = $options[$args['name']] ?? '';
    ?>
    <input type="text" class="regular-text" name="travel_services_options[<?php echo esc_attr($args['name']); ?>]" 
           value="<?php echo esc_attr($value); ?>">
    <?php
}

function travel_services_editor_field($args) {
    $options = get_option('travel_services_options');
    $content = $options[$args['name']] ?? '';
    wp_editor(
        wp_kses_post($content),
        'travel_services_' . sanitize_key($args['name']),
        [
            'textarea_name' => 'travel_services_options[' . $args['name'] . ']',
            'textarea_rows' => 10,
            'media_buttons' => true,
            'teeny' => false,
            'wpautop' => true
        ]
    );
}

function travel_services_sanitize_options($input) {
    $sanitized = [];
    
    foreach ($input as $key => $value) {
        if (strpos($key, 'content') !== false) {
            $sanitized[$key] = wp_kses_post($value);
        } else {
            $sanitized[$key] = sanitize_text_field($value);
        }
    }
    
    return $sanitized;
}

// Enqueue assets
function travel_services_enqueue_assets() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css', [], '5.15.4');
    wp_enqueue_style('travel-services-fonts', 'https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
    
    if (!wp_script_is('jquery', 'enqueued')) {
        wp_enqueue_script('jquery');
    }
}
add_action('wp_enqueue_scripts', 'travel_services_enqueue_assets');
?>