<?php

// Function to enable categories for WordPress pages
function add_categories_to_pages() {
    // Add the category taxonomy to pages
    register_taxonomy_for_object_type('category', 'page');
}
add_action('init', 'add_categories_to_pages');
function include_categories_in_pages($query) {
    if ($query->is_category() && $query->is_main_query()) {
        $query->set('post_type', array('post', 'page'));
    }
}
add_action('pre_get_posts', 'include_categories_in_pages');